  var System=require("../../../system");
var settings=require("../../../../config/settings");
var pinyin = require("pinyin");
const CtlBase = require("../../ctl.base");
class bigtmCtl extends CtlBase {
  constructor(){
    super("tmquery",CtlBase.getServiceName(bigtmCtl));
    this.logCtl = System.getObject("web.common.oplogCtl");
    this.tmquerySve=System.getObject("service.tmquery.tmquerySve");
    this.GsbByTmSearchApi=System.getObject("api.tmquery.bytmsearch");
    this.utilstmSve=System.getObject("service.tmquery.utilstmSve");
    this.utilscontent=System.getObject("service.tmquery.utilscontentfilterSve");
    this.tm_type={P:"普通商标",J:"集体商标",Z:"证明商标",T:"特殊商标"};
    this.tm_status={1:"申请中",2:"已初审",3:"已注册",4:"已无效",5:"其他"};
    this.imageQueryUrl=settings.apiconfig.imageQueryUrl();
    this.tm_gjfl={1:"01类 化学原料",2:"02类 颜料油漆",3:"03类 日化用品",4:"04类 燃料油脂",5:"05类 医药",6:"06类 金属材料",7:"07类 机械设备",8:"08类 手工器械",9:"09类 科学仪器",
                  10:"10类 医疗器械",11:"11类 灯具空调",12:"12类 运输工具",13:"13类 军火烟火",14:"14类 珠宝钟表",15:"15类 乐器",16:"16类 办公用品",17:"17类 橡胶制品",18:"18类 皮革皮具",19:"19类 建筑材料",20:"20类 家具",21:"21类 厨房洁具",22:"22类 绳网袋蓬",23:"23类 纱线丝",24:"24类 布料床单",
                  25:"25类 服装鞋帽",26:"26类 钮扣拉链",27:"27类 地毯席垫",28:"28类 健身器材",29:"29类 食品",30:"30类 方便食品",31:"31类 农林生鲜",32:"32类 啤酒饮料",33:"33类 酒",34:"34类 烟草烟具",35:"35类 广告销售",36:"36类 金融物管",37:"37类 建筑修理",38:"38类 通讯服务",
                  39:"39类 运输贮藏",40:"40类 材料加工",41:"41类 教育娱乐",42:"42类 科技服务",43:"43类 餐饮住宿",44:"44类 医疗园艺",45:"45类 社会服务"};
    this.province = ["安徽省", "福建省", "甘肃省", "广东省", "广西壮族自治区", "贵州省", "海南省", "河北省", "河南省", "黑龙江省", "湖北省", "湖南省", "吉林省", "江苏省", "江西省", "辽宁省", "内蒙古自治区", "宁夏回族自治区", "青海省", "山东省", "山西省",
                      "陕西省", "四川省", "西藏自治区", "新疆维吾尔自治区", "云南省", "浙江省", "北京市", "天津市", "上海市", "重庆市","香港特别行政区","台湾省","澳门特别行政区"]
    this.provincecity={"安徽省":["六安市","淮北市","铜陵市","阜阳市","宣城市","黄山市","合肥市","芜湖市","宿州市","亳州市","滁州市","池州市","安庆市","淮南市","马鞍山市","蚌埠市"],"福建省":["宁德市","厦门市","福州市","莆田市","泉州市"
    ,"漳州市","龙岩市","三明市","南平市"],"甘肃省":["定西市","临夏回族自治州","嘉峪关市","白银市","酒泉市","平凉市","天水市","庆阳市","陇南市","金昌市","武威市","兰州市","张掖市","甘南藏族自治州"],
    "广东省":["佛山市","东莞市","揭阳市","河源市","肇庆市","梅州市","珠海市","韶关市","深圳市","云浮市","江门市","潮州市","阳江市","茂名市","汕头市","汕尾市","广州市","湛江市","惠州市","清远市","中山市"],
    "广西壮族自治区":["贺州市","来宾市","河池市","崇左市","防城港市","北海市","柳州市","钦州市","百色市","梧州市","桂林市","玉林市","南宁市","贵港市"],
    "贵州省":["黔西南布依族苗族自治州","黔东南苗族侗族自治州","黔南布依族苗族自治州","遵义市","安顺市","毕节市","六盘水市","贵阳市","铜仁市"],"海南省":["海口市","三亚市","儋州市","三沙市"],
    "河北省":["秦皇岛市","保定市","石家庄市","衡水市","沧州市","邢台市","邯郸市","承德市","廊坊市","唐山市","张家口市"],
    "河南省":["商丘市","信阳市","许昌市","郑州市","鹤壁市","三门峡市","平顶山市","周口市","南阳市","漯河市","驻马店市","开封市","焦作市","洛阳市","新乡市","安阳市","濮阳市"],
    "黑龙江省":["大兴安岭地区","七台河市","黑河市","大庆市","哈尔滨市","双鸭山市","佳木斯市","鹤岗市","绥化市","牡丹江市","鸡西市","伊春市","齐齐哈尔市"],
    "湖北省":["孝感市","荆州市","荆门市","宜昌市","襄阳市","随州市","黄冈市","武汉市","鄂州市","十堰市","黄石市","咸宁市","恩施土家族苗族自治州"],
    "湖南省":["怀化市","常德市","株洲市","湘西土家族苗族自治州","益阳市","邵阳市","衡阳市","张家界市","郴州市","岳阳市","湘潭市","长沙市","娄底市","永州市"],
    "吉林省":["松原市","白城市","延边朝鲜族自治州","长春市","通化市","辽源市","吉林市","四平市","白山市"],
    "江苏省":["泰州市","南京市","南通市","常州市","镇江市","连云港市","徐州市","苏州市","无锡市","盐城市","宿迁市","扬州市","淮安市"],
    "江西省":["九江市","吉安市","新余市","抚州市","赣州市","鹰潭市","宜春市","萍乡市","景德镇市","南昌市","上饶市"],
    "辽宁省":["营口市","本溪市","铁岭市","沈阳市","盘锦市","鞍山市","丹东市","朝阳市","抚顺市","辽阳市","阜新市","葫芦岛市","锦州市","大连市"],
    "内蒙古自治区":["通辽市","赤峰市","巴彦淖尔市","鄂尔多斯市","乌兰察布市","阿拉善盟","呼伦贝尔市","锡林郭勒盟","乌海市","包头市","呼和浩特市","兴安盟"],
    "宁夏回族自治区":["中卫市","固原市","石嘴山市","吴忠市","银川市"],"青海省":["海西蒙古族藏族自治州","西宁市","黄南藏族自治州","玉树藏族自治州","果洛藏族自治州","海北藏族自治州","海南藏族自治州","海东市"],
    "山东省":["枣庄市","济宁市","菏泽市","济南市","潍坊市","青岛市","东营市","滨州市","淄博市","泰安市","烟台市","莱芜市","聊城市","威海市","日照市","临沂市","德州市"],
    "山西省":["晋城市","临汾市","大同市","阳泉市","吕梁市","晋中市","运城市","忻州市","长治市","朔州市","太原市"],
    "陕西省":["渭南市","延安市","咸阳市","铜川市","汉中市","西安市","商洛市","安康市","榆林市","宝鸡市"],
    "四川省":["绵阳市","德阳市","泸州市","广元市","宜宾市","南充市","自贡市","乐山市","资阳市","甘孜藏族自治州","雅安市","内江市","广安市","阿坝藏族羌族自治州","达州市","巴中市","凉山彝族自治州","遂宁市","眉山市","成都市","攀枝花市"],
    "西藏自治区":["日喀则市","昌都市","那曲市","阿里地区","拉萨市","山南市","林芝市"],"新疆维吾尔自治区":["喀什地区","阿勒泰地区","哈密市","克拉玛依市","博尔塔拉蒙古自治州","吐鲁番市","和田地区","伊犁哈萨克自治州","巴音郭楞蒙古自治州","塔城地区","乌鲁木齐市","克孜勒苏柯尔克孜自治州","昌吉回族自治州","阿克苏地区"],
    "云南省":["楚雄彝族自治州","西双版纳傣族自治州","德宏傣族景颇族自治州","怒江傈僳族自治州","丽江市","红河哈尼族彝族自治州","大理白族自治州","迪庆藏族自治州","保山市","临沧市","文山壮族苗族自治州","昆明市","曲靖市","玉溪市","昭通市","普洱市"],
    "浙江省":["杭州市","丽水市","温州市","嘉兴市","宁波市","衢州市","金华市","台州市","湖州市","舟山市","绍兴市"],
    "北京市":["石景山区","房山区","海淀区","通州区","西城区","延庆区","丰台区","昌平区","东城区","门头沟区","怀柔区","顺义区","平谷区","大兴区","朝阳区","密云区"],
    "天津市":["滨海新区","河西区","河北区","南开区","津南区","静海区","蓟州区","河东区","红桥区","武清区","东丽区","西青区","宝坻区","和平区","宁河区","北辰区"],
    "上海市":["宝山区","嘉定区","闵行区","浦东新区","徐汇区","青浦区","长宁区","松江区","静安区","黄浦区","普陀区","奉贤区","崇明区","虹口区","杨浦区","金山区"],
    "重庆市":["巫溪县","涪陵区","南岸区","璧山区","渝中区","北碚区","奉节县","荣昌区","潼南区","铜梁区","彭水苗族土家族自治县","南川区","忠县","梁平区","九龙坡区","开州区","渝北区","大足区","合川区","垫江县","酉阳土家族苗族自治县","长寿区","云阳县","黔江区","巴南区","沙坪坝区","城口县","丰都县","江津区","大渡口区","永川区","石柱土家族自治县","武隆区","綦江区","秀山土家族苗族自治县","江北区","万州区","巫山县"]}

  }
  async getprovincename(cnname) {//省份简称对应关系,全称对简称
    var mapobj = {
      "北京市": "北京",
      "山东省": "山东",
      "广西壮族自治区": "广西",
      "广东省": "广东",
      "内蒙古自治区": "内蒙古",
      "河北省": "河北",
      "黑龙江省": "黑龙江",
      "江苏省": "江苏",
      "天津市": "天津",
      "福建省": "福建",
      "浙江省": "浙江",
      "陕西省": "陕西",
      "安徽省": "安徽",
      "上海市": "上海",
      "贵州省": "贵州",
      "山西省": "山西",
      "重庆市": "重庆",
      "湖北省": "湖北",
      "四川省": "四川",
      "甘肃省": "甘肃",
      "湖南省": "湖南",
      "河南省": "河南",
      "辽宁省": "辽宁",
      "海南省": "海南",
      "江西省": "江西",
      "云南省": "云南",
      "新疆维吾尔自治区": "新疆",
      "宁夏回族自治区": "宁夏",
      "吉林省": "吉林",
      "西藏自治区": "西藏",
      "青海省": "青海",
      "香港特别行政区": "香港",
      "台湾省": "台湾",
      "澳门特别行政区": "澳门"
    };

    if (mapobj.hasOwnProperty(cnname)) {
      return mapobj[cnname];
    }
    else {
      return null;
    }

  };

  async getprovincenameorder(cnname) {//省份简称对应关系,简称对全称
      var mapobj = {
        "北京": "北京市",
        "山东": "山东省",
        "广西": "广西壮族自治区",
        "广东": "广东省",
        "内蒙古": "内蒙古自治区",
        "河北": "河北省",
        "黑龙江": "黑龙江省",
        "江苏": "江苏省",
        "天津": "天津市",
        "福建": "福建省",
        "浙江": "浙江省",
        "陕西": "陕西省",
        "安徽": "安徽省",
        "上海": "上海市",
        "贵州": "贵州省",
        "山西": "山西省",
        "重庆": "重庆市",
        "湖北": "湖北省",
        "四川": "四川省",
        "甘肃": "甘肃省",
        "湖南": "湖南省",
        "河南": "河南省",
        "辽宁": "辽宁省",
        "海南": "海南省",
        "江西": "江西省",
        "云南": "云南省",
        "新疆": "新疆维吾尔自治区",
        "宁夏": "宁夏回族自治区",
        "吉林": "吉林省",
        "西藏": "西藏自治区",
        "青海": "青海省",
        "香港": "香港",
        "台湾": "台湾省",
        "澳门": "澳门"
      };

      if (mapobj.hasOwnProperty(cnname)) {
        return mapobj[cnname];
      }
      else {
        return null;
      }
    };

  //商标大数据首页数据
  async tmindexdetail(query,obj){
    console.log("ttttttttttttttttttttttttttttttttttt");
    console.log(obj);
    var result ={tmtotal:"",tmzctotal:"",tmsqtotal:"",tmgstotal:"",maplist:[],tmaddrrank:[],tmcompanyrank:[],tmnclrank:[]};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.getprovincenameorder(apply_addr_province);
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    var tm =await this.tmquerySve.bigtmcount(tmobj);//商标总量接口
    // console.log(sqtm);
    if(tm.status==0){
      result.tmtotal=tm.data.tmtotal;
    }
    var zctm =await this.tmquerySve.bigtmregistcount(tmobj);//商标有效注册量
    // console.log(zctm);
    if(zctm.status==0){
      result.tmzctotal=zctm.data.tmregtotal;
    }
    var sqtm =await this.tmquerySve.bigtmapplicationcount(tmobj);//商标申请中总量
    // console.log(zctm);
    if(sqtm.status==0){
      result.tmsqtotal=sqtm.data.tmsqtotal;
    }
    var gstm =await this.tmquerySve.bigtmcompanycount(tmobj);//商标企业总量
    if(gstm.status==0){
      result.tmgstotal=gstm.data.tmcompanytotal;
    }
    if(apply_addr_province!=""&&apply_addr_province!=null){
      var citys = this.provincecity[apply_addr_province];
      console.log(citys);
      //商标地区排名省份
      var tmaddr =await this.tmquerySve.bigtmaddrrank(tmobj);
      if(tmaddr.status==0){
        // console.log("ppppppppppppppppppppppppppppppppppppppp");
        // console.log(tmaddr.data.tmaddrrank);
        var maps=[];
        var sources =[];
        for(var i=0;i<tmaddr.data.tmaddrrank.length;i++){
          if(citys.indexOf(tmaddr.data.tmaddrrank[i].code)>=0){
            var ss = {
              "areaname":tmaddr.data.tmaddrrank[i].code,
              "areacount":tmaddr.data.tmaddrrank[i].count
            }
            var mp={
              "name":tmaddr.data.tmaddrrank[i].code,
              "value":tmaddr.data.tmaddrrank[i].count
            }
            maps.push(mp);
            sources.push(ss);
          }
        }
        var tk = [];
        if(sources.length>0){
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.maplist=maps;
          result.tmaddrrank=tk;
        }
      }
      //商标企业排名
      var tmcompany =await this.tmquerySve.bigtmcompanyrank(tmobj);
      if(tmcompany.status==0){
        var sources =[];
        for(var i=0;i<tmcompany.data.tmcompanyrank.length;i++){
          if(citys.indexOf(tmcompany.data.tmcompanyrank[i].code)>=0){
            var ss = {
              "areaname":tmcompany.data.tmcompanyrank[i].code,
              "areacount":tmcompany.data.tmcompanyrank[i].count.value
            }
            sources.push(ss);
          }
        }
        if(sources.length>0){
          sources.sort(function(a,b){
            return b.areacount - a.areacount;
          });
          var tk = [];
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.tmcompanyrank=tk;
        }
      }
    }else{//全国查询
      //商标地区排名省份
      var tmaddr =await this.tmquerySve.bigtmaddrrank(tmobj);
      console.log(tmaddr);
      var sources =[];
      var maps=[];
      if(tmaddr.status==0){
        for(var i=0;i<tmaddr.data.tmaddrrank.length;i++){
          if(this.province.indexOf(tmaddr.data.tmaddrrank[i].code)>=0){
            var areaname = await this.getprovincename(tmaddr.data.tmaddrrank[i].code);
            var ss = {
              "areaname":tmaddr.data.tmaddrrank[i].code,
              "areacount":tmaddr.data.tmaddrrank[i].count
            }
            var mp={
              "name":areaname,
              "value":tmaddr.data.tmaddrrank[i].count
            }
            sources.push(ss);
            maps.push(mp);
          }
        }
        if(sources.length>0){
          var tk = [];
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.tmaddrrank=tk;
          result.maplist=maps;
        }
      }
      //商标企业排名
      var tmcompany =await this.tmquerySve.bigtmcompanyrank(tmobj);
      if(tmcompany.status==0){
        var sources =[];
        for(var i=0;i<tmcompany.data.tmcompanyrank.length;i++){
          if(this.province.indexOf(tmcompany.data.tmcompanyrank[i].code)>=0){
            var areaname = await this.getprovincename(tmcompany.data.tmcompanyrank[i].code);
            var ss = {
              "areaname":areaname,
              "areacount":tmcompany.data.tmcompanyrank[i].count.value
            }
            sources.push(ss);
          }
        }
        console.log("ccccccccccccccccccccccccccccccccccccccccc");
        console.log(sources);
        if(sources.length>0){
          sources.sort(function(a,b){
            return b.areacount - a.areacount;
          });
          var tk = [];
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.tmcompanyrank=tk;
        }
      }
    }

    //商标大类排名
    var tmncl =await this.tmquerySve.bigtmnclrank(tmobj);
    var codes=["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13",
    "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
    "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39",
    "40", "41", "42", "43", "44", "45"];
    if(tmncl.status==0){
      var sources=[];
      for(var k=0;k<tmncl.data.tmnclrank.length;k++){
        if(codes.indexOf(tmncl.data.tmnclrank[k].code)>=0){
          // sqtotal.code=sqtm.data.tmcount[i].count;
          sources.push({
            "code":tmncl.data.tmnclrank[k].code,
            "count":tmncl.data.tmnclrank[k].count,
          });
        }
      }
      if(sources.length>0){
        var tk = [];
        var sum = sources[0].count;
        for(var i=0;i< sources.length;i++){
          var bf = parseInt(100*(sources[i].count/sum));
          var ss = {
            "code":sources[i].code,
            "count":sources[i].count,
            "hundred":bf
          }
          tk.push(ss);
        }
        result.tmnclrank=tk;
      }
    }
    console.log("================================");
    console.log(result);
    return System.getResult2(result,null);

  }
  //商标统计接口总量、有效、申请
  async tmstatistics(query,obj){
    console.log("tttttttttttttttttmstatisticsttttttttttttttttttt");
    console.log(obj);
    var result ={tmtotal:"",tmzctotal:"",tmsqtotal:""};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.getprovincenameorder(apply_addr_province);
      this.logCtl.info({
        optitle: "商标统计接口总量、有效、申请返回信息----apply_addr_province",
        op: "",
        content: apply_addr_province,
        clientIp:  ""
      });
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    var tm =await this.tmquerySve.bigtmcount(tmobj);//商标总量接口
    this.logCtl.info({
      optitle: "商标统计接口总量、有效、申请返回信息----tm",
      op: "",
      content: JSON.stringify(tm),
      clientIp:  ""
    });
    // console.log(sqtm);
    if(tm.status==0){
      result.tmtotal=tm.data.tmtotal;
    }
    var zctm =await this.tmquerySve.bigtmregistcount(tmobj);//商标有效注册量
    this.logCtl.info({
      optitle: "商标统计接口总量、有效、申请返回信息----zctm",
      op: "",
      content: JSON.stringify(zctm),
      clientIp:  ""
    });
    // console.log(zctm);
    if(zctm.status==0){
      result.tmzctotal=zctm.data.tmregtotal;
    }
    var sqtm =await this.tmquerySve.bigtmapplicationcount(tmobj);//商标申请中总量
    this.logCtl.info({
      optitle: "商标统计接口总量、有效、申请返回信息----sqtm",
      op: "",
      content: JSON.stringify(sqtm),
      clientIp:  ""
    });
    // console.log(zctm);
    if(sqtm.status==0){
      result.tmsqtotal=sqtm.data.tmsqtotal;
    }
    console.log("================================");
    console.log(result);
    this.logCtl.info({
      optitle: "商标统计接口总量、有效、申请返回信息----result",
      op: "",
      content: JSON.stringify(result),
      clientIp:  ""
    });
    return System.getResult2(result,null);
  }
  //商标统计接口公司总量
  async tmcompanystatistics(query,obj){
    console.log("ttttttttttttttttttttttttttttttttttt");
    console.log(obj);
    var result ={tmgstotal:""};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.getprovincenameorder(apply_addr_province);
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    var gstm =await this.tmquerySve.bigtmcompanycount(tmobj);//商标企业总量
    if(gstm.status==0){
      result.tmgstotal=gstm.data.tmcompanytotal;
    }
    console.log("================================");
    console.log(result);
    return System.getResult2(result,null);
  }
  //商标地区分布统计排名
  async tmaddrstatisticsrank(query,obj){
    console.log("ttttttttttttttttttttttttttttttttttt");
    console.log(obj);
    var result ={maplist:[],tmaddrrank:[]};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.getprovincenameorder(apply_addr_province);
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    if(apply_addr_province!=""&&apply_addr_province!=null){
      var citys = this.provincecity[apply_addr_province];
      console.log(citys);
      //商标地区排名省份
      var tmaddr =await this.tmquerySve.bigtmaddrrank(tmobj);
      if(tmaddr.status==0){
        // console.log("ppppppppppppppppppppppppppppppppppppppp");
        // console.log(tmaddr.data.tmaddrrank);
        var maps=[];
        var sources =[];
        for(var i=0;i<tmaddr.data.tmaddrrank.length;i++){
          if(citys.indexOf(tmaddr.data.tmaddrrank[i].code)>=0){
            var ss = {
              "areaname":tmaddr.data.tmaddrrank[i].code,
              "areacount":tmaddr.data.tmaddrrank[i].count
            }
            var mp={
              "name":tmaddr.data.tmaddrrank[i].code,
              "value":tmaddr.data.tmaddrrank[i].count
            }
            maps.push(mp);
            sources.push(ss);
          }
        }
        var tk = [];
        if(sources.length>0){
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.maplist=maps;
          result.tmaddrrank=tk;
        }
      }
    }else{//全国查询
      //商标地区排名省份
      var tmaddr =await this.tmquerySve.bigtmaddrrank(tmobj);
      console.log(tmaddr);
      var sources =[];
      var maps=[];
      if(tmaddr.status==0){
        for(var i=0;i<tmaddr.data.tmaddrrank.length;i++){
          if(this.province.indexOf(tmaddr.data.tmaddrrank[i].code)>=0){
            var areaname = await this.getprovincename(tmaddr.data.tmaddrrank[i].code);
            var ss = {
              "areaname":tmaddr.data.tmaddrrank[i].code,
              "areacount":tmaddr.data.tmaddrrank[i].count
            }
            var mp={
              "name":areaname,
              "value":tmaddr.data.tmaddrrank[i].count
            }
            sources.push(ss);
            maps.push(mp);
          }
        }
        if(sources.length>0){
          var tk = [];
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.tmaddrrank=tk;
          result.maplist=maps;
        }
      }
    }
    console.log("================================");
    console.log(result);
    return System.getResult2(result,null);
  }
  //商标企业分布统计排名
  async tmcompanystatisticsrank(query,obj){
    console.log("ttttttttttttttttttttttttttttttttttt");
    console.log(obj);
    var result ={tmcompanyrank:[]};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.getprovincenameorder(apply_addr_province);
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    var citys = this.provincecity[apply_addr_province];
    if(apply_addr_province!=""&&apply_addr_province!=null){
      //商标企业排名
      var tmcompany =await this.tmquerySve.bigtmcompanyrank(tmobj);
      if(tmcompany.status==0){
        var sources =[];
        for(var i=0;i<tmcompany.data.tmcompanyrank.length;i++){
          if(citys.indexOf(tmcompany.data.tmcompanyrank[i].code)>=0){
            var ss = {
              "areaname":tmcompany.data.tmcompanyrank[i].code,
              "areacount":tmcompany.data.tmcompanyrank[i].count.value
            }
            sources.push(ss);
          }
        }
        if(sources.length>0){
          sources.sort(function(a,b){
            return b.areacount - a.areacount;
          });
          var tk = [];
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.tmcompanyrank=tk;
        }
      }
    }else{//全国查询
      //商标企业排名
      var tmcompany =await this.tmquerySve.bigtmcompanyrank(tmobj);
      if(tmcompany.status==0){
        var sources =[];
        for(var i=0;i<tmcompany.data.tmcompanyrank.length;i++){
          if(this.province.indexOf(tmcompany.data.tmcompanyrank[i].code)>=0){
            var areaname = await this.getprovincename(tmcompany.data.tmcompanyrank[i].code);
            var ss = {
              "areaname":areaname,
              "areacount":tmcompany.data.tmcompanyrank[i].count.value
            }
            sources.push(ss);
          }
        }
        if(sources.length>0){
          sources.sort(function(a,b){
            return b.areacount - a.areacount;
          });
          var tk = [];
          var sum = sources[0].areacount;
          for(var k=0;k<sources.length;k++){
            var bf = parseInt(100*(sources[k].areacount/sum));
            var ss = {
              "areaname":sources[k].areaname,
              "areacount":sources[k].areacount,
              "areahundred":bf
            }
            tk.push(ss);
          }
          result.tmcompanyrank=tk;
        }
      }
    }
    console.log("================================");
    console.log(result);
    return System.getResult2(result,null);
  }
  //商标类别申请排名
  async tmnclstatisticsrank(query,obj){
    console.log("ttttttttttttttttttttttttttttttttttt");
    console.log(obj);
    var result ={tmnclrank:[]};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.getprovincenameorder(apply_addr_province);
    }
    var tmobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province
    };
    //商标大类排名
    var tmncl =await this.tmquerySve.bigtmnclrank(tmobj);
    var codes=["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13",
    "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
    "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39",
    "40", "41", "42", "43", "44", "45"];
    if(tmncl.status==0){
      var sources=[];
      for(var k=0;k<tmncl.data.tmnclrank.length;k++){
        if(codes.indexOf(tmncl.data.tmnclrank[k].code)>=0){
          // sqtotal.code=sqtm.data.tmcount[i].count;
          sources.push({
            "code":tmncl.data.tmnclrank[k].code,
            "count":tmncl.data.tmnclrank[k].count,
          });
        }
      }
      if(sources.length>0){
        var tk = [];
        var sum = sources[0].count;
        for(var i=0;i< sources.length;i++){
          var bf = parseInt(100*(sources[i].count/sum));
          var ss = {
            "code":sources[i].code,
            "count":sources[i].count,
            "hundred":bf
          }
          tk.push(ss);
        }
        result.tmnclrank=tk;
      }
    }
    console.log("================================");
    console.log(result);
    return System.getResult2(result,null);
  }
  //商标申请及注册趋势
  async tmtrend(query,obj){
    var result={sqtrend:{name:"商标申请",data:[]},zctrend:{name:"商标注册",data:[]}};
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.getprovincenameorder(apply_addr_province);
    }
    var sq2019=0;
    var sq2018=0;
    var sq2017=0;
    var sq2016=0;
    var sq2015=0;
    var sq2014=0;
    var sqobj={
      apply_addr_province:apply_addr_province,
      status:1,
      seltype:5
    };
    var sqtm =await this.tmquerySve.bigtmtrend(sqobj);//商标申请趋势
    if(sqtm.status==0){
      for(var i in sqtm.data.tmtrend){
        if(sqtm.data.tmtrend[i].code==2019){
          sq2019=sqtm.data.tmtrend[i].count;
        }
        if(sqtm.data.tmtrend[i].code==2018){
          sq2018=sqtm.data.tmtrend[i].count;
        }
        if(sqtm.data.tmtrend[i].code==2017){
          sq2017=sqtm.data.tmtrend[i].count;
        }
        if(sqtm.data.tmtrend[i].code==2016){
          sq2016=sqtm.data.tmtrend[i].count;
        }
        if(sqtm.data.tmtrend[i].code==2015){
          sq2015=sqtm.data.tmtrend[i].count;
        }
        if(sqtm.data.tmtrend[i].code==2014){
          sq2014=sqtm.data.tmtrend[i].count;
        }
      }
      result.sqtrend.data.push(sq2014);
      result.sqtrend.data.push(sq2015);
      result.sqtrend.data.push(sq2016);
      result.sqtrend.data.push(sq2017);
      result.sqtrend.data.push(sq2018);
      result.sqtrend.data.push(sq2019);
    }
    var zcobj={
      apply_addr_province:apply_addr_province,
      status:3,
      seltype:4
    };
    var zctm =await this.tmquerySve.bigtmtrend(zcobj);//商标注册趋势
    var zc2019=0;
    var zc2018=0;
    var zc2017=0;
    var zc2016=0;
    var zc2015=0;
    var zc2014=0;
    if(zctm.status==0){
      for(var j in zctm.data.tmtrend){
        if(zctm.data.tmtrend[j].code==2019){
          zc2019=zctm.data.tmtrend[j].count;
        }
        if(zctm.data.tmtrend[j].code==2018){
          zc2018=zctm.data.tmtrend[j].count;
        }
        if(zctm.data.tmtrend[j].code==2017){
          zc2017=zctm.data.tmtrend[j].count;
        }
        if(zctm.data.tmtrend[j].code==2016){
          zc2016=zctm.data.tmtrend[j].count;
        }
        if(zctm.data.tmtrend[j].code==2015){
          zc2015=zctm.data.tmtrend[j].count;
        }
        if(zctm.data.tmtrend[j].code==2014){
          zc2014=zctm.data.tmtrend[j].count;
        }
      }
      result.zctrend.data.push(zc2014);
      result.zctrend.data.push(zc2015);
      result.zctrend.data.push(zc2016);
      result.zctrend.data.push(zc2017);
      result.zctrend.data.push(zc2018);
      result.zctrend.data.push(zc2019);
    }
    return System.getResult2(result,null);
  }
  //商标类别申请排名详情
  async tmnclrankdetail(query,obj){
    var result={sqtotalX:[],sqtotalY:[],zctotalX:[],zctotalY:[],yearsqtotalX:[],yearsqtotalY:[],yearzctotalX:[],yearzctotalY:[],datalist:[]};
    var sqtotal={};
    var zctotal={};
    var yearsqtotal={};
    var yearzctotal={};
    var codes=["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13",
    "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
    "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39",
    "40", "41", "42", "43", "44", "45"];
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.getprovincenameorder(apply_addr_province);
    }
    var sqobj={
      apply_addr_province:apply_addr_province,
      status:1,
      seltype:3
    };
    var sqtm =await this.tmquerySve.bigtmcountjuhe(sqobj);//商标类别申请排名详情--申请聚合
    // console.log(sqtm);
    if(sqtm.status==0){
      for(var i in sqtm.data.tmcount){
        if(codes.indexOf(sqtm.data.tmcount[i].code)>=0){
          // sqtotal.code=sqtm.data.tmcount[i].count;
          console.log(sqtm.data.tmcount[i].code);
          sqtotal[sqtm.data.tmcount[i].code]=sqtm.data.tmcount[i].count;
          result.sqtotalX.push(sqtm.data.tmcount[i].code);
          result.sqtotalY.push(sqtm.data.tmcount[i].count);
        }
      }
    }
    var zcobj={
      apply_addr_province:apply_addr_province,
      status:3,
      seltype:3
    };
    var zctm =await this.tmquerySve.bigtmcountjuhe(zcobj);//商标类别申请排名详情--注册聚合
    // console.log(zctm);
    if(zctm.status==0){
      for(var i in zctm.data.tmcount){
        if(codes.indexOf(zctm.data.tmcount[i].code)>=0){
          zctotal[zctm.data.tmcount[i].code]=zctm.data.tmcount[i].count;
          result.zctotalX.push(zctm.data.tmcount[i].code);
          result.zctotalY.push(zctm.data.tmcount[i].count);
        }
      }
    }
    var yearsqobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province,
      status:1,
      seltype:3
    };
    var yearsqtm =await this.tmquerySve.bigtmcountyearjuhe(yearsqobj);//商标类别申请排名详情--注册聚合--year
    // console.log(yearsqtm);
    if(yearsqtm.status==0){
      for(var i in yearsqtm.data.tmyearcount){
        if(codes.indexOf(yearsqtm.data.tmyearcount[i].code)>=0){
          yearsqtotal[yearsqtm.data.tmyearcount[i].code]=yearsqtm.data.tmyearcount[i].count;
          result.yearsqtotalX.push(yearsqtm.data.tmyearcount[i].code);
          result.yearsqtotalY.push(yearsqtm.data.tmyearcount[i].count);
        }
      }
    }
    var yearzcobj={
      tmreg_year:tmreg_year,
      apply_addr_province:apply_addr_province,
      status:3,
      seltype:3
    };
    var yearzctm =await this.tmquerySve.bigtmcountyearjuhe(yearzcobj);//商标类别申请排名详情--注册聚合--year
    if(yearzctm.status==0){
      for(var i in yearzctm.data.tmyearcount){
        if(codes.indexOf(yearzctm.data.tmyearcount[i].code)>=0){
          yearzctotal[yearzctm.data.tmyearcount[i].code]=yearzctm.data.tmyearcount[i].count;
          result.yearzctotalX.push(yearzctm.data.tmyearcount[i].code);
          result.yearzctotalY.push(yearzctm.data.tmyearcount[i].count);
        }
      }
    }
    var sources=[];
    for(var k in codes){
      var cd = codes[k];
      var sq = sqtotal[cd]==null?0:sqtotal[cd];
      var zc = zctotal[cd]==null?0:zctotal[cd];
      var ysq = yearsqtotal[cd]==null?0:yearsqtotal[cd];
      var yzc = yearzctotal[cd]==null?0:yearzctotal[cd];
      var lt ={
        "name":cd,
        "sqt":sq,
        "zct":zc,
        "ysqt":ysq,
        "yzct":yzc
      };
      sources.push(lt);
    }
    result.datalist=sources;
    return System.getResult2(result,null);
  }
  //商标地区分布统计排名详情
  async tmaddressrankdetail(query,obj){
    var result={sqtotalX:[],sqtotalY:[],zctotalX:[],zctotalY:[],
      yearsqtotalX:[],yearsqtotalY:[],yearzctotalX:[],yearzctotalY:[],datalist:[]};
    var sqtotal={};
    var zctotal={};
    var yearsqtotal={};
    var yearzctotal={};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.getprovincenameorder(apply_addr_province);
      var provincecitys = this.provincecity[apply_addr_province];
      var sqobj={
        apply_addr_province:apply_addr_province,
        status:1,
        seltype:2
      };
      var sqtm =await this.tmquerySve.bigtmcountjuhe(sqobj);//商标地区申请排名详情--申请聚合
      if(sqtm.status==0){
        for(var i in sqtm.data.tmcount){
          if(provincecitys.indexOf(sqtm.data.tmcount[i].code)>=0){
            sqtotal[sqtm.data.tmcount[i].code]=sqtm.data.tmcount[i].count;
            result.sqtotalX.push(sqtm.data.tmcount[i].code);
            result.sqtotalY.push(sqtm.data.tmcount[i].count);
          }
        }
      }
      var zcobj={
        apply_addr_province:apply_addr_province,
        status:3,
        seltype:2
      };
      var zctm =await this.tmquerySve.bigtmcountjuhe(zcobj);//商标地区申请排名详情--注册聚合
      if(zctm.status==0){
        for(var i in zctm.data.tmcount){
          if(provincecitys.indexOf(zctm.data.tmcount[i].code)>=0){
            zctotal[zctm.data.tmcount[i].code]=zctm.data.tmcount[i].count;
            result.zctotalX.push(zctm.data.tmcount[i].code);
            result.zctotalY.push(zctm.data.tmcount[i].count);
          }
        }
      }
      var yearsqobj={
        tmreg_year:tmreg_year,
        apply_addr_province:apply_addr_province,
        status:1,
        seltype:2
      };
      var yearsqtm =await this.tmquerySve.bigtmcountyearjuhe(yearsqobj);//商标地区申请排名详情--注册聚合--year
      if(yearsqtm.status==0){
        for(var i in yearsqtm.data.tmyearcount){
          if(provincecitys.indexOf(yearsqtm.data.tmyearcount[i].code)>=0){
            yearsqtotal[yearsqtm.data.tmyearcount[i].code]=yearsqtm.data.tmyearcount[i].count;
            result.yearsqtotalX.push(yearsqtm.data.tmyearcount[i].code);
            result.yearsqtotalY.push(yearsqtm.data.tmyearcount[i].count);
          }
        }
      }
      var yearzcobj={
        tmreg_year:tmreg_year,
        apply_addr_province:apply_addr_province,
        status:3,
        seltype:2
      };
      var yearzctm =await this.tmquerySve.bigtmcountyearjuhe(yearzcobj);//商标地区申请排名详情--注册聚合--year
      if(yearzctm.status==0){
        for(var i in yearzctm.data.tmyearcount){
          if(provincecitys.indexOf(yearzctm.data.tmyearcount[i].code)>=0){
            yearzctotal[yearzctm.data.tmyearcount[i].code]=yearzctm.data.tmyearcount[i].count;
            result.yearzctotalX.push(yearzctm.data.tmyearcount[i].code);
            result.yearzctotalY.push(yearzctm.data.tmyearcount[i].count);
          }
        }
      }
      var sources=[];
      for(var k in provincecitys){
        var cd = provincecitys[k];
        var sq = sqtotal[cd]==null?0:sqtotal[cd];
        var zc = zctotal[cd]==null?0:zctotal[cd];
        var ysq = yearsqtotal[cd]==null?0:yearsqtotal[cd];
        var yzc = yearzctotal[cd]==null?0:yearzctotal[cd];
        var lt ={
          "name":cd,
          "sqt":sq,
          "zct":zc,
          "ysqt":ysq,
          "yzct":yzc
        };
        sources.push(lt);
      }
      result.datalist=sources;
    }else{
      var sqobj={
        apply_addr_province:apply_addr_province,
        status:1,
        seltype:1
      };
      var sqtm =await this.tmquerySve.bigtmcountjuhe(sqobj);//商标地区申请排名详情--申请聚合
      if(sqtm.status==0){
        for(var i in sqtm.data.tmcount){
          if(this.province.indexOf(sqtm.data.tmcount[i].code)>=0){
            sqtotal[sqtm.data.tmcount[i].code]=sqtm.data.tmcount[i].count;
            result.sqtotalX.push(sqtm.data.tmcount[i].code);
            result.sqtotalY.push(sqtm.data.tmcount[i].count);
          }
        }
      }
      var zcobj={
        apply_addr_province:apply_addr_province,
        status:3,
        seltype:1
      };
      var zctm =await this.tmquerySve.bigtmcountjuhe(zcobj);//商标地区申请排名详情--注册聚合
      if(zctm.status==0){
        for(var i in zctm.data.tmcount){
          if(this.province.indexOf(zctm.data.tmcount[i].code)>=0){
            zctotal[zctm.data.tmcount[i].code]=zctm.data.tmcount[i].count;
            result.zctotalX.push(zctm.data.tmcount[i].code);
            result.zctotalY.push(zctm.data.tmcount[i].count);
          }
        }
      }
      var yearsqobj={
        tmreg_year:tmreg_year,
        apply_addr_province:apply_addr_province,
        status:1,
        seltype:1
      };
      var yearsqtm =await this.tmquerySve.bigtmcountyearjuhe(yearsqobj);//商标地区申请排名详情--注册聚合--year
      if(yearsqtm.status==0){
        for(var i in yearsqtm.data.tmyearcount){
          if(this.province.indexOf(yearsqtm.data.tmyearcount[i].code)>=0){
            yearsqtotal[yearsqtm.data.tmyearcount[i].code]=yearsqtm.data.tmyearcount[i].count;
            result.yearsqtotalX.push(yearsqtm.data.tmyearcount[i].code);
            result.yearsqtotalY.push(yearsqtm.data.tmyearcount[i].count);
          }
        }
      }
      var yearzcobj={
        tmreg_year:tmreg_year,
        apply_addr_province:apply_addr_province,
        status:3,
        seltype:1
      };
      var yearzctm =await this.tmquerySve.bigtmcountyearjuhe(yearzcobj);//商标地区申请排名详情--注册聚合--year
      if(yearzctm.status==0){
        for(var i in yearzctm.data.tmyearcount){
          if(this.province.indexOf(yearzctm.data.tmyearcount[i].code)>=0){
            yearzctotal[yearzctm.data.tmyearcount[i].code]=yearzctm.data.tmyearcount[i].count;
            result.yearzctotalX.push(yearzctm.data.tmyearcount[i].code);
            result.yearzctotalY.push(yearzctm.data.tmyearcount[i].count);
          }
        }
      }
      var sources=[];
      for(var k in this.province){
        var cd = this.province[k];
        var sq = sqtotal[cd]==null?0:sqtotal[cd];
        var zc = zctotal[cd]==null?0:zctotal[cd];
        var ysq = yearsqtotal[cd]==null?0:yearsqtotal[cd];
        var yzc = yearzctotal[cd]==null?0:yearzctotal[cd];
        var lt ={
          "name":cd,
          "sqt":sq,
          "zct":zc,
          "ysqt":ysq,
          "yzct":yzc
        };
        sources.push(lt);
      }
      result.datalist=sources;
    }
    return System.getResult2(result,null);
  }
  //商标企业分布统计详情
  async tmcompanyrank(query,obj){
    var result={sqtotalX:[],sqtotalY:[],zctotalX:[],zctotalY:[],
      yearsqtotalX:[],yearsqtotalY:[],yearzctotalX:[],yearzctotalY:[],datalist:[]};
    var sqtotal={};
    var zctotal={};
    var yearsqtotal={};
    var yearzctotal={};
    var tmreg_year=obj.year==null?"":obj.year;
    var apply_addr_province = obj.apply_addr_province==null ?"":obj.apply_addr_province;
    if(apply_addr_province!=""&&apply_addr_province!=null){
      apply_addr_province = await this.getprovincenameorder(apply_addr_province);
      var provincecitys = this.provincecity[apply_addr_province];
      var sqobj={
        apply_addr_province:apply_addr_province,
        status:1,
        seltype:2
      };
      var sqtm =await this.tmquerySve.bigtmcompanyjuhe(sqobj);//商标类别申请排名详情--申请聚合
      // console.log(sqtm);
      if(sqtm.status==0){
        for(var i in sqtm.data.tmcompanycount){
          if(provincecitys.indexOf(sqtm.data.tmcompanycount[i].city)>=0){
            sqtotal[sqtm.data.tmcompanycount[i].city]=sqtm.data.tmcompanycount[i].count.value;
            result.sqtotalX.push(sqtm.data.tmcompanycount[i].city);
            result.sqtotalY.push(sqtm.data.tmcompanycount[i].count.value);
          }
        }
      }
      var zcobj={
        apply_addr_province:apply_addr_province,
        status:3,
        seltype:2
      };
      var zctm =await this.tmquerySve.bigtmcompanyjuhe(zcobj);//商标类别申请排名详情--注册聚合
      // console.log(zctm);
      if(zctm.status==0){
        for(var i in zctm.data.tmcompanycount){
          if(provincecitys.indexOf(zctm.data.tmcompanycount[i].city)>=0){
            zctotal[zctm.data.tmcompanycount[i].city]=zctm.data.tmcompanycount[i].count.value;
            result.zctotalX.push(zctm.data.tmcompanycount[i].city);
            result.zctotalY.push(zctm.data.tmcompanycount[i].count.value);
          }
        }
      }
      var yearsqobj={
        tmreg_year:tmreg_year,
        apply_addr_province:apply_addr_province,
        status:1,
        seltype:2
      };
      var yearsqtm =await this.tmquerySve.bigtmcompanyjuhe(yearsqobj);//商标类别申请排名详情--注册聚合--year
      // console.log(yearsqtm);
      if(yearsqtm.status==0){
        for(var i in yearsqtm.data.tmcompanycount){
          if(provincecitys.indexOf(yearsqtm.data.tmcompanycount[i].city)>=0){
            yearsqtotal[yearsqtm.data.tmcompanycount[i].city]=yearsqtm.data.tmcompanycount[i].count.value;
            result.yearsqtotalX.push(yearsqtm.data.tmcompanycount[i].city);
            result.yearsqtotalY.push(yearsqtm.data.tmcompanycount[i].count.value);
          }
        }
      }
      var yearzcobj={
        tmreg_year:tmreg_year,
        apply_addr_province:apply_addr_province,
        status:3,
        seltype:2
      };
      var yearzctm =await this.tmquerySve.bigtmcompanyjuhe(yearzcobj);//商标类别申请排名详情--注册聚合--year
      // console.log(yearzctm);
      if(yearzctm.status==0){
        for(var i in yearzctm.data.tmcompanycount){
          if(provincecitys.indexOf(yearzctm.data.tmcompanycount[i].city)>=0){
            yearzctotal[yearzctm.data.tmcompanycount[i].city]=yearzctm.data.tmcompanycount[i].count.value;
            result.yearzctotalX.push(yearzctm.data.tmcompanycount[i].city);
            result.yearzctotalY.push(yearzctm.data.tmcompanycount[i].count.value);
          }
        }
      }
      var sources=[];
      for(var k in provincecitys){
        var cd = provincecitys[k];
        var sq = sqtotal[cd]==null?0:sqtotal[cd];
        var zc = zctotal[cd]==null?0:zctotal[cd];
        var ysq = yearsqtotal[cd]==null?0:yearsqtotal[cd];
        var yzc = yearzctotal[cd]==null?0:yearzctotal[cd];
        var lt ={
          "name":cd,
          "sqt":sq,
          "zct":zc,
          "ysqt":ysq,
          "yzct":yzc
        };
        sources.push(lt);
      }
      result.datalist=sources;
    }else{
      var sqobj={
        apply_addr_province:apply_addr_province,
        status:1,
        seltype:1
      };
      var sqtm =await this.tmquerySve.bigtmcompanyjuhe(sqobj);//商标类别申请排名详情--申请聚合
      // console.log(sqtm);
      if(sqtm.status==0){
        for(var i in sqtm.data.tmcompanycount){
          if(this.province.indexOf(sqtm.data.tmcompanycount[i].city)>=0){
            sqtotal[sqtm.data.tmcompanycount[i].city]=sqtm.data.tmcompanycount[i].count.value;
            result.sqtotalX.push(sqtm.data.tmcompanycount[i].city);
            result.sqtotalY.push(sqtm.data.tmcompanycount[i].count.value);
          }
        }
      }
      var zcobj={
        apply_addr_province:apply_addr_province,
        status:3,
        seltype:1
      };
      var zctm =await this.tmquerySve.bigtmcompanyjuhe(zcobj);//商标类别申请排名详情--注册聚合
      // console.log(zctm);
      if(zctm.status==0){
        for(var i in zctm.data.tmcompanycount){
          if(this.province.indexOf(zctm.data.tmcompanycount[i].city)>=0){
            zctotal[zctm.data.tmcompanycount[i].city]=zctm.data.tmcompanycount[i].count.value;
            result.zctotalX.push(zctm.data.tmcompanycount[i].city);
            result.zctotalY.push(zctm.data.tmcompanycount[i].count.value);
          }
        }
      }
      var yearsqobj={
        tmreg_year:tmreg_year,
        apply_addr_province:apply_addr_province,
        status:1,
        seltype:1
      };
      var yearsqtm =await this.tmquerySve.bigtmcompanyjuhe(yearsqobj);//商标类别申请排名详情--注册聚合--year
      // console.log(yearsqtm);
      if(yearsqtm.status==0){
        for(var i in yearsqtm.data.tmcompanycount){
          if(this.province.indexOf(yearsqtm.data.tmcompanycount[i].city)>=0){
            yearsqtotal[yearsqtm.data.tmcompanycount[i].city]=yearsqtm.data.tmcompanycount[i].count.value;
            result.yearsqtotalX.push(yearsqtm.data.tmcompanycount[i].city);
            result.yearsqtotalY.push(yearsqtm.data.tmcompanycount[i].count.value);
          }
        }
      }
      var yearzcobj={
        tmreg_year:tmreg_year,
        apply_addr_province:apply_addr_province,
        status:3,
        seltype:1
      };
      var yearzctm =await this.tmquerySve.bigtmcompanyjuhe(yearzcobj);//商标类别申请排名详情--注册聚合--year
      // console.log(yearzctm);
      if(yearzctm.status==0){
        for(var i in yearzctm.data.tmcompanycount){
          if(this.province.indexOf(yearzctm.data.tmcompanycount[i].city)>=0){
            yearzctotal[yearzctm.data.tmcompanycount[i].city]=yearzctm.data.tmcompanycount[i].count.value;
            result.yearzctotalX.push(yearzctm.data.tmcompanycount[i].city);
            result.yearzctotalY.push(yearzctm.data.tmcompanycount[i].count.value);
          }
        }
      }
      var sources=[];
      for(var k in this.province){
        var cd = this.province[k];
        var sq = sqtotal[cd]==null?0:sqtotal[cd];
        var zc = zctotal[cd]==null?0:zctotal[cd];
        var ysq = yearsqtotal[cd]==null?0:yearsqtotal[cd];
        var yzc = yearzctotal[cd]==null?0:yearzctotal[cd];
        var lt ={
          "name":cd,
          "sqt":sq,
          "zct":zc,
          "ysqt":ysq,
          "yzct":yzc
        };
        sources.push(lt);
      }
      result.datalist=sources;
    }

    return System.getResult2(result,null);
  }

}
module.exports=bigtmCtl;

// var task = new bigtmCtl();
// var obj ={
//     regMan: "云飞",
//     sqlbtabkey: "",
//     flzttabkey: "",
//     sqnftabkey: "",
//     zcrname:"",
//     xcl: [],
//     pageSize: "20",
//     currentPage: "1"
// };
// task.findTrademarkzcr(obj).then(d=>{
//   console.log("ddddddddddddddddddddddddddddddddddddd");
//   console.log(d);
// })
// task.tmnclrankdetail({status:3,tmreg_year:2018,seltype:1,apply_addr_province:""}).then(d=>{
//   console.log("ddddddddddddddddddddddddddddddddddddd");
//     console.log(d);
// })
