const TaskBase=require("../task.base");
var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
class PlatformBalanceTask extends TaskBase{
  constructor(){
    super(TaskBase.getServiceName(PlatformBalanceTask));
    this.tradeSve=system.getObject("service.tradeSve");
    this.pAccountDao=system.getObject("db.pAccountDao");
    this.accountlogSve=system.getObject("service.accountlogSve");
  }
  async subDoTask(){
    await this.checkPlatformBalance();
  }
  async checkPlatformBalance(){
    var accounts = await this.pAccountDao.model.findAll({attributes:["id","baoBalance","renBalance"],raw:true});
    var that = this;
    var sumBao=0;
    var sumRen=0;
    if(accounts.length>0){
      var account = accounts[0];
      var trades = await this.tradeSve.dao.model.findAll({attributes:["id","baoAmount","renAmount","tradeType","status"],raw:true});
      trades.forEach(trade=>{
        // "fill": "充值", "consume": "消费", "gift": "赠送", "giftMoney": "红包", "refund": "退款","payment":"付款",
        //               "orderTrade": "订单交易", "orderRefund": "订单退款", "orderPersonFee": "订单个人分润",
        //               "orderPlatformFee": "订单平台分润","recommendFee": "推荐分润", "tmSubDeductCoin": "商标提报宝币扣除",
        //               "cashWithdrawal": "现金提现","platUseFee":"平台使用费","publicExpense":"官费","invoiceTaxes":"税费"
        //宝币：
        //  user: "fill": "充值", "consume": "消费", "gift": "赠送","tmSubDeductCoin": "商标提报宝币扣除",
        //  platform:
        //人民币：
        //  user: "fill": "充值","orderPersonFee": "订单个人分润","recommendFee": "推荐分润","cashWithdrawal": "现金提现",
        //  platform: "orderTrade": "订单交易","orderRefund": "订单退款","orderPlatformFee": "订单平台分润","platUseFee":"平台使用费","publicExpense":"官费","invoiceTaxes":"税费"

        sumBao=sumBao - Number(trade.baoAmount);
        if(trade.tradeType!="orderTrade" ){
          if(trade.tradeType=="fill" || trade.tradeType=="orderPersonFee" || trade.tradeType=="recommendFee" ){
            sumRen=(sumRen*10000-Number(trade.renAmount)*10000)/10000;
          }else if(trade.tradeType=="platformPayment" || trade.tradeType=="subPublicExpense"){
            sumRen=(sumRen*10000+Number(trade.renAmount)*10000)/10000;
          }
        }else{
          sumRen=(sumRen*10000+Number(trade.renAmount)*10000)/10000;
        }
      });
      if(sumBao==Number(account.baoBalance) && sumRen==Number(account.renBalance)){
        console.log(account.id+"---------------------------------success");
      }else{
        console.log(account.id+"+++++++++++"+sumBao+"++++++++++++++"+sumRen+"++++++++++++"+account.baoBalance+"++++++"+account.renBalance+"--");
        // var obj={id:account.id,baoBalance:sumBao,renBalance:sumRen};
        // var logObj={
        //   accountId:account.id,beforeBaoBalance:account.baoBalance,beforeRenBalance:account.renBalance,
        //   afterBaoBalance:sumBao,afterRenBalance:sumRen,logType:"platform"
        // };
        // var a = await that.tradeSve.db.transaction(async function (t){
        //   var accountUpdate = await that.pAccountDao.update(obj,t);
        //   var log = await that.accountlogSve.create(logObj,t);
        // });
      }
    }
  }




}
module.exports=PlatformBalanceTask;
// var task=new PlatformBalanceTask();
// task.checkPlatformBalance().then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
