const system = require("../system");

class InvoiceStatus {
    constructor() {
        this.finish="1090";
        this.unpay="1000";
        this.auditPass="1070";
        this.recall="1100";
        this.unAssignment="1020";//待分被
        this.pending="1030";//待处理
        this.cancleInvoice="1200";//红冲
        this.status = {
            "0090": {
                "status": "0090",
                "name": "未付款",
                "next": "1000",
                "cstatus": "0090",//客户
                "dstatus": "",//交付商
            },
            "1000": {
                "status": "1000",
                "name": "待审核",
                "next": "1020",
                "cstatus": "0090",//客户
                "dstatus": "",//交付商
            },
            "1010": {
                "status": "1010",
                "name": "审核不通过",
                "next": "",
                "cstatus": "1010",
                "dstatus": "",
            },
            "1020": {
                "status": "1020",
                "name": "待分配",
                "next": "1030",
                "cstatus": "1030",
                "dstatus": "",
            },
            "1030": {
                "status": "1030",
                "name": "待处理",
                "next": "1050",
                "cstatus": "1030",
                "dstatus": "1030",
            },
            "1040": {
                "status": "1040",
                "name": "交付商关闭",
                "next": "1020",
                "cstatus": "1030",
                "dstatus": "1040",
            },
            "1050": {
                "status": "1050",
                "name": "已开具",
                "next": "1060",
                "cstatus": "1050",
                "dstatus": "1050",
            },
            "1060": {
                "status": "1060",
                "name": "待审核",
                "next": "1070",
                "cstatus": "1050",
                "dstatus": "1070",
            },
            "1070": {
                "status": "1070",
                "name": "审核通过",
                "next": "1080",
                "cstatus": "1050",
                "dstatus": "1070",
            },
            "1080": {
                "status": "1080",
                "name": "已邮寄",
                "next": "1090",
                "cstatus": "1050",
                "dstatus": "1080",
            },
            "1090": {
                "status": "1090",
                "name": "完成",
                "next": "1100",
                "cstatus": "1090",
                "dstatus": "1080",
            },
            "1100": {
                "status": "1090",
                "name": "发票撤回",
                "next": "1100",
                "cstatus": "1090",
                "dstatus": "1080",
            },
            "1200": {
                "status": "1200",
                "name": "红冲",
                "next": "",
                "cstatus": "1200",
                "dstatus": "",
            },
            "1300": {
                "status": "1300",
                "name": "审核失败(平台第二次审核)",
                "next": "1060",
                "cstatus": "1050",
                "dstatus": "1060",
            }
        };
    }

    async findInvoiceBusinessStatus(status) {
        return this.invoiceStatus[status];
    }

    async findInvoiceNextBusinessStatus(status) {
        var curStatus = await this.findInvoiceBusinessStatus(status);
        if(!curStatus || !curStatus.next) {
            return;
        }

        return await this.findInvoiceBusinessStatus(curStatus.next);
    }
}

module.exports = InvoiceStatus;