/**
 *  发票计税算法-参数字典表
 */
const common = require("./common");
const system = require("../../system");
const valApi=require("./validate");

/**
 * 算法分发器
 */
module.exports.dispatcher=async (params)=>{
  try {
    if(!params.businessmenType){
      return system.getResult(-1,`参数错误 销售方类型不能为空`);
    }
    //加载算法类
    let businessmenType = common.trim(params.businessmenType);
    let filePath =`./algorithm/calInvoice${businessmenType}`;
    console.log(filePath);
    let calInvApi = require(filePath);
    if(!calInvApi){
      return system.getResult(-1,`系统错误 错误信息 算法不存在`);
    }
    let valCon ={};
    //验证参数
    valCon.businessmenType=common.trim(params.businessmenType);
    valCon.businessmenId=common.trim(params.businessmenId);
    valCon.businessmenCreditCode=common.trim(params.businessmenCreditCode);
    valCon.invoiceAmount=common.trim(params.invoiceAmount);
    //格式化参数
    let calCon = calInvApi.formatParams(params);
    if(calCon.hasOwnProperty("status")){
      return calCon;
    }
    //计算参数
    return await valApi.validate(valCon,calInvApi.calcInvoice,calCon);
  } catch (error) {
    console.log(error);
    return system.getResult(-1,`参数错误 销售方类型不存在`);
  }
}

