const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
const moment = require('moment')
//发票表  交付商提交的所有字段都保存到这个表中
module.exports = (db, DataTypes) => {

  return db.define("invoice", { 
    applyNo:{type: DataTypes.STRING,field: 'apply_no', allowNull: false, comment:'发票申请号' },    
    merchantId: {type: DataTypes.STRING,field: 'merchant_id', allowNull: true, comment:'个体工商户id（购买方id）' },
    
    businessmenType:{type: DataTypes.STRING,field: 'businessmen_type', allowNull: false, comment:'销售方类型 10 个体工商户 20 自然人' },
    businessmenId:{type: DataTypes.STRING,field: 'businessmen_id', allowNull: false, comment:'销售方id' },
    ruleCode:{type: DataTypes.STRING,field: 'rule_code', allowNull: false, comment:'算法编码 10 个体工商户算法  20 自然人算法 ...'},
    ruleParams:{type: DataTypes.STRING,field: 'rule_params', allowNull: false, comment:'算法参数编码 10 个体工商户算法参数  20 自然人算法参数 ...'},

    status:{ type: DataTypes.INTEGER, field: 'status', allowNull: true, comment:'审核状态  1030 待处理 1040 交付商关闭 1050 已开具 1060 代审核 1070 审核通过 1080 已邮寄'},
    //已开具
    invoiceNo:{type: DataTypes.STRING,field: 'invoice_no', allowNull: true, comment:'发票编号' },
    invoiceTime: { type: DataTypes.DATE, field: 'invoice_time', allowNull: true, defaultValue: DataTypes.NOW,comment:'开票时间'},
    invoiceImg:{type: DataTypes.STRING,field: 'invoice_img', allowNull: true, comment:'发票照片' }, 
    //拒绝原因
    //reason:{type: DataTypes.STRING,field: 'reason', allowNull: true, comment:'拒绝原因' }, 
    
    //完税
    taxNo:{type: DataTypes.STRING,field: 'tax_no', allowNull: true, comment:'完税批号'},
    complateTax: {type:DataTypes.INTEGER,field: 'complate_tax', allowNull: true, defaultValue:0,comment:'是否完税 0 未完成 1 已完成',
    get:function()  {
      var isInvalid = this.getDataValue('complateTax');
      var v = isInvalid=='1'?"已完成":"未完成";
      return v;
    },},
    taxTime: { type: DataTypes.DATE, field: 'tax_time', allowNull: true, defaultValue: DataTypes.NOW,comment:'完税时间'},
    taxVoucher:{type: DataTypes.STRING,field: 'tax_voucher', allowNull: true, comment:'完税照片' }, 
    
    //邮寄相关
    mailNo:{type: DataTypes.STRING,field: 'mail_no', allowNull: true, comment:'快递单号' },
    redStatus:{ type: DataTypes.STRING, field: 'red_status', allowNull: false, defaultValue: '1',comment:'红冲状态 1：未红冲 2：红冲中 3 红冲失败 4 红冲成功' },
    createdAt: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW,comment:'发票创建时间'},
    updatedAt: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW ,comment:'更新时间'},
    deletedAt: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true, comment:'删除时间'},
  },{   
    timestamps: true,
    underscore: false,
    freezeTableName: true,
    paranoid: true,
    // schema: '',
    tableName: 'invoice',
    comment: '发票表',
    charset: 'utf8',
    collate: 'utf8_general_ci',
    version: true
  });
}