const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
//平台审批表   所有平台审批信息都添加到此表中  此表的状态应该和申请表的状态保持一致
module.exports = (db, DataTypes) => {

  return db.define("deliverer", { 
    //发票id
    invoiceId: {type: DataTypes.STRING,field: 'invoice_id', allowNull: true, comment:'发票id' },
    applyNo:{type: DataTypes.STRING,field: 'apply_no', allowNull: false, comment:'发票编号' },
    merchantId: {type: DataTypes.STRING,field: 'merchant_id', allowNull: true, comment:'个体工商户id（购买方id）' },
    

    //平台选取交付商提交信息
    delivererId:{type: DataTypes.STRING,field: 'deliverer_id', allowNull: true, comment:'交付商id' },
    delivererName:{type: DataTypes.STRING,field: 'deliverer_name', allowNull: true, comment:'交付商名称' },
    delivererAmount:{type: DataTypes.BIGINT,field: 'deliverer_amount', allowNull: true, comment:'交付商分成' },
    breakReason:{type: DataTypes.STRING,field: 'break_reason', allowNull: true, comment:'拒绝原因' },

    //平台第二次审核提交信息
    auditContent:{type: DataTypes.STRING,field: 'audit_content', allowNull: true, comment:'审核备注' },
    delivererContent:{type: DataTypes.STRING,field: 'deliverer_content', allowNull: true, comment:'交付内容' },
    mailAddr:{type: DataTypes.STRING,field: 'mail_addr', allowNull: true, comment:'邮寄地址' },
    mailMobile:{type: DataTypes.STRING,field: 'mail_mobile', allowNull: true, comment:'邮寄电话' },
    mailTo:{type: DataTypes.STRING,field: 'mail_to', allowNull: true, comment:'邮寄人' },
    mailEmail:{type: DataTypes.STRING,field: 'mail_email', allowNull: true, comment:'邮寄邮箱' },
    //交付商交付信息（如果交付商邮寄那么则这个字段本应该在invoice表中，但是为了方便查询放在此表中）
    delivererMailNo:{type: DataTypes.STRING,field: 'deliverer_mail_no', allowNull: true, comment:'交付商邮寄单号' },
    platformMailNo:{type: DataTypes.STRING,field: 'platform_mail_no', allowNull: true, comment:'平台邮寄单号' },
    
    createdAt: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW,comment:'发票创建时间'},
    updatedAt: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW ,comment:'更新时间'},
    deletedAt: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true, comment:'删除时间'}
  },{   
    timestamps: true,
    underscore: false,
    freezeTableName: true,
    paranoid: true,
    // schema: '',
    tableName: 'invoice_deliverer',
    comment: '交付商分配表',
    charset: 'utf8',
    collate: 'utf8_general_ci',
    version: true
  });
}