const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
const moment = require('moment')
/**
 * 发表申请表
 */
module.exports = (db, DataTypes) => {

  return db.define("apply", { 

    //抬头信息  购买方
    merchantId: {type: DataTypes.STRING,field: 'merchant_id', allowNull: true, comment:'个体工商户id（购买方id）' },
    merchantName: {type: DataTypes.STRING,field: 'merchant_name', allowNull: false, comment:'抬头名称' },
    merchantCreditCode: {type: DataTypes.STRING,field: 'merchant_credit_code', allowNull: false, comment:'纳税人识别号' },  
    merchantAddr: {type: DataTypes.STRING,field: 'merchant_addr', allowNull: false, comment:'地址' },
    merchantMobile: {type: DataTypes.STRING,field: 'merchant_mobile', allowNull: false, comment:'电话' },  
    merchantBank: {type: DataTypes.STRING,field: 'merchant_bank', allowNull: false, comment:'开户行' },     
    merchantAccount: {type: DataTypes.STRING,field: 'merchant_account', allowNull: false, comment:'账号' }, 
    
    //销售方信息
    businessmenType:{type: DataTypes.STRING,field: 'businessmen_type', allowNull: false, comment:'销售方类型 10 个体工商户 20 自然人' },
    businessmenId:{type: DataTypes.STRING,field: 'businessmen_id', allowNull: false, comment:'销售方id' },
    businessmenCreditCode:{type: DataTypes.STRING,field: 'businessmen_credit_code', allowNull: false, comment:'个体户社会统一信息用代码' },
    businessmenName:{type: DataTypes.STRING,field: 'businessmen_name', allowNull: false, comment:'销售方名称' },
    businessmenAddr:{type: DataTypes.STRING,field: 'businessmen_addr', allowNull: false, comment:'销售方地址' },
    businessmenMobile:{type: DataTypes.STRING,field: 'businessmen_mobile', allowNull: false, comment:'销售方电话' },
    businessmenBank:{type: DataTypes.STRING,field: 'businessmen_bank', allowNull: false, comment:'销售方开户行' },
    businessmenAccount:{type: DataTypes.STRING,field: 'businessmen_account', allowNull: false, comment:'销售方账户' },
    isBank:{type: DataTypes.INTEGER, field: 'is_bank', allowNull: false, defaultValue: 0, comment:'开户状态：1.已开户 0.未开户'},
    taxAuthorities:{type: DataTypes.STRING,field: 'tax_authoritioes', allowNull: true, comment:'税务报道机构' },
    
    //发票信息
    // invoiceNo:{type: DataTypes.STRING,field: 'invoice_no', allowNull: true, comment:'发票编号' },
    type:{type: DataTypes.INTEGER,field: 'type', allowNull: false, defaultValue:10, comment:'发票类型：10 普通发票 20 增值税专用发票 30 电子发票' },
    ruleCode:{type: DataTypes.STRING,field: 'rule_code', allowNull: false, comment:'算法编码 10 个体工商户算法  20 自然人算法 ...'},
    ruleParams:{type: DataTypes.STRING,field: 'rule_params', allowNull: false, comment:'算法参数编码 10 个体工商户算法参数  20 自然人算法参数 ...'},
    invoiceAmount:{type: DataTypes.BIGINT,field: 'invoice_amount', allowNull: false, comment:'发票总额' },
    statements:{type: DataTypes.STRING,field: 'statements', allowNull: false, comment:'结算单' },
    contract:{type: DataTypes.STRING,field: 'contract', allowNull: false, comment:'合同' },
    invoiceTime:{type: DataTypes.DATE,field: 'invoice_time', allowNull: true, comment:'开票时间' },
    settleImg:{type: DataTypes.STRING,field: 'settle_img', allowNull: true, comment:'开票凭证' },
    applyNo:{type: DataTypes.STRING,field: 'apply_no', allowNull: true, comment:'开票申请记录' },
    invoiceContent:{type: DataTypes.STRING,field: 'invoice_content', allowNull: true, comment:'开票内容' },
    personalIncomeTax:{type: DataTypes.BIGINT,field: 'personal_invoice_tax', allowNull: true, comment:'个税',
    set:function(val, key) {
      if(val=="0.00"){val=0;}
      if(String(val).indexOf(".")!=-1){
        val=val*100;
      }
      let v = val?val:0;
      this.setDataValue(key, v);} },
    additionalTax:{type: DataTypes.BIGINT,field: 'additional_tax', allowNull: true, comment:'附加税',
    set:function(val, key) {
      if(val=="0.00"){val=0;}
      if(String(val).indexOf(".")!=-1){
        val=val*100;
      }
      let v = val?val:0;
      this.setDataValue(key, v);} },
    valueAddedTax:{type: DataTypes.BIGINT,field: 'value_added_tax', allowNull: true, comment:'增值税',
    set:function(val, key) {
      if(val=="0.00"){val=0;}
      if(String(val).indexOf(".")!=-1){
        val=val*100;
      }
      let v = val?val:0;
      this.setDataValue(key, v);} },
    serviceCharge:{type: DataTypes.BIGINT,field: 'service_change', allowNull: true, comment:'服务费',
    set:function(val, key) {
      if(val=="0.00"){val=0;}
      if(String(val).indexOf(".")!=-1){
        val=val*100;
      }
      let v = val?val:0;
      this.setDataValue(key, v);}  },
    applyMobile:{type: DataTypes.STRING,field: 'apply_mobile', allowNull: true, comment:'申请方电话' },

    isInvalid:{ type: DataTypes.STRING, field: 'is_invalid', allowNull: false, 
      get:function()  {
        var isInvalid = this.getDataValue('isInvalid');
        let v;
        if(isInvalid==1){
          v="未红冲";
        }else if(isInvalid==2){
          v="红冲中";
        }else if(isInvalid==3){
          v="红冲失败";
        }else if(isInvalid==4){
          v="红冲成功"
        }
        return v;
      },
      defaultValue: 1, 
      comment:'红冲状态 1：未红冲 2：红冲中 3 红冲失败 4 红冲成功'
    },
    parentId:{type: DataTypes.STRING,field: 'parent_id', allowNull: true, comment:'父id 红冲的关系id' },
    //发票状态
    status:{ type: DataTypes.STRING, field: 'status', allowNull: false, defaultValue:'1000', comment:'订单状态 1000 未付款 1010 审核不通过 1020 代分配 1030 待处理 1040 交付商关闭 1050 已开具 1060 代审核 1070 审核通过 1080 已邮寄 1090 完成 1100 发票撤回'},
    customerStatus:{ type: DataTypes.STRING, field: 'customer_status', allowNull: false, defaultValue:'1000', comment:'客户端状态 1000 未付款 1030 待处理 1050 已开具 1090 完成 1100 发票撤回'},
    //付款信息
    payWay:{ type: DataTypes.STRING, field: 'pay_way', allowNull: true, comment:'付款方式 10 系统账户扣款 20 线上支付'},
    payAccount:{ type: DataTypes.STRING, field: 'pay_account', allowNull: true, comment:'付款账户'},
    isPay:{type: DataTypes.INTEGER, field: 'is_pay', allowNull: false, defaultValue:0, comment:'支付状态：1.已支付 0.未支付'},

    //邮寄地址
    mailAddr:{type: DataTypes.STRING,field: 'mail_addr', allowNull: true, comment:'邮寄地址' },
    mailMobile:{type: DataTypes.STRING,field: 'mail_mobile', allowNull: true, comment:'邮寄电话' },
    mailTo:{type: DataTypes.STRING,field: 'mail_to', allowNull: true, comment:'邮寄人' },
    
    //平台第一次审核信息
    remark:{type: DataTypes.STRING,field: 'remark', allowNull: true, comment:'平台审核备注' },
    delivererId:{type: DataTypes.STRING,field: 'deliverer_id', allowNull: true, comment:'正在办理的交付商id' },
    createdAt: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW,comment:'发票创建时间',
      get() {
        let res = moment(this.getDataValue('createdAt')).add(8).format('YYYY-MM-DD HH:mm:ss');
        return res;
      }
    },
    updatedAt: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW ,comment:'更新时间',
      get(key) {
        let res = moment(this.getDataValue(key)).add(8).format('YYYY-MM-DD HH:mm:ss');
        return res;
      }
    },
    deletedAt: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true, comment:'删除时间'}
  },{
    timestamps: true,
    underscore: false,
    freezeTableName: true,
    paranoid: true,
    // schema: '',
    tableName: 'invoice_apply',
    comment: '发票申请表',
    charset: 'utf8',
    collate: 'utf8_general_ci',
    version: true
  });
}