const Dao = require("../../dao.base");
const system = require("../../../system");
class DelivererDao extends Dao {
  constructor() {
    super(Dao.getModelName(DelivererDao));
    this.statusMap = {
      "0090":"未付款",
      "1000":"待审核",
      "1010":"审核不通过",
      "1020":"待分配",
      "1030":"待处理",
      "1040":"交付商关闭",
      "1050":"已开具",
      "1060":"待审核",
      "1070":"审核通过",
      "1080":"已邮寄",
      "1090":"完成",
      "1100":"发票撤回",
      "1200":"红冲",
      "1300":"审核失败(平台第二次审核)"
    };

    this.customerMap = {
      "0090":"未付款",
      "1000":"待审核",
      "1030":"待处理",
      "1050":"已开具",
      "1090":"完成"
    };

    this.deliverMap = {
      "1030":"待处理",
      "1040":"交付商关闭",
      "1050":"已开具",
      "1060":"待审核",
      "1080":"已邮寄",
      "1300":"审核失败(平台第二次审核)"
    }
  }

  //交付商业务概览
  async countStat(params) {
    var sql = [];
    sql.push("select distinct deliverer_id from `xgg-invoice`.invoice_deliverer where 1=1");
    this.setCondition(params, sql);

    var list = await this.customQuery(sql.join(" "), params);
    return {
      total:list.length || 0,
      list:list
    };
  }

  setCondition(params, sql) {
    if (params.begin) {
      sql.push("AND created_at >= :begin");
    }
    if (params.end) {
      sql.push("AND created_at <= :end");
    }
  }
  //获取名字 id等信息
  async queryStat(params, startRow, pageSize) {
    var sql = [];
    sql.push("SELECT");
    sql.push("b.id, b.deliverer_id, b.deliverer_name,sum(b.deliverer_amount) as totalAmount");
    sql.push("FROM invoice_deliverer b inner join invoice_apply a on a.deliverer_id=b.id ");
    sql.push("WHERE 1 = 1 and b.deliverer_id in ("+params.list+")");

    if (params.begin) {
      sql.push("AND b.created_at >= :begin");
    }
    if (params.end) {
      sql.push("AND b.created_at <= :end");
    }
    sql.push("GROUP BY b.deliverer_id");
    sql.push("LIMIT :startRow, :pageSize");

    params.startRow = startRow;
    params.pageSize = pageSize;
    var list = await this.customQuery(sql.join(" "), params);
    return list;
  }

  async statDeliverByStatus(params) {
    var sql = [];
    sql.push("SELECT");
    sql.push("a.deliverer_id,a.status,COUNT(1) AS invoiceCount");
    sql.push("FROM `invoice_apply` a inner join `invoice_deliverer` b  on a.deliverer_id=b.id");
    sql.push("WHERE 1 = 1");

    if(params.delivererIds) {
      sql.push("AND a.deliverer_id IN (:delivererIds)")
    }
    if (params.begin) {
      sql.push("AND b.created_at >= :begin");
    }
    if (params.end) {
      sql.push("AND b.created_at <= :end");
    }
    sql.push("GROUP BY a.`status`");

    var result = {};
    var list = await this.customQuery(sql.join(" "), params);
    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.deliverer_id + "_" + item.status] = item.invoiceCount || 0;
    }
    return result;
  }

  //按天来计算（交付商）
  async delStatDayByTime(begin, end,delivererId) {
    var result = {};
    var sql = [];
    sql.push("SELECT");
    sql.push("DATE_FORMAT(created_at, '%Y-%m-%d') AS `day`, SUM(deliverer_amount) AS delivererAmount, COUNT(1) AS invoiceCount");
    sql.push("FROM `invoice_deliverer`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end,
      delivererId:delivererId
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }
    if (delivererId) {
      sql.push("AND deliverer_id = :delivererId");
    }
    sql.push("GROUP BY `day` ORDER BY `day` ASC");
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      result[item.day] = item;
    }
    return result;
  }

  //安月来计算（交付商）
  async delStatMonthByTime(begin, end,delivererId) {
    var result = {};
    var sql = [];
    sql.push("SELECT");
    sql.push("DATE_FORMAT(created_at, '%Y-%m') AS `month`, SUM(deliverer_amount) AS delivererAmount, COUNT(1) AS invoiceCount");
    sql.push("FROM `invoice_deliverer`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }
    if (delivererId) {
      sql.push("AND deliverer_id = :delivererId");
    }
    sql.push("GROUP BY `month` ORDER BY `month` ASC");
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return result;
    }

    for (var idx = 0; idx < list.length; idx++) {
      var item = list[idx];
      result[item.month] = item;

      if (idx == 0) {
        result.begin = item.month;
      }

      if (idx == list.length - 1) {
        result.end = item.month;
      }
    }
    return result;
  }


  async delStatInvoiceByTime(begin, end,delivererId) {
    var sql = [];
    sql.push("SELECT");
    sql.push("COUNT(1) AS invoiceCount, SUM(deliverer_amount) AS delivererAmount");
    sql.push("FROM `invoice_deliverer`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end,
      delivererId:delivererId
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }
    if (delivererId) {
      sql.push("AND deliverer_id = :delivererId");
    }
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return {
        invoiceCount: 0,
        delivererAmount: 0,
      }
    }
    var item = list[0];
    return {
      invoiceCount: item.invoiceCount || 0,
      delivererAmount: item.delivererAmount || 0,
    }
  }

  /**
   * 发票办理
   * @param {*} begin 
   * @param {*} end 
   */
  async delStatByStatus(begin, end) {
    var sql = [];
    sql.push("SELECT");
    sql.push("`status`, COUNT(1) AS invoiceCount ");
    sql.push("FROM `invoice_deliverer`");
    sql.push("WHERE 1 = 1");
    var params = {
      begin: begin,
      end: end
    };

    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }

    sql.push("GROUP BY `status`");

    var result = {};
    var list = await this.customQuery(sql.join(" "), params);
    if(!list || list.length == 0) {
      return result;
    }

    for(var item of list) {
      result[item.status] = item.invoiceCount || 0;
    }
    return result;
  }
}
module.exports = DelivererDao;
