const Dao = require("../../dao.base");
const system = require("../../../system");
class ApplyDao extends Dao {
  constructor() {
    super(Dao.getModelName(ApplyDao));
    this.statusMap = {
      "0090": "未付款",
      "1000": "待审核",
      "1010": "审核不通过",
      "1020": "待分配",
      "1030": "待处理",
      "1040": "交付商关闭",
      "1050": "已开具",
      "1060": "待审核",
      "1070": "审核通过",
      "1080": "已邮寄",
      "1090": "完成",
      "1100": "发票撤回",
      "1200": "红冲",
      "1300": "审核失败(平台第二次审核)"
    };

    this.customerMap = {
      "0090": "未付款",
      "1000": "待审核",
      "1030": "待处理",
      "1050": "已开具",
      "1090": "完成"
    };

    this.deliverMap = {
      "1030": "待处理",
      "1040": "交付商关闭",
      "1050": "已开具",
      "1060": "待审核",
      "1080": "已邮寄",
      "1300": "审核失败(平台第二次审核)"
    }
  }


  async findMapByIds(ids, attrs) {
    var result = {};
    if (!ids || ids.length == 0) {
      return result;
    }

    attrs = attrs || "*";
    var sql = "SELECT " + attrs + " FROM invoice_apply where id IN (:ids) ";
    var list = await this.customQuery(sql, { ids: ids });
    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.id] = item;
    }

    return result;
  }

  //按天来计算(平台)
  async statDayByTime(begin, end) {
    var result = {};
    var sql = [];
    sql.push("SELECT");
    sql.push("DATE_FORMAT(created_at, '%Y-%m-%d') AS `day`, SUM(service_change) AS serviceChange, COUNT(1) AS invoiceCount");
    sql.push("FROM `invoice_apply`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }
    sql.push("GROUP BY `day` ORDER BY `day` ASC");
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      result[item.day] = item;
    }
    return result;
  }

  //安月来计算（平台）
  async statMonthByTime(begin, end) {
    var result = {};
    var sql = [];
    sql.push("SELECT");
    sql.push("DATE_FORMAT(created_at, '%Y-%m') AS `month`, SUM(service_change) AS serviceChange, COUNT(1) AS invoiceCount");
    sql.push("FROM `invoice_apply`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }

    sql.push("GROUP BY `month` ORDER BY `month` ASC");
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return result;
    }

    for (var idx = 0; idx < list.length; idx++) {
      var item = list[idx];
      result[item.month] = item;

      if (idx == 0) {
        result.begin = item.month;
      }

      if (idx == list.length - 1) {
        result.end = item.month;
      }
    }
    return result;
  }

  async statInvoiceByTime(begin, end) {
    var sql = [];
    sql.push("SELECT");
    sql.push("COUNT(1) AS invoiceCount, SUM(service_change) AS serviceChange");
    sql.push("FROM `invoice_apply`");
    sql.push("WHERE 1 = 1");

    var params = {
      begin: begin,
      end: end
    };
    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }
    var list = await this.customQuery(sql.join(" "), params);

    if (!list || list.length == 0) {
      return {
        invoiceCount: 0,
        serviceChange: 0,
      }
    }
    var item = list[0];
    return {
      invoiceCount: item.invoiceCount || 0,
      serviceChange: item.serviceChange || 0,
    }
  }


  async statByStatus(begin, end) {
    var sql = [];
    sql.push("SELECT");
    sql.push("`status`, COUNT(1) AS invoiceCount ");
    sql.push("FROM `invoice_apply`");
    sql.push("WHERE 1 = 1");
    var params = {
      begin: begin,
      end: end
    };

    if (begin) {
      sql.push("AND created_at >= :begin");
    }
    if (end) {
      sql.push("AND created_at <= :end");
    }

    sql.push("GROUP BY `status`");

    var result = {};
    var list = await this.customQuery(sql.join(" "), params);
    if(!list || list.length == 0) {
      return result;
    }

    for(var item of list) {
      result[item.status] = item.invoiceCount || 0;
    }
    return result;
  }

}
module.exports = ApplyDao;
