var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
var rule =require("../../../utils/invoiceRule/rule");
class ActionAPI extends APIBase {
    constructor() {
        super();
        this.invoiceSve = system.getObject("service.invoice.invoiceSve");
        this.applySve = system.getObject("service.invoice.applySve");
        this.delivererSve = system.getObject("service.invoice.delivererSve");
    }
    /**
     * 接口跳转
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springboard(pobj, qobj, req) {
        if (!pobj.action_process) {
            return system.getResult(null, "action_process参数不能为空");
        }
        if (!pobj.action_type) {
            return system.getResult(null, "action_type参数不能为空");
        }
        return await this.sjbOpActionProcess(pobj.action_process, pobj.action_type, pobj.action_body);
    }

    async sjbOpActionProcess(action_process, action_type, action_body) {
        var opResult = null;
        switch (action_type) {
            
            case "verificationAndCalculation":          // 发票试算接口
                opResult = await rule.dispatcher(action_body);
                break;
            case "saveInvoice":                         // 发票保存
                opResult = await this.applySve.apiSaveInvoice(action_body);
                break;
            case "queryTxPayment":                     //查看完税证明
                opResult = await this.invoiceSve.apiQueryTxPayment(action_body);
                break;
            case "apiCancelInvoice":                   // 发票申请单撤回
                opResult = await this.applySve.apiCancelInvoice(action_body);
                break;
            
            case "queryApplyInvoices":                 // 发票申请列表(平台)
                opResult = await this.applySve.apiQueryApplyInvoices(action_body);
                break;
            case "queryInvoices":                    // 发票列表(平台)
                opResult = await this.invoiceSve.apiQueryInvoices(action_body);
                break;
            case "queryInvoice":                     // 发票明细（平台）
                opResult = await this.applySve.apiQueryInvoice(action_body);
                break;
            case "platformAssignment":               // 平台审批
                opResult = await this.applySve.apiAssignment(action_body);
                break;
            case "updateEmail":                      //平台更新邮寄地址
                opResult = await this.delivererSve.apiUpEmNo(action_body);
                break;
            case "queryProcess":                     // 查看业务办理(平台)
                opResult = await this.delivererSve.apiQueryProcess(action_body);
                break;
            case "redRushInvoice":                   //红冲
                opResult = await this.applySve.apiRedRushInvoice(action_body);
                break;
            case "statTransData":                    //交易数据
                opResult = await this.applySve.apiStatTransData(action_body);
                break;
            case "statBusinessData":                 //发票办理
                opResult = await this.applySve.apiStatBusinessData(action_body);
                break;
            case "statDeliverData":                  //交付商业务概览
                opResult = await this.delivererSve.apiStatDeliverData(action_body);
                break;
            
            case "delivererApplyInvoices":          //发票申请列表（交付商）
                opResult = await this.delivererSve.apiDelivererApplyInvoices(action_body);
                break;
            case "delivererInvoices":               //发票列表（交付商）
                opResult = await this.delivererSve.apiDelInvs(action_body);
                break;   
            case "queryInvoiceDeliverer":           // 发票明细（交付商）
                opResult = await this.delivererSve.apiQueryInvoiceDeliverer(action_body);
                break;
            case "delivererAssignment":             //交付商审批
                opResult = await this.delivererSve.apiAssignment(action_body);
                break;
            case "txPayment":                       //完税证明更新
                opResult = await this.invoiceSve.apiTxPayment(action_body);
                break;
            case "delStatTransData":                 //交易数据（交付商）
                opResult = await this.delivererSve.apiDelStatTransData(action_body);
                break;
            case "delStatBusinessData":              //发票办理（交付商）
                opResult = await this.delivererSve.apiDelStatBusinessData(action_body);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    exam() {
        return `<pre>

9.calcInvoice：发票试算接口
    功能描述：
        商户使用试算接口，计算出当前开票所需要缴纳的个税、增值税、附加税、服务费等信息，用于开票前的展示，如果商户业务不需要展示，忽略此接口
    请求参数：
        {
            "action_process": "sjb",
            "action_type": "calcInvoice",
            "action_body": {
                "invoiceList": [
                    {
                        "businessmenCreditCode":"1111",
                        "invoiceTime": "2019-09-19",
                        "invoiceAmt":440000000,
                        "type": 1
                    }
                ],
                "times_tamp": 1568713248,
                "sign": "D4393F17C96CDA582C1EE5FF0053671E"
            }
        }
    请求参数说明：
        sign                    ：  String   ：  必填     ：签名
        times_tamp              ：  long     ：  必填     ：时间戳
        invoiceList             ：  Array    ：  必填     ：发票试算列表，最多不超过10个，不参与签名
        businessmenCreditCode   ：  String   ：  必填     ：个体工商户统一社会信用代码
        invoiceTime             ：  String   ：  必填     ：开票时间（YYYY-MM-DD）
        invoiceAmt              ：  bigint   ：  必填     ：开票金额（分）
        type                    ：  int      ：  必填     ：开票类型 0普票 1专票
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": {
                "1": {
                    "code": 1,
                    "msg": "success",
                    "incomeTax": "20042494",
                    "addedValueTax": "28042996",
                    "specialTax": "2720171",
                    "serviceTax": "9372000",
                    "warning": "年度总开票金额已达到4400000",
                    "monthAmt": 440000
                }
            },
            "requestid": "363e0391a43c4dedb5656623d1bcd540"
        }
    返回值说明：
        data                        ：  Object   : 发票处理结果，Map格式，key为个体工商户统一社会信用代码
            "1"                     ：  Object   : 统一社会信用代码
                "code"              ：  int      : 该个体工商户试算状态 1成功 -1失败
                "msg"               ：  String   : 试算结果提示，错误时返回错误信息    
                "incomeTax"         ：  bigint   : 试算个税结果（分）
                "addedValueTax"     ：  bigint   : 试算增值税结果（分）
                "specialTax"        ：  bigint   : 试算附加费结果（分）
                "serviceTax"        ：  bigint   : 试算服务费结果（分）
                "warning"           ：  String   : 警告信息，该字段不为空时，在前端显示,
                "monthAmt"          ：  bigint   : 该个体工商户在开票时间的月分中，已经申请开票的总金额

10.saveInvoice：申请开票接口
    功能描述：
        商户为个体工商户申请开发票，批量开，一次不超过10条发票记录
    请求参数：
    {
        "action_process": "sjb",
        "action_type": "saveInvoice",
        "action_body": {
            "invoiceList": [
                {
                    "businessmenCreditCode":"1111",
                    "invoiceTime": "2019-09-19",
                    "applyNo": "100001",
                    "invoiceAmt":330000,
                    "settleImg": "https://bpohhr.gongsibao.com",
                    "type": 1
                },
                {
                    "businessmenCreditCode":"2222",
                    "applyNo": "100002",
                    "invoiceTime": "2019-09-19",
                    "invoiceAmt":200000,
                    "settleImg": "https://bpohhr.gongsibao.com",
                    "type": 1
                }
                
            ],
            "times_tamp": 1568713248,
            "sign": "D4393F17C96CDA582C1EE5FF0053671E"
        }
    }
    请求参数说明：
        sign                      ：  String   ：  必填     ：签名
        times_tamp                ：  long     ：  必填     ：时间戳
        invoiceList               ：  Array    ：  必填     ：开票申请列表，最多不超过10个，不参与签名
        businessmenCreditCode     ：  String   ：  必填     ：个体工商户统一社会信用代码
        applyNo                   ：  String   ：  必填     ：开票申请编码（商户内唯一）
        invoiceTime               ：  String   ：  必填     ：开票时间（YYYY-MM-DD）
        invoiceAmt                ：  bigint   ：  必填     ：开票金额（分）
        settleImg                 ：  String   ：  必填     ：结算单图片地址
        type                      ：  int      ：  必填     ：开票类型 0普票 1专票
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": {
                "1111": {
                    "code": 1,
                    "msg": "success"
                },
                "2222": {
                    "code": 1,
                    "msg": "success"
                }
            },
            "requestid": "a39a364d83c14664b8e3399387fa847d"
        }
    返回值说明：
        data                        ：  Object   : 发票处理结果，Map格式，key为个体工商户统一社会信用代码
            "1"                     ：  Object   : 个体工商户统一社会信用代码为key的对象
                "code"              ：  int      : 该个体工商户试算状态 1成功 -1失败
                "msg"               ：  String   : 试算结果提示，错误时返回错误信息    

11.cancelInvoice：发票申请撤回接口
    功能描述：
        商户可再开票申请之后，公司宝财务审核之前进行发票撤回，其他情况联系客户经理
    请求参数：
        {
            "action_process": "sjb",
            "action_type": "cancelInvoice",
            "action_body": {
                "applyNo": "100001"
            }
        }
    请求参数说明：
        sign                      ：  String   ：  必填     ：签名
        times_tamp                ：  long     ：  必填     ：时间戳
        applyNo                   ：  String   ：  必填     ：开票申请编号
    返回值：
        {
            "status": 0,
            "msg": "success",
            "data": "success",
            "requestid": "090bde8c5bb74b9d8c6b97beabf39161"
        }

12.queryInvoice：发票查询接口
    功能描述：
        查询某次开票申请的信息，包括发票状态、开票信息、邮寄信息、完税证明等信息
    请求参数：
        {
            "action_process": "sjb",
            "action_type": "queryInvoice",
            "action_body": {
                "applyNo": "100001"
            }
        }
    请求参数说明：
        sign                      ：  String   ：签名
        times_tamp                ：  long     ：时间戳
        applyNo                   ：  String   ：开票申请编号
    返回值：
        {
            merchant_id   // 商户id 
            applyNo       // 发票申请编号
            status        // 发票状态 00开票申请 10已撤回 20审核驳回 30审核通过 40已开票 50已邮寄

            auditRemark   // 审核备注

            invoiceNo     // 发票编号
            invoiceTime   // 开票时间
            invoiceImg    // 发票照片
            payVoucher    // 支付凭证

            courierNo   // 快递单号
            courierImg  //  快递交接单图片

            taxNo       // 完税批号
            taxTime     // 完税时间
            taxVoucher  // 完税证明（图片地址）
        }
    返回值说明：
        merchant_id   ：  bigint  ： 商户id 
        applyNo       ：  String  ： 发票申请编号
        status        ：  String  ： 发票状态 00开票申请 10已撤回 20审核驳回 30审核通过 40已开票 50已邮寄
        auditRemark   ：  String  ： 审核备注
        invoiceNo     ：  String  ： 发票编号
        invoiceTime   ：  String  ： 开票时间(YYYY-MM-DD)
        invoiceImg    ：  String  ： 发票照片
        payVoucher    ：  String  ： 支付凭证
        courierNo     ：  String  ： 快递单号
        courierImg    ：  String  ： 快递交接单图片
        complateTax   ：  int     ： 是否完税  0否 1是
        taxNo         ：  String  ： 完税批号
        taxTime       ：  String  ： 完税时间
        taxVoucher    ：  String  ： 完税证明（图片地址）


13.queryTaxInvoice：完税证明查询
    功能描述：
        查询发票完税证明信息
    请求参数：
        {
            "action_process": "sjb",
            "action_type": "queryTaxInvoice",
            "action_body": {
                "applyNo": "100001"
            }
        }
    请求参数说明：
        sign                      ：  String   ：签名
        times_tamp                ：  long     ：时间戳
        applyNo                   ：  String   ：开票申请编号

    返回值：
        {
            merchant_id   // 商户id 
            applyNo       // 发票申请编号
            complateTax   // 是否完税  0否 1是
            taxNo         // 完税批号
            taxTime       // 完税时间
            taxVoucher    // 完税证明（图片地址）
        }
    返回值说明：
        merchant_id   ：  bigint  ： 商户id 
        applyNo       ：  String  ： 发票申请编号
        complateTax   ：  int     ： 是否完税  0否 1是
        taxNo         ：  String  ： 完税批号
        taxTime       ：  String  ： 完税时间
        taxVoucher    ：  String  ： 完税证明（图片地址）


14: queryCourierTrace：查询邮寄进度
    功能描述：
        查询邮寄进度
    请求参数：
        {
            "action_process": "sjb",
            "action_type": "queryTaxInvoice",
            "action_body": {
                "applyNo": "100001"
            }
        }
    请求参数说明：
        sign                      ：  String   ：签名
        times_tamp                ：  long     ：时间戳
        applyNo                   ：  String   ：开票申请编号
    返回值：
        {
            merchant_id   // 商户id 
            courierNo     // 快递单号
            courierStatus // 邮寄状态
            courierTime   // 时间
            desc          // 当前状态描述信息
        }
    返回值说明：
        merchant_id   ：  bigint  ： 商户id 
        applyNo       ：  String  ： 发票申请编号
        courierNo     ：  String  ： 快递单号
        courierStatus ：  String  ： 邮寄状态
        courierTime   ：  String  ： 时间（YYYY-MM-DD HH:mm:ss）
        desc          ：  String  ： 当前状态描述信息


15：提交个体工商户合同信息
    功能描述：
        提交贵公司与个体工商户的合同信息给公司宝，公司宝审核通过后，个体工商户才可以做用户签约（设置个体工商户个税、增值税、附加税阶梯）
    请求参数：
        {
            "action_process": "sjb",
            "action_type": "queryTaxInvoice",
            "action_body": {
                "applyNo": "100001"
            }
        }
    请求参数说明：
        sign                      ：  String   ：签名
        times_tamp                ：  long     ：时间戳
        applyNo                   ：  String   ：开票申请编号
    返回值：
        {
            merchant_id   // 商户id 
            courierNo     // 快递单号
            courierStatus // 邮寄状态
            courierTime   // 时间
            desc          // 当前状态描述信息
        }
    返回值说明：
        merchant_id   ：  bigint  ： 商户id 
        applyNo       ：  String  ： 发票申请编号
        courierNo     ：  String  ： 快递单号
        courierStatus ：  String  ： 邮寄状态
        courierTime   ：  String  ： 时间（YYYY-MM-DD HH:mm:ss）
        desc          ：  String  ： 当前状态描述信息



------------------------------------------------------------------------------------------------------------------------------------------   
------------------------------------------------------------------------------------------------------------------------------------------
通知回调商户接口：需要商户提供以下接收的回调地址，回调方式：POST
    1. 充值审核  
    2. 商户修改接口  
    3. 订单修改接口  
    4. 订单状态变更推送
    5. 个体户合同审核结果推送
    6. 个体户签约结果推送
    7. 发票状态变更推送
    8. 发票完税证明推送
1.充值审核
    功能描述：商户提交发票申请后，公司宝财务在审核该申请之后，通知商户审核状态
    推送参数：
    {
        merchant_id  ：  bigint   ：商户id  
        outTradeNo   ：  String   ：充值流水号,
        status       ：  int      ：充值状态 1已认证 2审核失败
        remark       ：  String   ：审核备注
    }

4. 订单状态变更推送
    功能描述：订单状态发生变更后，公司宝将状态变更内容推送给商户
    推送参数：
    {
        merchant_id      ：   bigint     ： 商户id                                                                                          
        status           ：   String     ： 00待处理 05执照办理中 10已出执照 15刻章办理中 20已刻章 25银行开户中 30银行已开户 35税务报到中 40已税务报到 50已邮寄
        channelOrderNo   ：   String     ： 渠道订单号    

        // ----- 出执照推送数据 -----
        name             ：   String     ： 个体工商户名称                                                                             
        creditCode       ：   String     ： 统一社会信用代码                                                                          
        businessPlace    ：   String     ： 经营场所                                                                                      
        businessScope    ：   String     ： 经营范围                                                                                      
        regDate          ：   String     ： 注册日期 （YYYY-MM-DD）                                                                                     
        businessImg      ：   String     ： 执照照片                                                                                               
        orderNo          ：   String     ： 订单号                                                                                         
        legalName        ：   String     ： 法人姓名                                                                                      
        legalMobile      ：   String     ： 法人电话  
        
        // ----- 刻章推送数据 -----
        gongzhang        ：   String     ： 公章                                                                                            
        caiwuzhang       ：   String     ： 财务章                                                                                         
        businessImg      ：   String     ： 执照照片                                                                                      
        fapiaozhang      ：   String     ： 发票章                                                                                         
        hetongzhang      ：   String     ： 合同章                                                                                         
        farenzhang       ：   String     ： 法人章    

        // ----- 开户推送数据 -----
        isBank           ：   String     ： 是否开户                                                                                      
        bankName         ：   String     ： 账户名称                                                                                      
        bankNo           ：   String     ： 账户号                                                                                         
        bank             ：   String     ： 开户行                                                                                         
        bankImg          ：   String     ： 账户信息   


        // ----- 税务报到推送数据 -----
        caImg            ：   String     ： CA照片                                                                                      
        taxRegDay        ：   String     ： 税务登记日                                                                                      
        taxOrg           ：   String     ： 税务机构名称 

        // ----- 邮寄推送数据 -----
        courierNo        ：   String     ： 快递单号                                                                                       
        courierImg       ：   String     ： 快递交接单图片 
    }    
5. 订单状态变更推送
功能描述：订单状态发生变更后，公司宝将状态变更内容推送给商户
推送参数：
{
    merchant_id      ：   bigint     ： 商户id                                                                                          
    status           ：   String     ： 00待处理 05执照办理中 10已出执照 15刻章办理中 20已刻章 25银行开户中 30银行已开户 35税务报到中 40已税务报到 50已邮寄
    channelOrderNo   ：   String     ： 渠道订单号

    // ----- 出执照推送数据 -----
    name             ：   String     ： 个体工商户名称                                                                             
    creditCode       ：   String     ： 统一社会信用代码                                                                          
    businessPlace    ：   String     ： 经营场所                                                                                      
    businessScope    ：   String     ： 经营范围                                                                                      
    regDate          ：   String     ： 注册日期 （YYYY-MM-DD）                                                                                     
    businessImg      ：   String     ： 执照照片                                                                                               
    orderNo          ：   String     ： 订单号                                                                                         
    legalName        ：   String     ： 法人姓名                                                                                      
    legalMobile      ：   String     ： 法人电话  
    
    // ----- 刻章推送数据 -----
    gongzhang        ：   String     ： 公章                                                                                            
    caiwuzhang       ：   String     ： 财务章                                                                                         
    businessImg      ：   String     ： 执照照片                                                                                      
    fapiaozhang      ：   String     ： 发票章                                                                                         
    hetongzhang      ：   String     ： 合同章                                                                                         
    farenzhang       ：   String     ： 法人章    

    // ----- 开户推送数据 -----
    isBank           ：   String     ： 是否开户                                                                                      
    bankName         ：   String     ： 账户名称                                                                                      
    bankNo           ：   String     ： 账户号                                                                                         
    bank             ：   String     ： 开户行                                                                                         
    bankImg          ：   String     ： 账户信息   


    // ----- 税务报到推送数据 -----
    caImg            ：   String     ： CA照片                                                                                      
    taxRegDay        ：   String     ： 税务登记日                                                                                      
    taxOrg           ：   String     ： 税务机构名称 

    // ----- 邮寄推送数据 -----
    courierNo        ：   String     ： 快递单号                                                                                       
    courierImg       ：   String     ： 快递交接单图片 
}  
5. 个体户合同审核结果推送
6. 个体户签约结果推送

7.发票状态变更推送
    功能描述：发票状态变更后，公司宝将发票状态变更内容推送给商户
    推送参数：
    {
        merchant_id         ：   bigint     ：商户id 
        applyNo             ：   String     ：发票申请编号
        status              ：   String     ：发票状态 00开票申请 10已撤回 20审核驳回 30审核通过 40已开票 50已邮寄
        
        // ----- 发票审核数据字段 -----
        auditRemark         ：   String     ：审核备注

        // ----- 发票开具数据字段 -----
        invoiceNo           ：   String     ：发票编号
        invoiceTime         ：   String     ：开票时间
        invoiceImg          ：   String     ：发票照片
        payVoucher          ：   String     ：支付凭证
        
        // ----- 发票邮件数据字段 -----
        courierNo           ：   String     ：快递单号
        courierImg          ：   String     ：快递交接单图片
    }
8.发票完税证明推送
    功能描述：公司宝客户经理再处理完税证明后，公司宝将完税证明信息推送给商户
    推送参数：
    {
        merchant_id         ：   bigint     ：商户id 
        applyNo             ：   String     ：发票申请编号

        complateTax         ：   String     ：是否完税  0否 1是
        taxNo               ：   String     ：完税批号
        taxTime             ：   String     ：完税时间
        taxVoucher          ：   String     ：完税证明（图片地址）
    }
    <pre/>`;
    }
    classDesc() {
        return {
            groupName: "op",
            groupDesc: "元数据服务包",
            name: "ActionAPI",
            desc: "此类是对外提供接口服务",
            exam: "",
        };
    }
    methodDescs() {
        return [
            {
                methodDesc: `<pre>请求地址：http://sj.app.com:3002/api/op/action/springboard   
    请求时需要在请求头中增加app_id参数信息，app_id由平台提供给调用方
    方法中的签名只有action_body中的参数参与，按照参数的首字母进行ASCII码进行正序排列后进行签名，action_body中的参数为空或参数为list或为json的不参与签名
    签名字符串示例：times_tamp=1568713248&key=XXXX，key为平台提供的密钥，对字符串进行
    后进行大写转换
    方法中需要传递的action_type列表有： 
        queryMerchant：查询商户   
        addOrder/putOrder：添加订单/修改订单
        queryOrder：订单查询   
        putContract：个体工商户合同接收接口   
        queryMerchantAccount：商户账户查询
        queryMerchantTrade：商户交易流水查询
        queryBusinessmen：个体工商户信息查询接口   
        rechargeApplication：商户充值申请接口   
        calcInvoice：发票试算接口   
        saveInvoice：申请开票接口   
        cancelInvoice：发票申请撤回接口
        queryInvoice：发票查询接口
        queryTaxInvoice：完税证明查询
        queryCourierTrace：查询邮寄进度
    <pre/>`,
                methodName: "springboard",
                paramdescs: [
                    {
                        paramDesc: "请求的行为，传递如：sjb",
                        paramName: "action_process",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型，详情见方法中的描述",
                        paramName: "action_type",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型的参数，action_body必须传递的参数有，times_tamp（时间戳，类型int）、sign(签名,类型string)，其余的为业务需要的参数",
                        paramName: "action_body",
                        paramType: "json",
                        defaultValue: null,
                    }
                ],
                rtnTypeDesc: `<pre>
                status: 返回状态,
                msg: 返回信息描述，验证有误则为错误提示,
                data: 返回数据信息,
                requestid: 返回的处理此次请求的凭证               
                status状态码如下：
                0     业务请求处理成功
                -1    请求参数验证失败
                1200  访问appid失效
                1300  签名验证失败
            <pre/>`,
                rtnType: `<pre>
                {
                    "status": 0,
                    "msg": "success",
                    "data": {},
                    "requestid": "8cbd498f9d1441b1812ecaa2653933f4"
                }
            <pre/>`
            }
        ];
    }
}
module.exports = ActionAPI;