const system=require("../../../system");
const settings=require("../../../../config/settings");
const ServiceBase=require("../../sve.base")
var WXPay = require('wx-pay');
const uuidv4 = require('uuid/v4');
class ApiTradeService extends ServiceBase{
  constructor(){
     super("common",ServiceBase.getDaoName(ApiTradeService));
     this.appS=system.getObject("service.common.appSve");
  }
  async create(tradeObj){
    var self=this;
    return this.db.transaction(async function (t){
      //获取缓存二个值，一个是赠送次数,一个是调用价格,取目标应用的appkey
      var pconfig=await self.cacheManager["PConfigCache"].cache(tradeObj.destappkey,null,null);
      var apiInitGift = pconfig.find(item => {
          return item.configType === "apiInitGift";
      });
      var apiCallPrice = pconfig.find(item => {
          return item.configType === "apiCallPrice";
      });
      var callCache=await self.cacheManager["ApiCallCountCache"].getApiCallCount(tradeObj.srcappkey,tradeObj.op);
      var callAccuCache=await self.cacheManager["ApiAccuCache"].getApiCallAccu(tradeObj.srcappkey+"_"+tradeObj.destappkey);
      //需要每次增加计数之前，通知目标app,目前的计数值,由目标APP来决定是否准许访问
     
      var appdest=await self.cacheManager["AppCache"].cache(tradeObj.destappkey);

      if(appdest.id!=settings.platformid){
        var recvCountNotityUrl=appdest.notifyCacheCountUrl;
        self.apiCallWithAk(recvCountNotityUrl,callAccuCache);
      }else{
        self.appS.recvNotificationForCacheCount(callAccuCache);
      }
      var calledCount=Number(callCache.callcount);
      var balance=Number(callCache.amount);
      if(calledCount>Number(apiInitGift?apiInitGift.configValue:0)){//调用次数大于免费次数
         tradeObj.amount=Number(apiCallPrice?apiCallPrice.configValue:0);
      }else{
         tradeObj.amount=0;
      }
      //解决日志大于4000写入的问题
      if(tradeObj.params.length>3980){
        tradeObj.params=tradeObj.params.substring(0,3980);
      }
      var apitrade=await self.dao.model.create(tradeObj,{transaction:t});
      //按照调用方法缓存
      await self.cacheManager["ApiCallCountCache"].addCallCount(tradeObj.srcappkey,tradeObj.op,1);
      await self.cacheManager["ApiCallCountCache"].addCallBalance(tradeObj.srcappkey,tradeObj.op,tradeObj.amount);
      //累计缓存调用次数和金额
      await self.cacheManager["ApiAccuCache"].addCallCount(tradeObj.srcappkey+"_"+tradeObj.destappkey,1);
      await self.cacheManager["ApiAccuCache"].addCallBalance(tradeObj.srcappkey+"_"+tradeObj.destappkey,tradeObj.amount);
  //    await self.cacheManager["ApiCircuitBreakers"].addCallCount(-1);
      return apitrade;
    });
  }

  async beforesel(tradeObj){
    var self=this;
    var callCaches=await self.cacheManager["ApiCircuitBreakers"].getApiCall();
    var calledCounts=Number(callCaches.callcount);
    if( calledCounts>100 ){
//      return {status:-1,msg:"服务器繁忙，请稍候再试",data:null};
    }
    else {
//      await self.cacheManager["ApiCircuitBreakers"].addCallCount(1);
    }
    var callCache=await self.cacheManager["ApiCircuitBreakerCache"].getApiCall(tradeObj.appkey);
    var calledCount=Number(callCache.callcount);
    if( calledCount>1000 ){
      return {status:-1,msg:"调用次数太多，请稍候再试",data:null};
    }
    else {
      var result=await self.cacheManager["ApiCircuitBreakerCache"].addCallCount(tradeObj.appkey,1);
    }
    return {status:1,msg:"OK"};
  }
}
module.exports=ApiTradeService;
