var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class AccessAuthAPI extends APIBase {
   constructor() {
      super();
      this.appS = system.getObject("service.common.appSve");
      this.apitradeSvr = system.getObject("service.common.apitradeSve");
      this.authUtils = system.getObject("util.businessManager.authUtils");
      this.userSve = system.getObject("service.auth.userSve");
   }
   /*查询注册用户的信息sys*/
   async queryRegUser(pobj, query, req){
        var appid=req.app.id;
        var userList=    await this.userSve.queryUsersByAppId(appid);
        return system.getResult(userList);
   }
   /**
    * 发送短信
    * @param {*} pobj {mobile为要发送的手机号，tmplCode为发送短信编码，需在阿里开通，signName为短信头描述信息}
    * @param {*} query 
    * @param {*} req 
    */
   async fetchVCode(pobj, query, req) {
      var appkey = req.app.appkey;
      var mobile = pobj.mobile;
      var tmplCode = pobj.tmplCode;
      var signName = pobj.signName;
      //var msg=pobj.msg;

      if (!mobile) {
         return system.getResult(null, "电话号码不能为空.");
      }
      // if(!msg){
      //    return system.getResult(null,"发送的内容不能为空.");
      // }
      if (!tmplCode) {
         return system.getResult(null, "模版编码不能为空.");
      }
      if (!signName) {
         return system.getResult(null, "短信签名不能为空.");
      }
      if (tmplCode && tmplCode.indexOf("SMS_") < 0) {
         return system.getResult(null, "模版编码有误");
      }
      var vcodeResult = await this.cacheManager["VCodeCache"].cache(appkey + "_" + mobile, tmplCode, 120, signName);
      return system.getResult(vcodeResult);
   }
   /**
       * 发送短信
       * @param {*} pobj {mobile为要发送的手机号，tmplCode为发送短信编码，需在阿里开通，signName为短信头描述信息}
       * @param {*} query 
       * @param {*} req 
       */
   async fetchDefaultVCode(pobj, query, req) {
      var appkey = req.app.appkey;
      var mobile = pobj.mobile;
      if (!mobile) {
         return system.getResult(null, "电话号码不能为空.");
      }
      var vcodeResult = this.cacheManager["VCodeCache"].cache(appkey + "_" + mobile, null, 60);
      return system.getResult(vcodeResult);
   }
   async authAccessKey(pobj, query, req) {
      var acckapp = await this.cacheManager["ApiAccessKeyCache"].cache(pobj.checkAccessKey);
      if (!acckapp) {
         return system.getResultFail(system.tokenFail, "访问token失效，请重新获取");
      }
      return system.getResultSuccess({ isaccess: true, app: acckapp });
   }
   async getAccessKey(pobj, query, req) {
      var appkey = query.appkey;
      var secret = query.secret;
      if (!appkey) {
         appkey = pobj.appkey;
         secret = pobj.secret;
      }
      var appData = await this.authUtils.getTokenInfo(appkey, secret);
      if (appData.status != 0) {
         return appData;
      }

      //构造oath
      var oathstr = settings.homePage() + "?appKey=" + appData.data.appkey + "#/login";
      var oathreg = settings.homePage() + "?appKey=" + appData.data.appkey + "#/register";
      appData.data.oauthlogin = oathstr;
      appData.data.oauthreg = oathreg;
      var rtnData = {};
      rtnData.accessKey = appData.data.accessKey;
      delete appData.data["accessKey"];
      rtnData.app = appData.data;
      return system.getResultSuccess(rtnData);
   }
   async apiAccessCount(p, q, r) {
      var tradeObj = {
         srcappkey: p.srcappkey,
         tradeType: "consume",
         op: p.op,
         params: p.params,
         clientIp: p.clientIp,
         agent: p.agent,
         destappkey: p.destappkey
      }
      var t = await this.apitradeSvr.create(tradeObj);
      return system.getResultSuccess(t);
   }
   async register(pobj, qobj, req) {
      if (!pobj.userName) {
         return system.getResult(null, "用户名不能为空");
      }
      if (!pobj.mobile) {
         return system.getResult(null, "手机号不能为空");
      }
      if (!pobj.password) {
         return system.getResult(null, "密码不能为空");
      }
      var param = {
         app_id: req.app.id,
         userName: pobj.userName,
         mobile: pobj.mobile,
         password: pobj.password
      }
      var ruser = await this.userSve.register(param);
      if (!ruser) {
         return system.getResultFail(system.existUserRegFail, "已经存在此用户，注册失败");
      }//status=2000
      var opencode = super.getUUID();
      var authUrl = req.app.authUrl + "?opencode=" + opencode;
      await this.cacheManager["OpenCodeCache"].cache(opencode, ruser, 30);
      return system.getResultSuccess({ auth_url: authUrl, opencode: opencode, open_user_id: ruser.id });
   }
   async login(pobj, qobj, req) {
      if (!pobj.userName) {
         return system.getResult(null, "用户名不能为空");
      }
      if (!pobj.password) {
         return system.getResult(null, "密码不能为空");
      }
      var param = {
         app_id: req.app.id,
         userName: pobj.userName,
         password: pobj.password
      }
      var ruser = await this.userSve.getUserByUserNamePwdForApi(param);
      if (!ruser) {
         return system.getResultFail(system.userLoginFail, "用户名或密码错误");
      }//status=2010
      var opencode = super.getUUID();
      var authUrl = req.app.authUrl + "?opencode=" + opencode;
      await this.cacheManager["OpenCodeCache"].cache(opencode, ruser, 120);
      return system.getResultSuccess({ auth_url: authUrl, opencode: opencode });
   }
   async loginByMobileWithoutReg(pobj, qobj, req) {
      if (!pobj.mobile) {
         return system.getResult(null, "电话不能为空");
      }
      var param = {
         app_id: req.app.id,
         mobile: pobj.mobile,
      }
      var ruser = await this.userSve.getUserByUserMobile(param);
      if (!ruser) {
         return system.getResult(null,"查无此用户");
      }
      var opencode = super.getUUID();
      var authUrl = req.app.authUrl + "?opencode=" + opencode;
      await this.cacheManager["OpenCodeCache"].cache(opencode, ruser, 120);
      return system.getResultSuccess({ auth_url: authUrl, opencode: opencode });
   }
   async loginByMobileWithReg(pobj, qobj, req) {
      if (!pobj.mobile) {
         return system.getResult(null, "电话不能为空");
      }
      var ruser = await this.userSve.getUserByUserMobile(param);
      if (!ruser) {
         param = {
            app_id: req.app.id,
            userName: pobj.mobile,
            nickName:pobj.mobile,
            mobile: pobj.mobile,
            password: pobj.mobile
         }
         ruser = await this.userSve.register(param);
      }
      var opencode = super.getUUID();
      var authUrl = req.app.authUrl + "?opencode=" + opencode;
      await this.cacheManager["OpenCodeCache"].cache(opencode, ruser, 120);
      return system.getResultSuccess({ auth_url: authUrl, opencode: opencode });
   }
   async loginByMd5Password(pobj, qobj, req) {
      if (!pobj.userName) {
         return system.getResult(null, "用户名不能为空");
      }
      if (!pobj.password) {
         return system.getResult(null, "密码不能为空");
      }
      var param = {
         app_id: req.app.id,
         userName: pobj.userName,
         password: pobj.password,
         isNavto: true
      }
      var ruser = await this.userSve.getUserByUserNamePwd(param);
      var opencode = super.getUUID();
      var authUrl = req.app.authUrl + "?opencode=" + opencode;
      await this.cacheManager["OpenCodeCache"].cache(opencode, ruser, 30);
      return system.getResultSuccess({ auth_url: authUrl, opencode: opencode });
   }
   /**
    * 按照手机号和验证码修改密码
    */
   async modiPasswordByMobile(pobj, qobj, req){
      var appid=req.app.id;
      var appkey=req.app.appkey;
      if (!pobj.mobile) {
         return system.getResult(null, "电话号码不能未空.");
      }
      if (!pobj.vcode) {
         return system.getResult(null, "验证码不能未空.");
      }
      if (!pobj.newPwd) {
         return system.getResult(null, "新密码不能未空.");
      }
      var cacheCode = await this.cacheManager["VCodeCache"].cache(appkey + "_" + pobj.mobile, null);
      if (pobj.vcode != cacheCode.vcode) {
         return system.getResultFail(-1, "验证码校验不成功，请重新获取验证码验证.",system.verifyVCodeFail);
      }
      //按照appid和电话查询出要修改的用户
      var ruser = await this.userSve.modiPasswordByMobile(appid,pobj.mobile,pobj.newPwd);
      return system.getResult(ruser);
  }
   /**
    * 按照账号和appid修改密码
    */
   async modiPasswordByUserName(pobj, qobj, req){
       var appid=req.app.id;
       if (!pobj.userName) {
         return system.getResult(null, "账号不能未空.");
      }
      if (!pobj.newPwd) {
         return system.getResult(null, "新密码不能未空.");
      }
      // if (!pobj.oldPwd) {
      //    return system.getResult(null, "旧密码不能未空.");
      // }
      var ruser = await this.userSve.modiPasswordByUserName(appid,pobj.userName,pobj.newPwd,pobj.oldPwd);
      return system.getResult(ruser);
   }
   /**
    * 如果验证成功而账户不存在就创建一个账号
    * @param {*} pobj 
    * @param {*} qobj 
    * @param {*} req 
    */
   async loginByVCode(pobj, qobj, req) {
      var appkey = req.app.appkey;
      if (!pobj.mobile) {
         return system.getResult(null, "电话号码不能未空.");
      }
      if (!pobj.vcode) {
         return system.getResult(null, "验证码不能未空.");
      }
      var cacheCode = await this.cacheManager["VCodeCache"].cache(appkey + "_" + pobj.mobile, null);
      if (pobj.vcode != cacheCode.vcode) {
         return system.getResult(system.verifyVCodeFail, "验证码校验不成功，请重新获取验证码验证.");
      }
      var param = {
         app_id: req.app.id,
         mobile: pobj.mobile,
      }
      var ruser = await this.userSve.getUserByUserMobile(param);
      if (!ruser) {
         param = {
            app_id: req.app.id,
            userName: pobj.mobile,
            nickName:pobj.mobile,
            mobile: pobj.mobile,
            password: pobj.mobile
         }
         ruser = await this.userSve.register(param);
      }
      var opencode = super.getUUID();
      var authUrl = req.app.authUrl + "?opencode=" + opencode;
      await this.cacheManager["OpenCodeCache"].cache(opencode, ruser, 120);
      return system.getResultSuccess({ auth_url: authUrl, opencode: opencode });
   }

   /**
    * 非平台应用回调处理函数中需要把
    * req.code提取出来，并调用下方函数，返回对应的openuser,给
    * 非平台应用
    * @param {*} pobj 
    * @param {*} query 
    * @param {*} req 
    */
   async authByCode(pobj, query, req) {
      if (!pobj.opencode) {
         return system.getResult(null, "opencode参数不能为空");
      }
      var cacheuser = await this.userSve.authByCode(pobj.opencode);
      if (!cacheuser) {
         return system.getResult(system.verifyOpencodeFail, "opencode存储的值已经失效，请重新获取用户的opencode.");
      }
      return system.getResultSuccess(cacheuser);
   }

   classDesc() {
      return {
         groupName: "auth",
         groupDesc: "认证相关的包",
         name: "AccessAuthAPI",
         desc: "关于认证的类",
         exam: `
             post  http://p.apps.com/api/auth/accessAuth/getAccessKey
             {
                appKey:xxxxx,
                secret:yyyyyy
             }
         `,
      };
   }
   methodDescs() {
      return [

         {
            methodDesc: "生成访问token,访问地址：http://......../api/auth/accessAuth/getAccessKey,访问token需要放置到后续API方法调用的请求头中",
            methodName: "getAccessKey",
            paramdescs: [
               {
                  paramDesc: "访问appkey",
                  paramName: "appkey",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "访问secret",
                  paramName: "secret",
                  paramType: "string",
                  defaultValue: "",
               }
            ],
            rtnTypeDesc: "返回JSON对象字符串",
            rtnType: "json object {accessKey: xxxxxx, app: {xxx:xxx}},注意app,是当前app信息,详细见后面示例"
         },
         {
            methodDesc: "注册方法,访问地址：http://......../api/auth/accessAuth/register",
            methodName: "register",
            paramdescs: [
               {
                  paramDesc: "用户名",
                  paramName: "userName",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "密码",
                  paramName: "password",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "电话",
                  paramName: "mobile",
                  paramType: "string",
                  defaultValue: "",
               }
            ],
            rtnTypeDesc: "返回JSON对象字符串",
            rtnType: "json object{ auth_url: xxxxx/auth?opencode=xxxxx }),详细见后面示例"
         },
         {
            methodDesc: "登录方法,访问地址：http://......../api/auth/accessAuth/login",
            methodName: "login",
            paramdescs: [
               {
                  paramDesc: "用户名",
                  paramName: "userName",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "密码",
                  paramName: "password",
                  paramType: "string",
                  defaultValue: "",
               }
            ],
            rtnTypeDesc: "返回JSON对象字符串",
            rtnType: "json object{ auth_url: xxxxx/auth?opencode=xxxxx }),详细见后面示例"
         },
         {
            methodDesc: "获取手机验证,访问地址：http://......../api/auth/accessAuth/fetchVCode,访问token需要放置到后续API方法调用的请求头中",
            methodName: "fetchVCode",
            paramdescs: [
               {
                  paramDesc: "手机号码",
                  paramName: "mobile",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "模版CODE",
                  paramName: "tmplCode",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "签名",
                  paramName: "signName",
                  paramType: "string",
                  defaultValue: "",
               },
            ],
            rtnTypeDesc: "返回JSON对象字符串,会在平台缓存60秒",
            rtnType: "json object{status:0,data:{ vcode: xxxxxx}},详细见后面示例"
         },
         {
            methodDesc: "验证码登录,访问地址：http://......../api/auth/accessAuth/loginByVCode,访问token需要放置到后续API方法调用的请求头中",
            methodName: "loginByVCode",
            paramdescs: [
               {
                  paramDesc: "手机号码",
                  paramName: "mobile",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "获取到的验证码",
                  paramName: "vcode",
                  paramType: "string",
                  defaultValue: "",
               },
            ],
            rtnTypeDesc: "返回JSON对象字符串",
            rtnType: "json object{auth_url: xxxxx/auth?opencode=xxxxx }),详细见后面示例"
         },
         {
            methodDesc: "验证码登录,访问地址：http://......../api/auth/accessAuth/loginByMobileWithReg,访问token需要放置到后续API方法调用的请求头中",
            methodName: "loginByVCode",
            paramdescs: [
               {
                  paramDesc: "手机号码",
                  paramName: "mobile",
                  paramType: "string",
                  defaultValue: "",
               },
            ],
            rtnTypeDesc: "返回JSON对象字符串",
            rtnType: "json object{auth_url: xxxxx/auth?opencode=xxxxx }),详细见后面示例"
         },
         {
            methodDesc: "验证码登录,访问地址：http://......../api/auth/accessAuth/loginByMobileWithoutReg,访问token需要放置到后续API方法调用的请求头中",
            methodName: "loginByVCode",
            paramdescs: [
               {
                  paramDesc: "手机号码",
                  paramName: "mobile",
                  paramType: "string",
                  defaultValue: "",
               },
            ],
            rtnTypeDesc: "返回JSON对象字符串",
            rtnType: "json object{auth_url: xxxxx/auth?opencode=xxxxx }),详细见后面示例"
         },
         {
            methodDesc: "按照opencode获取用户信息,访问地址：http://......../api/auth/accessAuth/authByCode,访问token需要放置到后续API方法调用的请求头中",
            methodName: "authByCode",
            paramdescs: [
               {
                  paramDesc: "开放code,用于换取用户信息",
                  paramName: "opencode",
                  paramType: "string",
                  defaultValue: "",
               }
            ],
            rtnTypeDesc: "返回JSON对象字符串",
            rtnType: "json object{status:0,data:{}}),详细见后面示例"
         },
         {
            methodDesc: "按照手机号、验证码修改密码,访问地址：http://......../api/auth/accessAuth/modiPasswordByMobile,访问token需要放置到后续API方法调用的请求头中",
            methodName: "modiPasswordByMobile",
            paramdescs: [
               {
                  paramDesc: "手机号",
                  paramName: "mobile",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "验证码",
                  paramName: "vcode",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "新密码",
                  paramName: "newPwd",
                  paramType: "string",
                  defaultValue: "",
               }
            ],
            rtnTypeDesc: "返回修改后的用户",
            rtnType: "json object{status:-1,data:2030),验证码错误，成功：{status:0,...}"
         },
         {
            methodDesc: "按照手机号、验证码修改密码,访问地址：http://......../api/auth/accessAuth/modiPasswordByUserName,访问token需要放置到后续API方法调用的请求头中",
            methodName: "modiPasswordByUserName",
            paramdescs: [
               {
                  paramDesc: "账户名",
                  paramName: "userName",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "新密码",
                  paramName: "newPwd",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "旧密码,可不传,不传时,供新建账号设置密码",
                  paramName: "oldPwd",
                  paramType: "string",
                  defaultValue: "",
               }
            ],
            rtnTypeDesc: "返回修改后的用户",
            rtnType: "json object{status:0,data:{}}),详细见后面示例"
         },
         {
            methodDesc: "查询应用注册用户,访问地址：http://......../api/auth/accessAuth/queryRegUser,访问token需要放置到后续API方法调用的请求头中",
            methodName: "queryRegUser",
            paramdescs: [
               {
             
               }
            ],
            rtnTypeDesc: "返回应用的注册用户",
            rtnType: "json object{status:0,data:[])"
         },
      ];
   }
   exam() {
      return `
     <pre>
      
     1.获取访问Token （建议在本地缓存<3600S）
        curl -k -H 'Content-type: application/json' -d '{appkey:xxxxx,secret:xxxx}' http://open.gongsibao.com/api/auth/accessAuth/getAccessKey
        返回：
        {
         status:0,
         data:{
          {
             accessKey:xxxxxxx,
             app:{xxxx:xxxx,xxx:......}
          }
         }
        }

      2.用户注册（注意请求头，设置1中获取的访问token）
      curl -k -H 'Content-type: application/json' -H  'AccessKey:{ak}' -d '{userName:xxxxx,password:xxxx,mobile:xxxxx}' http://open.gongsibao.com/api/auth/accessAuth/register
      返回：
      {
         status:0,
         data:   { 
            auth_url: "/auth?opencode=xxxxxx" 
         }
      }
      注意：接入程序后台需要处理/auth?opencode=xxx,按照opencode去开放平台获取openuser,然后在自己的应用内
      完成注册，并建立会话。

      3.用户登录（注意请求头，设置1中获取的访问token）
      curl -k -H 'Content-type: application/json' -H  'AccessKey:{ak}' -d '{userName:xxxxx,password:xxxx}' http://open.gongsibao.com/api/auth/accessAuth/login
      返回：
      {
         status:0,
         data:   { 
            auth_url: "/auth?opencode=xxxxxx" 
         }
      }
   
      注意：接入程序后台需要处理/auth?opencode=xxx,按照opencode去开放平台获取openuser,然后在自己的应用内
      完成登录，并建立会话。


      4、获取手机验证码（注意请求头，设置1中获取的访问token）
      curl -k -H 'Content-type: application/json' -H  'AccessKey:{ak}' -d '{mobile:xxxxx,tmplCode:"",signName:""}' http://open.gongsibao.com/api/auth/accessAuth/login
       返回：
       { 
          status:0,
          data:{
             vcode: "xxxxxx" 
          }
       }
       5、手机验证码登录（注意请求头，设置1中获取的访问token）
      curl -k -H 'Content-type: application/json' -H  'AccessKey:{ak}' -d '{mobile:xxxxx,vcode:xxxxxx}' http://open.gongsibao.com/api/auth/accessAuth/loginByVCode
       返回：
       { 
          status:0,
          data:   { 
            auth_url: "/auth?opencode=xxxxxx" 
         }
       }
       6、换取开放用户信息（注意请求头，设置1中获取的访问token）
       curl -k -H 'Content-type: application/json' -H  'AccessKey:{ak}' -d '{opencode:xxxxx}' http://open.gongsibao.com/api/auth/accessAuth/authByCode
        返回：
        { 
           status:0,
           data:   { 
             
           }
        }
     </pre>

  
      <h3>开放平台单点注册/登录流程图</h3>
      <img  src="data:image/png;base64,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"/>  `
         ;
   }

}
module.exports = AccessAuthAPI;
// var req={app:{appkey:"wx76a324c5d201d1a4"}};
// var p={mobile:"13381139519",tmplCode:"SMS_173946419","signName":"ibossx"};
// var x=new AccessAuthAPI();
// var ff=x.fetchVCode(p,null,req);
// ff.then((v)=>{
//   console.log(v);
// })