<a name="menu">目录</a>
1. [商户信息查询](#getById)
1. [批量查商户映射信息](#getMapByIds)
1. [商户名称列表](#nameList)
1. [添加商户](#addMerchant)
1. [编辑商户](#updMerchant)
1. [商户列表](#merchantList)
1. [商户审核](#auditMerchant)
1. [商户签约](#merchantSign)
1. [查看签约](#signInfo)


## **<a name="nameList"> 商户信息查询</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "action_process": "test",
        "action_type": "getById",
        "action_body": {
            "id": "11064624178480175",      // 商户id
            "options": {                    // 商户相关信息查询，可以为空
                "title": true,              // true时查询商户抬头信息
                "address": true             // true时查询商户地址信息
            }
        }
    }

```

#### 返回结果
```javascript

    {
        "status": 0,
        "msg": "success",
        "data": {
            "id": "11064624202480602",              // 商户id
            "name": "杨庆菊的公司7",                  // 商户名称
            "taxType": "00",                        // 纳税人类型
            "taxTypeName": "一般纳税人",              // 纳税人类型名称
            "contactName": "杨庆菊",                 // 联系人姓名
            "contactMobile": "杨庆菊手机号",          // 联系人手机号
            "contactEmail": "杨庆菊email",           // 联系人邮箱
            "invoiceValid": 1,                      // 开票申请校验 0否 1是
            "mustPay": 1,                           // 校验订单支付 0否 1是
            "ownerName": "客户经  杨庆菊",            // 客户经理姓名
            "ownerMobile": "客户经理杨庆菊手机",       // 客户经理手机号
            "statusName": "待审核",                  // 商户状态名称
            "status": "00",                         // 商户状态 00待审核 10待签约 90签约完成
            "created_at": "2019-10-01 09:04",       // 添加时间


            "titleList": [                          // 商户抬头列表
                {
                    "id": "13661908986000576",
                    "taxNo": "杨庆菊客户的税号",                    // 纳税人识别号
                    "invoiceAddr": "杨庆菊客户的地址",              // 开票地址
                    "invoiceMobile": "杨庆菊客户开票手机号",         // 开票电话
                    "accountName": "杨庆菊客户的账户名称",           // 开户名称
                    "accountPublic": "杨庆菊客户的对公账户",         // 对公账户
                }
            ],
            "addressList": [
                {
                    "id": "12085607321000472",
                    "mailAddr": "杨庆菊客户的邮寄地址",             // 邮寄地址
                    "mailTo": "杨庆菊客户的收件人",                 // 收件人
                    "mailMobile": "杨庆菊客户的收件人的手机号",      // 收件电话
                }
            ]
        },
        "requestid": "7c8002bbd6d847ae9ca37e5bc0b06469"
    }

```


## **<a name="getMapByIds"> 批量查商户映射信息</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "getMapByIds",
        "action_body": {
            "ids": ["11064622752480048",...],         // 商户id数组
            "attrs": ["id", "name"]                   // 商户返回结果字段
        }
    }

```

#### 返回结果
```javascript

    {
        "status": 0,
        "msg": "success",
        "data": {
            "11064622752480048": {
                "id": "11064622752480048",
                "name": "十一加班干这个事"
            },
            "11064624178480175": {
                "id": "11064624178480175",
                "name": "杨庆菊的公司2"
            },
            "11064624192480327": {
                "id": "11064624192480327",
                "name": "杨庆菊的公司4"
            }
        },
        "requestid": "52b1fc05d43c44e2842553b9e4b8b72c"
    }

```


## **<a name="nameList"> 商户nameList</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "action_process": "test",           // 请求源
        "action_type": "nameList",          // api接口名
        "action_body": {}
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": [
        {
            "id": 110361382269,         // 商户id
            "name": "司机宝"             // 商户名称
        },
    ]
}
```


## **<a name="addMerchant"> 添加商户</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "action_process": "test",
        "action_type": "addMerchant",
        "action_body": {
            "name": "杨庆菊的公司10",                           // 商户名称
            "taxType": "00",                                  // 纳税人类型
            "contactName": "杨庆菊",                           // 联系人姓名
            "contactMobile": "杨庆菊手机号",                    // 联系人手机号
            "contactEmail": "杨庆菊email",                     // 联系人邮箱
            "invoiceValid": 1,                                // 开票申请校验 0否 1是
            "mustPay": 1,                                     // 校验订单支付 0否 1是
            
            "ownerName": "客户经  杨庆菊",                      // 客户经理姓名
            "ownerMobile": "客户经理杨庆菊手机",                 // 客户经理手机号
            "ownerId": "客户经理杨庆菊id",                      // 客户经历id
            "ownerPath": "客户经理杨庆菊组织机构",                // 客户经历组织机构path
            "status": "00",                                   // 商户状态 00待审核 10待签约 90签约完成

            // 商户默认抬头信息
            "title": {  
                "taxNo": "杨庆菊客户的税号",                    // 纳税人识别号
                "invoiceAddr": "杨庆菊客户的地址",              // 开票地址
                "invoiceMobile": "杨庆菊客户开票手机号",         // 开票电话
                "accountName": "杨庆菊客户的账户名称",           // 开户名称
                "accountPublic": "杨庆菊客户的对公账户",         // 对公账户
            },

            // 商户默认地址信息
            "address": {
                "mailAddr": "杨庆菊客户的邮寄地址",             // 邮寄地址
                "mailTo": "杨庆菊客户的收件人",                 // 收件人
                "mailMobile": "杨庆菊客户的收件人的手机号",      // 收件电话
            }
        }
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": {商户信息}                  // 返回商户信息
}
```



## **<a name="updMerchant"> 编辑商户</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "action_process": "test",
        "action_type": "updMerchant",
        "action_body": {
            "id": "11064625945481089",                        // 商户ID
            "name": "杨庆菊的公司10",                           // 商户名称
            "taxType": "00",                                  // 纳税人类型
            "contactName": "杨庆菊",                           // 联系人姓名
            "contactMobile": "杨庆菊手机号",                    // 联系人手机号
            "contactEmail": "杨庆菊email",                     // 联系人邮箱
            "invoiceValid": 1,                                // 开票申请校验 0否 1是
            "mustPay": 1,                                     // 校验订单支付 0否 1是
            
            "ownerName": "客户经  杨庆菊",                      // 客户经理姓名
            "ownerMobile": "客户经理杨庆菊手机",                 // 客户经理手机号
            "ownerId": "客户经理杨庆菊id",                      // 客户经历id
            "ownerPath": "客户经理杨庆菊组织机构",                // 客户经历组织机构path
        }
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": {商户信息}                  // 返回商户信息
}
```

## **<a name="merchantList"> 商户列表</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript
    {
        "action_process": "test",           // 请求源
        "action_type": "nameList",          // api接口名
        "action_body": {
            "currentPage": "2",
            "pageSize": "3",
            "merchantId": "",               // 商户id
            "createdBegin": "",             // 创建时间-开始
            "createdEnd": ""                // 创建时间-结束
        }
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": {
        "count": 10,
        "rows": [
            {
                "id": "11064624202480602",              // 商户id
                "name": "杨庆菊的公司7",                  // 商户名称
                "taxType": "00",                        // 纳税人类型
                "taxTypeName": "一般纳税人",              // 纳税人类型名称
                "contactName": "杨庆菊",                 // 联系人姓名
                "contactMobile": "杨庆菊手机号",          // 联系人手机号
                "contactEmail": "杨庆菊email",           // 联系人邮箱
                "invoiceValid": 1,                      // 开票申请校验 0否 1是
                "mustPay": 1,                           // 校验订单支付 0否 1是
                "ownerName": "客户经  杨庆菊",            // 客户经理姓名
                "ownerMobile": "客户经理杨庆菊手机",       // 客户经理手机号
                "statusName": "待审核",                  // 商户状态名称
                "status": "00",                         // 商户状态 00待审核 10待签约 90签约完成
                "created_at": "2019-10-01 09:04",       // 添加时间
            },
        ]
    },
    "requestid": "081f13fd9dd5441094487eeff6d0ff6f"
}
```


## **<a name="auditMerchant"> 商户审核</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "auditMerchant",
        "action_body": {
            "id": "11064625945481089",      // 商户ID
            "status": "10",                 // 商户状态 10待签约
            "ucname": "138888",             // 登录名
            "ucid": "222222222222222"       // 用户id
        }
    }

```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "success",
    "data": {},
    "requestid": "081f13fd9dd5441094487eeff6d0ff6f"
}
```

## **<a name="merchantSign"> 添加/修改签约</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "saveMerchantSign",
        "action_body": {
            "merchantId": "11064625945481089",          // 商户id
            "nameA": "杨庆菊的主体2222",                  // 签约主体
            "contractNo": "杨庆菊录入合同2222号",          // 合同编号
            "beginDate": "2019-10-01",                  // 合同开始时间
            "endDate": "2019-10-07",                    // 合同截至时间
            "serviceRate": "332"                       // 服务费比率（例：3.32%, 这里需要传入300）
        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success"
    }

```


## **<a name="signInfo"> 查看签约</a>**
[返回到目录](#menu)
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`

``` javascript

    {
        "action_process": "test",
        "action_type": "merchantSignInfo",
        "action_body": {
            "merchantId": "11064625945481089"           // 商户ID
        }
    }

```

#### 返回结果
```javascript
    {
        "status": 0,
        "msg": "success",
        "data": {
            "merchant_id": "11064625945481089",         // 商户ID
            "nameA": "杨庆菊的主体2222",                  // 签约主体
            "contractNo": "杨庆菊录入合同2222号",          // 合同编号
            "beginDate": "2019-10-01",                  // 合同开始时间
            "endDate": "2019-10-07",                    // 合同截至时间
            "serviceRateShow": 3.22                     // 服务费比率显示
            "serviceRate": 322                          // 服务费比率（整数防止精度损失）
            "created_at": "2019-10-01 11:35",           // 创建时间
        },
        "requestid": "b6df9966b91f4567887a606686952fb0"
    }

```






