const system = require("../../../system");
const ServiceBase = require("../../sve.base")
const settings = require("../../../../config/settings")
class DeliverService extends ServiceBase {
  constructor() {
    super("deliver", ServiceBase.getDaoName(DeliverService));
  }

  async apiAll(params) {
    try {
      return await this.allList();
    } catch (error) {
      console.log(error);
      return system.getResult(null, "接口异常");
    }
  }

  async apiPage(params) {
    try {
      return await this.page(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, "接口异常");
    }
  }

  async apiSave(params) {
    try {
      return await this.save(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, "接口异常");
    }
  }

  async apiInfo(params) {
    try {
      return await this.info(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, "接口异常");
    }
  }

  async apiDeleteByIds(params) {
    var ids = params.ids;
    if(!ids || ids.length == 0) {
      return system.getResult(null, "传入参数错误：ids=" + JSON.stringify(ids));
    }
    try {
      for(var id of ids) {
        try {
          await this.delById(id);  
        } catch (error) {
          console.log(error);
        }
      }
      return system.getResultSuccess(1);
    } catch (error) {
      return system.getResult(null, "接口异常");
    }
  }

  // -----------------------以此间隔，上面为API，下面为service---------------------------------

  async info(params) {
    var id = params.id;
    var sqlWhere = {
      where: {
        id: id
      },
      attributes: ["id", "name", "businessmenDivide", "invoiceDivide", "isEnabled", "remark", "created_at"],
      raw: true
    };
    var item = await this.dao.model.findOne(sqlWhere);
    this.handleDate(item, ["created_at"], null, -8);
    return system.getResultSuccess(item);
  }

  async save(params) {
    var id = params.id;
    var deliver;
    if (id) {
      deliver = await this.dao.findById(id);
    } else {
      deliver = {};
    }

    deliver.name = this.trim(params.name);
    deliver.businessmenDivide = Number(params.businessmenDivide);
    deliver.invoiceDivide = Number(params.invoiceDivide);
    deliver.isEnabled = params.isEnabled == 1 ? true : 0;
    deliver.remark = this.trim(params.remark);

    if (id) {
      deliver = await deliver.save();
    } else {
      deliver = await this.dao.create(deliver);
    }
    return system.getResultSuccess(deliver);
  }

  async allList() {
    var list = await this.dao.getList(1, "id, name, businessmenDivide, invoiceDivide, remark");
    return system.getResultSuccess(list);
  }

  async delById(id) {
    if (!id) {
      return system.getResult(null, "删除失败");
    }
    await this.dao.delById(id);
    return system.getResultSuccess(1);
  }

  async page(params) {
    var currentPage = Number(params.currentPage || 1);
    var pageSize = Number(params.pageSize || 10);

    var where = {};

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "name", "businessmenDivide", "invoiceDivide", "isEnabled", "remark", "created_at"];

    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      for (var row of page.rows) {
        this.handleDate(row, ["created_at"], null, -8);
      }
    }
    return system.getResultSuccess(page);
  }
}
module.exports = DeliverService;
// var task=new UserService();
// task.getUserStatisticGroupByApp().then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });