const system = require("../../../system");
const Dao = require("../../dao.base");
class DomicileDao extends Dao {
  constructor() {
    super(Dao.getModelName(DomicileDao));
  }

  async getList(isEnabled, attrs) {
    attrs = attrs || "*"
    var sql = [];
    sql.push("SELECT ");
    sql.push(attrs);
    sql.push("FROM d_domicile");
    if (isEnabled == 1) {
      sql.push("WHERE isEnabled = 1");
    }
    return await this.customQuery(sql.join(" ")) || [];
  }

  async delById(id, t) {
    var sql = "DELETE FROM d_domicile WHERE id = :id";
    return await this.customUpdate(sql, {
      id: id
    }, t);
  }

  async findListByIds(ids) {
    if (!ids || ids.length == 0) {
      return [];
    }
    var sql = [];
    sql.push("SELECT");
    sql.push("id, name, isEnabled, created_at ");
    sql.push("FROM d_domicile");
    sql.push("WHERE id IN (:ids)");
    return await this.customQuery(sql.join(" "), {
      ids: ids
    }) || [];
  }

  async findMapByIds(ids) {
    var result = {};
    if (!ids || ids.length == 0) {
      return result;
    }
    var list = await this.findListByIds(ids);
    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      result[item.id] = item;
    }
    return result;
  }
}
module.exports = DomicileDao;
// var u=new UserDao();
// var roledao=system.getObject("db.roleDao");
// (async ()=>{
//   var users=await u.model.findAll({where:{app_id:1}});
//   var role=await roledao.model.findOne({where:{code:"guest"}});
//   console.log(role);
//   for(var i=0;i<users.length;i++){
//     await users[i].setRoles([role]);
//     console.log(i);
//   }
//
// })();