var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ActionAPI extends APIBase {
    constructor() {
        super();
        this.domicileSve = system.getObject("service.common.domicileSve");
        this.businessscopeSve = system.getObject("service.common.businessscopeSve");
        this.captchaSve = system.getObject("service.common.captchaSve");

        this.deliverSve = system.getObject("service.deliver.deliverSve");

        this.invoicecontentSve = system.getObject("service.common.invoicecontentSve");
    }
    /**
     * 接口跳转
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springboard(pobj, qobj, req) {
        var result;
        if (!pobj.action_process) {
            return system.getResult(null, "action_process参数不能为空");
        }
        if (!pobj.action_type) {
            return system.getResult(null, "action_type参数不能为空");
        }
        try {
            result = await this.handleRequest(pobj.action_process, pobj.action_type, pobj.action_body);    
        } catch (error) {
            console.log(error);
        }
        
        return result;
    }

    async handleRequest(action_process, action_type, action_body) {
        var opResult = null;
        switch (action_type) {

            // 图片验证码
            case "getCaptha":
                opResult = await this.captchaSve.apiGenerate(action_body);
                break;
            case "validCaptha":
                opResult = await this.captchaSve.apiValidator(action_body);
                break;
            // 注册地
            case "domicileNameList":
                opResult = await this.domicileSve.apiNameList(action_body);
                break;
            case "domicileTree":
                opResult = await this.domicileSve.apiTree(action_body);
                break;
            case "domicilePage":
                opResult = await this.domicileSve.apiPage(action_body);
                break;
            case "domicileSave":
                opResult = await this.domicileSve.apiSave(action_body);
                break;
            case "domicileInfo":
                opResult = await this.domicileSve.apiInfo(action_body);
                break;
            case "domicileDelete":
                opResult = await this.domicileSve.apiDeleteByIds(action_body);
                break;

            // 经营范围
            case "businessscopeByDomicileId":
                opResult = await this.businessscopeSve.apiDomicileList(action_body);
                break;
            case "businessscopePage":
                opResult = await this.businessscopeSve.apiPage(action_body);
                break;
            case "businessscopeSave":
                opResult = await this.businessscopeSve.apiSave(action_body);
                break;
            case "businessscopeInfo":
                opResult = await this.businessscopeSve.apiInfo(action_body);
                break;
            case "businessscopeDelete":
                opResult = await this.businessscopeSve.apiDeleteByIds(action_body);
                break;

            // 交付商
            case "deliverAll":
                opResult = await this.deliverSve.apiAll(action_body);
                break;
            case "deliverPage":
                opResult = await this.deliverSve.apiPage(action_body);
                break;
            case "deliverSave":
                opResult = await this.deliverSve.apiSave(action_body);
                break;
            case "deliverInfo":
                opResult = await this.deliverSve.apiInfo(action_body);
                break;
            case "deliverDelete":
                opResult = await this.deliverSve.apiDeleteByIds(action_body);
                break;

            // 发票内容
            case "invoicecontentSave":
                opResult = await this.invoicecontentSve.apiSave(action_body);
                break;
            case "invoicecontentDelete":
                opResult = await this.invoicecontentSve.apiDelete(action_body);
                break;
            case "invoiceList":
                opResult = await this.invoicecontentSve.apiList(action_body);
                break;
            case "invoicecontent":
                opResult = await this.invoicecontentSve.apiGetById(action_body);
                break;
                
                
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
    exam() {
        return `<pre><pre/>`;
    }
    classDesc() {
        return {
            groupName: "op",
            groupDesc: "元数据服务包",
            name: "ActionAPI",
            desc: "此类是对外提供接口服务",
            exam: "",
        };
    }
    methodDescs() {
        return [
            {
                methodDesc: `<pre><pre/>`,
                methodName: "springboard",
                paramdescs: [
                    {
                        paramDesc: "请求的行为，传递如：sjb",
                        paramName: "action_process",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型，详情见方法中的描述",
                        paramName: "action_type",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型的参数，action_body必须传递的参数有，times_tamp（时间戳，类型int）、sign(签名,类型string)，其余的为业务需要的参数",
                        paramName: "action_body",
                        paramType: "json",
                        defaultValue: null,
                    }
                ],
                rtnTypeDesc: `<pre><pre/>`,
                rtnType: `<pre><pre/>`
            }
        ];
    }
}
module.exports = ActionAPI;