const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class UsersService extends ServiceBase {
  constructor() {
    super("operator", ServiceBase.getDaoName(UsersService));
  }

  async findUserInfoByPhone(params){//根据电话号码获取用户信息
    var phone_no = params.phone_no;
    var users = await this.dao.findUserInfoByPhone(phone_no);
    if (users.length > 0){
      return system.getResult(users[0]);
    }
    else{
      return system.getResult(null,"不存在相关信息!");

    }
  }

  async findUserInfoByid(user_id){
    var users = await this.dao.findUserInfoByid(user_id);
    // if (users.length > 0){
    //   return system.getResult(users[0]);
    // }
    // else{
    //   return system.getResult(null,"不存在相关信息!");

    // }
    return users;
  }

  async SaveUserInfo(params){//添加和更新数据库里的信息
    var id = params.id;
    var users;
    if (id){
      users = await this.dao.findById(id);
      users.phone_no = params.phone_no;
      users.com_type = params.com_type;
      users.user_type = params.user_type;
      users.user_identity = params.user_identity;
      users.user_name = params.user_name;
      users.user_photo = params.user_photo;
      users.cert_no = params.cert_no;
      users.user_post = params.cert_post;
      users.legal_name = params.legal_name;
      users.bus_term = params.bus_term;
      users.user_address = params.user_address;
      users.cert_path = params.cert_path;
      users.is_real = params.is_real;
      users.is_com = params.is_com;
      users = await users.save();
    }
    else{
      users = await this.dao.create(params);
    }

    return system.getResult(users);
  }

}
module.exports = UsersService;

// var tesk = new UsersService();
// var par = 2;
// tesk.findUserInfoByid(par).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
