const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class RecruitService extends ServiceBase {
  constructor() {
    super("operator", ServiceBase.getDaoName(RecruitService));
  }

  async SaveRecruitInfo(params){//添加或更新招聘信息
    var id = params.id;
    var recruit;
    if (id){
      recruit = await this.dao.findById(id);
      recruit.recruit_name = params.recruit_name;
      recruit.recruit_type = params.recruit_type;
      recruit.recruit_count = params.recruit_count;
      recruit.pay_type = params.pay_type;
      recruit.pay_name = params.pay_name;
      recruit.pay_unit = params.pay_unit;
      recruit.work_duration = params.work_duration;
      recruit.basic_salary = params.basic_salary;
      recruit.compre_salary = params.compre_salary;
      recruit.rfee_type = params.rfee_type;
      recruit.rfee_unit = params.rfee_unit;
      recruit.rfee_duration = params.rfee_duration;
      recruit.rfee_time = params.rfee_time;
      recruit.age_range = params.age_range;
      recruit.work_address = params.work_address;
      recruit.publish_date = params.publish_date;
      recruit.end_date = params.end_date;
      recruit.pic_path = params.pic_path;
      recruit.recrui_require = params.recrui_require;
      recruit.phone_no = params.phone_no;
      recruit.counter_mark = params.counter_mark;
      recruit.user_id = params.user_id;
      recruit.cur_type = params.cur_type;
      recruit.cur_status = params.cur_status;
      recruit = await recruit.save();
    }
    else{
      recruit = await this.dao.create(params);
    }

    return system.getResultSuccess(recruit);
  }

  async findAllList(obj){//获取全部招聘信息，返回符合条件的列表
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sqlwhere = {
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAll(sqlwhere);
      if (list == null || list.length == 0) {
          return system.getResult(null,"没有信息");
      }else {
          return system.getResult(list);
      }
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }
  }

  async findListByUserid(obj){//获取userid招聘信息，返回符合条件的列表
    if (!obj.user_id){
      return system.getResult(null,"参数错误!");
    }
    var user_id = obj.user_id;
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sqlwhere = {
          where: {user_id:user_id},
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAll(sqlwhere);
      if (list == null || list.length == 0) {
          return system.getResult(null,"没有信息");
      }else {
          return system.getResult(list);
      }
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }
  }

  async findListByName(obj){//获取岗位名称招聘信息，返回符合条件的列表
    return await this.dao.findListByName(obj);
  }

  async findListByMark(obj){//获取标签招聘信息，返回符合条件的列表
    if (!obj.counter_mark){
      return system.getResult(null,"参数错误!");
    }
    var counter_mark = obj.counter_mark;
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sqlwhere = {
          where:{counter_mark:{[this.db.Op.like]: "%" + counter_mark + "%"}},
          order: [["publish_date", 'desc']],
          limit: pageSize,
          offset: (currentPage - 1) * pageSize,
          raw: true
      };
      var list = await this.dao.model.findAll(sqlwhere);
      if (list == null || list.length == 0) {
          return system.getResult(null,"没有信息");
      }else {
          return system.getResult(list);
      }
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }
  }


}
module.exports = RecruitService;

// var tesk = new RecruitService();
// var par = {
//   counter_mark:"高返费",
//   page_size:5,
//   current_page:1
// };
// tesk.findListByMark(par).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
