const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class LabourService extends ServiceBase {
  constructor() {
    super("operator", ServiceBase.getDaoName(LabourService));
  }

  async SaveLabourInfo(params){//添加或更新招聘信息
    var id = params.id;
    var labour;
    if (id){
      labour = await this.dao.findById(id);
      labour.labour_type = params.labour_type;
      labour.labour_count = params.labour_count;
      labour.age_range = params.age_range;
      labour.sex_ratio = params.sex_ratio;
      labour.labour_address = params.labour_address;
      labour.report_date = params.report_date;
      labour.work_address = params.work_address;
      labour.situation_memo = params.situation_memo;
      labour.phone_no = params.phone_no;
      labour.user_id = params.user_id;
      labour.publish_date= params.publish_date;
      labour = await labour.save();
    }
    else{
      labour = await this.dao.create(params);
    }

    return system.getResultSuccess(labour);
  }

}
module.exports = LabourService;

// var tesk = new RecruitService();
// var par = {
//   user_id:1,
//   oper_type:0,
//   oper_name:"登录",
//   oper_date:(new Date()).Format("yyyy-MM-dd hh:mm:ss"),
// };
// tesk.SaveLogInfo(par).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
