const system=require("../../../system");
const Dao=require("../../dao.base");
class UsersDao extends Dao{
  constructor(){
    super(Dao.getModelName(UsersDao));
  }

  async nameList() {
    var sql = "SELECT * FROM user_info";
    return await this.customQuery(sql);
  }

  async findUserInfoByPhone(phone_no){
    var sql = "select * from user_info where phone_no = :phone";
    return await this.customQuery(sql, {phone:phone_no});
  }

  async findUserInfoByid(user_id){
    return this.model.findOne(
      {
        where:{id:user_id},
        raw:true
      }
    );
  }

  async findUserInfoByids(ids,attrs){
    var result = {};
    if (!ids || ids.length == 0){
      return result;
    }

    attrs = attrs || "*";
    var sql = "select " + attrs + "from user_info where id in (:ids)";
    var list = await this.customQuery(sql,{ids:ids});
    if (!list || list.length == 0){
      return result;
    }

    for (var item of list){
      result[item.id] = item;
    }

    return result;
  }

}
module.exports=UsersDao;

var tesk = new UsersDao();
var res = tesk.nameList();
console.log(res);
