const system=require("../../../system");
const Dao=require("../../dao.base");
class RecruitDao extends Dao{
  constructor(){
    super(Dao.getModelName(RecruitDao));
  }

  async findListByName(obj){//获取岗位名称招聘信息，返回符合条件的列表
    if (!obj.recruit_name){
      return system.getResult(null,"参数错误!");
    }
    var recruit_name = obj.recruit_name;
    var pageSize=obj.page_size || 10;
    var currentPage=obj.current_page || 1;
    try {
      var sql = "SELECT * FROM recruit_info WHERE recruit_name LIKE :name order by publish_date desc limit :one,:two";
      var list = await this.customQuery(sql, {name : "%" + recruit_name + "%",one:(currentPage - 1) * pageSize,two:pageSize});
      if (list == null || list.length == 0) {
          return system.getResult(null,"没有信息");
      }else {
          return system.getResult(list);
      }
    }catch (e) {
      console.log(e);
      return system.getResult(null,"操作失败");
    }
  }

}
module.exports=RecruitDao;

