var APIBase =require("../../api.base");
var system=require("../../../system");
class LaoActionApi extends APIBase{
   constructor(){
       super();
       this.usersSve = system.getObject("service.operator.usersSve");
       this.logSve = system.getObject("service.operator.logSve");
       this.recruitSve = system.getObject("service.operator.recruitSve");
       this.labourSve = system.getObject("service.operator.labourSve");
    }

   async test(pobj,query){
      return system.getResultSuccess({hello:"ok"});
   }

   async UserLog(phone_no){//用户登录,返回用户信息
    if (!phone_no) {
        return system.getResult(null, "电话号码不能为空");
    }

    if (phone_no.length != 11){
        return system.getResult(null, "电话号码不能为空");
    }
    var parm = {phone_no:phone_no}
    var result = await this.usersSve.findUserInfoByPhone(parm);
    if (result.status == 0){
        return result;
    }
    else{
        parm = {phone_no:phone_no,com_type:1,user_type:"招人方"};
        result = this.usersSve.SaveUserInfo(parm);
        user_id = result.data[0].id;
        parm = {user_id:user_id,
            oper_type:0,
            oper_name:"登录",
            oper_date:(new Date()).Format("yyyy-MM-dd hh:mm:ss")
        };
        this.logSve.SaveLogInfo(parm);
        return result;
    }

   }

   async SaveRecruitInfo(obj){//添加或更新招聘信息,返回添加或更新后的信息
    if (!obj){
        return system.getResult(null, "参数不能为空");
    }
    var parm = {};
    parm.id = obj.id;
    parm.recruit_name = obj.recruit_name;
    parm.recruit_type = obj.recruit_type;
    parm.recruit_count = obj.recruit_count;
    parm.pay_name = obj.pay_name;
    if (obj.pay_name == "月薪"){
        parm.pay_type = 1;

    }
    else if (obj.pay_name == "日薪"){
        parm.pay_type = 2;
    }
    else if (obj.pay_name == "时薪"){
        parm.pay_type = 3;
    }

    parm.pay_unit = obj.pay_unit * 100;//按分存储
    parm.work_duration = obj.work_duration;
    parm.basic_salary = obj.basic_salary *100;
    parm.compre_salary = obj.compre_salary*100;
    if (obj.rfee_type == "月返"){
        parm.rfee_type = 1;
    }
    else if (obj.rfee_type == "日返"){
        parm.rfee_type = 2;
    }
    else if (obj.rfee_type == "时返"){
        parm.rfee_type = 3;
    }
    else if (obj.rfee_type == "一次返"){
        parm.rfee_type = 4;
    }
    else if (obj.rfee_type == "面议"){
        parm.rfee_type = 0;
    }

    parm.rfee_unit = obj.rfee_unit *100;//按分存储
    parm.rfee_duration = obj.rfee_duration;
    parm.rfee_time = obj.rfee_time;
    parm.age_range = obj.age_range;
    parm.work_address = obj.work_address;
    parm.publish_date = (new Date()).Format("yyyy-MM-dd");
    parm.end_date = obj.end_date;
    parm.pic_path = obj.pic_path;
    parm.recrui_require = obj.recrui_require;
    parm.phone_no = obj.phone_no;
    parm.counter_mark = obj.counter_mark;
    parm.user_id = obj.user_id;
    var result = await this.recruitSve.SaveRecruitInfo(parm);
    return system.getResult(result.data.dataValues);
   }

   async SaveLabourInfo(obj){//添加或更新招工信息，返回添加或更新后的招工信息
    if (!obj){
        return system.getResult(null, "参数不能为空");
    }

    var parm = {};
    parm.id = obj.id;
    parm.labour_type = obj.labour_type;
    parm.labour_count = obj.labour_count;
    parm.age_range = obj.age_range;
    parm.sex_ratio = obj.sex_ratio;
    parm.labour_address = obj.labour_address;
    parm.report_date = obj.report_date;
    parm.work_address = obj.work_address;
    parm.situation_memo = obj.situation_memo;
    parm.phone_no = obj.phone_no;
    parm.user_id = obj.user_id;
    parm.publish_date = (new Date()).Format("yyyy-MM-dd");
    var result = await this.labourSve.SaveLabourInfo(parm);
    return system.getResult(result.data.dataValues);

   }

   async FindRecruitInfo(obj){
    if (!obj){
        return system.getResult(null, "参数不能为空");
    }
    var find_type = obj.find_type;
    var temp_info = {};
    var parm = {};
    parm.page_size = obj.page_size;
    parm.current_page=obj.current_page;
    if (find_type == 0){
        temp_info = await this.recruitSve.findAllList(parm);
    }
    else if (find_type == 1){
        parm.user_id = obj.find_info;
        temp_info = await this.recruitSve.findListByUserid(parm);
    }
    else if (find_type == 2){
        parm.recruit_name = obj.find_info;
        temp_info = await this.recruitSve.findListByName(parm);
    }
    else if (find_type == 3){
        parm.counter_mark = obj.find_info;
        temp_info = await this.recruitSve.findListByMark(parm);
    }

    if (temp_info.status == 0){
        var list = [];
        for (var data of temp_info.data){
            console.log(data);
            var user_info = await this.usersSve.findUserInfoByid(data.user_id);
            console.log(user_info);
            list.push({user_info:user_info,data_info:data});
        }
        return system.getResult(list);
    }
    else{
        return system.getResult(null,"获取数据失败");
    }
   }

   exam(){
    return "xxx";
   }
   classDesc(){
      return {
         groupName:"auth",
         groupDesc:"认证相关的包",
         name:"AccessAuthAPI",
         desc:"关于认证的类",
         exam:"",
     };
   }
   methodDescs(){
      return [
         {
             methodDesc:"生成访问token",
             methodName:"getAccessKey",
             paramdescs:[
                 {
                     paramDesc:"访问appkey",
                     paramName:"appkey",
                     paramType:"string",
                     defaultValue:"x",
                 },
                 {
                     paramDesc:"访问secret",
                     paramName:"secret",
                     paramType:"string",
                     defaultValue:null,
                 }
             ],
             rtnTypeDesc:"xxxx",
             rtnType:"xxx"
         }
     ];
   }
}
module.exports=LaoActionApi;

var tesk = new LaoActionApi();
var parm = {
    find_type:3,
    find_info:"高返费",
    page_size:5,
    current_page:1
 };
tesk.FindRecruitInfo(parm).then(function(result){
  console.log((result));
}).catch(function(e){
  console.log(e);
});
