/**
* 状态表
*/
'use strict'

module.exports = function (db, DataTypes) {
	return db.define('iproductprocess', {
		product_pid: { type: DataTypes.STRING, field: 'product_pid', allowNull: true, comment: '一级产品id' },
		product_id: { type: DataTypes.STRING, field: 'product_id', allowNull: true, comment: '产品ID' },
		process_id: { type: DataTypes.STRING, field: 'process_id', allowNull: true, comment: '产品ID' },
		func: { type: DataTypes.STRING, field: 'func', allowNull: false, comment: '状态执行方法名称' },
		next_status: { type: DataTypes.STRING, field: 'next_status', allowNull: true, comment: '下一个状态' },
		name1: { type: DataTypes.STRING, field: 'name1', allowNull: true, comment: '状态1' },
		name2: { type: DataTypes.STRING, field: 'name2', allowNull: true, comment: '状态2' },
		name3: { type: DataTypes.STRING, field: 'name3', allowNull: true, comment: '状态3' },
		name4: { type: DataTypes.STRING, field: 'name4', allowNull: true, comment: '状态4' },
		sort: { type: DataTypes.INTEGER, field: 'sort', allowNull: false, defaultValue: 1, comment: '排序' },
		created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
		updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
		deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true },
	},
	{
		timestamps: true,
		underscore: true,
		paranoid: true,
		version: true,
		tableName: 'i_product_process',
		comment: '发票产品流程表',
	});
}

