const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
//平台审批表   所有平台审批信息都添加到此表中  此表的状态应该和申请表的状态保持一致
module.exports = (db, DataTypes) => {

  return db.define("iinvoicedeliver", {
    invoice_id: { type: DataTypes.STRING, field: 'invoice_id', allowNull: true, comment: '发票id' },
    deliver_id: { type: DataTypes.STRING, field: 'deliver_id', allowNull: true, comment: '交付商id' },
    deliver_name: { type: DataTypes.STRING, field: 'deliver_name', allowNull: true, comment: '交付商id' },
    deliver_delive: { type: DataTypes.BIGINT, field: 'deliver_delive', allowNull: true, defaultValue:0, comment: '交付商分成' },
    deliver_mail_no: { type: DataTypes.STRING, field: 'deliver_mail_no', allowNull: true, defaultValue: "", comment: '交付商交付快递单号' },
    deliver_img: { type: DataTypes.STRING, field: 'deliver_img', allowNull: true, defaultValue: "", comment: '交接单' },
    operator_id: { type: DataTypes.STRING, field: 'operator_id', allowNull: true, defaultValue:"", comment: '交付商业务员id' },
    created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
		updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
		deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true },
    version: { type: DataTypes.INTEGER, allowNull: true, defaultValue: 0 }
  }, {
    timestamps: false,
    paranoid: true,
    tableName: 'i_invoice_deliver',
    comment: '发票交付商交付详细',
    charset: 'utf8',
    collate: 'utf8_general_ci',
    version: true
  });
}