const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
const moment = require('moment')
/**
 * 发表申请表
 */
module.exports = (db, DataTypes) => {

  return db.define("iinvoice", {
    channel_id: { type: DataTypes.STRING(32), allowNull: true, defaultValue: "", COMMENT: '渠道id' },
    invoice_type: { type: DataTypes.STRING(4), allowNull: true, comment: '发票类型 10 增值税专用发票 20 增值税普通发票 30 普通发票' },
    invoice_no: { type: DataTypes.STRING(20), allowNull: true,delaultValue:"", comment: "发票代码" },
    invoice_number: { type: DataTypes.STRING(20), allowNull: true,delaultValue:"", comment: "发票号码" },
    invoice_time: { type: DataTypes.DATE, allowNull: true, delaultValue:null,comment: "开票日期" },
    merchant_id: { type: DataTypes.STRING(32), allowNull: true, defaultValue: "", COMMENT: '购买方商户id' },
    merchant_name: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '购买方名称' },
    merchant_credit_code: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '购买方纳税人识别号' },
    merchant_addr: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '购买方地址' },
    merchant_mobile: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '购买方电话' },
    merchant_bank: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '购买方开户行' },
    merchant_account: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '银行账号' },
    businessmen_type: { type: DataTypes.STRING(4), allowNull: true, defaultValue: "", COMMENT: '销售方类型 10 个体工商户 20 自然人' },
    businessmen_id: { type: DataTypes.STRING(32), allowNull: false, COMMENT: '销售商id' },
    businessmen_credit_code: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '销售方社会统一信用代码' },
    businessmen_name: { type: DataTypes.STRING(45), allowNull: true, defaultValue: "" },
    businessmen_addr: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '销售方地址' },
    businessmen_mobile: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '销售方电话' },
    businessmen_bank: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '销售方开户行' },
    businessmen_account: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '销售方银行账号' },
    apply_no: { type: DataTypes.STRING(45), allowNull: true, defaultValue: "", COMMENT: '发票申请编号' },
    apply_time: { type: DataTypes.DATE, allowNull: true, defaultValue: null, COMMENT: '发票申请时间' },
    invoice_amount: { type: DataTypes.BIGINT, allowNull: true, defaultValue: 0, COMMENT: '价税合计总金额' },
    invoice_content: { type: DataTypes.STRING(300), allowNull: false, defaultValue: null, COMMENT: '开票内容' },
    contract: { type: DataTypes.STRING(500), allowNull: true,delaultValue:"", COMMENT: '合同' },
    personal_invoice_tax: { type: DataTypes.BIGINT, allowNull: false, defaultValue: null, COMMENT: '个税' },
    additional_tax: { type: DataTypes.BIGINT, allowNull: false, defaultValue: null, COMMENT: '附加税' },
    value_added_tax: { type: DataTypes.BIGINT, allowNull: false, defaultValue: null, COMMENT: '增值税' },
    mail_addr: { type: DataTypes.STRING(200), allowNull: true, defaultValue: null, COMMENT: '邮寄地址' },
    mail_mobile: { type: DataTypes.STRING(20), allowNull: true, defaultValue: null, COMMENT: '邮寄电话' },
    mail_to: { type: DataTypes.STRING(45), allowNull: true, defaultValue: null, COMMENT: '邮寄人' },
    statements: { type: DataTypes.STRING(45), allowNull: true, defaultValue: null, COMMENT: '结算单' },
    invoice_img: { type: DataTypes.STRING(500), allowNull: true, defaultValue: null,COMMENT:'发票图片'},
    invoice_deliver_id:{ type: DataTypes.STRING(32), allowNull: true, defaultValue: null,comment:"交付id i_invoice_deliver 表ID" },
    deliver_id:{ type: DataTypes.STRING(32), allowNull: true, defaultValue: null,comment:"交付商ID common下的交付商ID" },
    bd_id:{ type: DataTypes.STRING(32), allowNull: true, defaultValue: null ,comment:"业务员Id"},
    bd_path:{ type: DataTypes.STRING(200), allowNull: true, defaultValue: null ,comment:"业务员权限"},
    channel_id:{ type: DataTypes.STRING(32), allowNull: true ,delaultValue:'',comment:"渠道ID"},
    product_id:{ type: DataTypes.STRING(32), allowNull: true ,delaultValue:'',comment:"商品ID"},
    status: {type: DataTypes.INTEGER, field: 'status', allowNull: true,comment:'订单状态 业务进度' },
		created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
		updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
    deleted_at: { type: DataTypes.DATE, allowNull: true },
  }, {
    timestamps: false,
    paranoid: true,
    tableName: 'i_invoice',
    comment: '发票表',
    charset: 'utf8',
    collate: 'utf8_general_ci',
    version: true
  });
}