const system = require("../../../system");
const Dao = require("../../dao.base");

class IproductprocessDao extends Dao {
  constructor() {
    super(Dao.getModelName(IproductprocessDao));
  }

  /**
   * 根据 productId 和 status 查询 商品
   * @param {*} productId
   * @param {*} status
   */
  async findByProductIdAndStatus(productId, status) {
    try {
      let _productProcess = await this.model.findOne({
        where: {
          productId: productId,
          status: status
        }
      });
      return _productProcess || {};
    } catch (error) {
      console.log(`系统错误 错误信息 ${error}`);
      return {};
    }
  }

  async byProductPid(productPid) {
    let sql = [];
    sql.push("SELECT");
    sql.push("*");
    sql.push("FROM");
    sql.push(this.model.tableName)
    sql.push("WHERE product_pid = :productPid");
    sql.push("ORDER BY sort ASC");

    let list = await this.customQuery(sql.join(" "), {productPid: productPid});
    if (!list || list.length == 0) {
      return [];
    }
    return list;
  }
}

module.exports = IproductprocessDao;