const system = require("../../../system");
const Dao = require("../../dao.base");

class IproductDao extends Dao {
  constructor() {
    super(Dao.getModelName(IproductDao));
    this.tableName = this.model.tableName;
  }

  async dics(params) {
    let sql = [];
    sql.push("SELECT");
    sql.push("id, `name`, `desc`, pid");
    sql.push("FROM");
    sql.push(this.tableName);
    sql.push("WHERE 1 = 1");

    if (params.pid) {
      sql.push("AND pid = :pid");
    }
    if (params.hasOwnProperty("is_choose")) {
      sql.push("AND is_choose = :is_choose");
    }
    return this.customQuery(sql.join(" "), params);
  }

  async findListByPid(pid) {
    let sql = `SELECT * FROM ${this.tableName} WHERE pid = :pid ORDER BY sort ASC`;
    return await this.customQuery(sql, {pid: pid});
  }

  async findMapByPid(pid) {
    let result = {};
    let list = await this.findListByPid(pid);
    if (!list || list.length == 0) {
      return result;
    }

    for (var item of list) {
      result[item.id] = item;
    }
    return item.id;
  }

    /**
   * 条件查询所有符合条件的产品
   * @param {*} params 
   */
  async listByIds(ids){
    if(!ids || ids.length == 0) {
      return [];
    }
    let sql = [];
    sql.push(`SELECT * FROM ${this.tableName} WHERE id in (:productIdList)`);
    
    return await this.customQuery(sql.join(" "), {productIdList: ids});
  }

  async mapByIds(params) {
    let list = await this.listByIds(params);
    var result = {};
    for(let item of list) {
      result[item.id] = item;
    }
    return result;
  }

}
module.exports = IproductDao;