const system = require("../../../system");
const Dao = require("../../dao.base");

class IInvoiceprocessDao extends Dao {
  constructor() {
    super(Dao.getModelName(IInvoiceprocessDao));
  }

  async delByInvoiceId(invoice_id) {
    if (!invoice_id) {
      return;
    }
    let sql = `DELETE FROM ${this.model.tableName} WHERE invoice_id = :invoice_id`;
    await this.customUpdate(sql, {invoice_id: invoice_id});
  }

  async findByInvoiceIdAndStatus(invoiceId, status) {
    if (!invoiceId || !status) {
      return null;
    }
    let sql = [];
    sql.push("SELECT");
    sql.push("*");
    sql.push("FROM");
    sql.push(this.model.tableName);
    sql.push("WHERE invoice_id = :invoiceId");
    sql.push("AND `status` = :status");

    let list = await this.customQuery(sql.join(" "), {invoiceId: invoiceId, status: status});
    if (!list || list.length == 0) {
      return null;
    }
    return list[0];
  }

  async listByInvoiceIdsAndStatus(invoiceIds, statuses) {
    var result = {};
    if (!invoiceIds || invoiceIds.length == 0 || !statuses || statuses.length == 0) {
      return result;
    }
    let sql = [];
    sql.push("SELECT");
    sql.push("*");
    sql.push("FROM");
    sql.push(this.model.tableName);
    sql.push("WHERE invoice_id IN (:invoiceIds)");
    sql.push("AND `status` IN (:statuses)");

    return await this.customQuery(sql.join(" "), {invoiceIds: invoiceIds, statuses: statuses});
  }

  async mapByInvoiceIdsAndStatus(invoiceIds, statuses) {
    var result = {};
    let list = await this.listByInvoiceIdsAndStatus(invoiceIds, statuses);
    if (!list || list.length == 0) {
      return result;
    }

    for (let item of list) {
      result[item.invoice_id + "_" + item.status] = item;
    }
    return result;
  }
}

module.exports = IInvoiceprocessDao;
