var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ActionAPI extends APIBase {
    constructor() {
        super();
        this.iinvoiceSve = system.getObject("service.invoice.iinvoiceSve");
        this.iinvoicestatusSve = system.getObject("service.invoice.iinvoicestatusSve");
        this.iinvoicedeliverSve = system.getObject("service.invoice.iinvoicedeliverSve");

        this.iproductSve = system.getObject("service.product.iproductSve");
        this.iprocessSve = system.getObject("service.product.iprocessSve");
    }
    /**
     * 接口跳转
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springboard(pobj, qobj, req) {
        if (!pobj.action_process) {
            return system.getResult(null, "action_process参数不能为空");
        }
        if (!pobj.action_type) {
            return system.getResult(null, "action_type参数不能为空");
        }
        return await this.sjbOpActionProcess(pobj.action_process, pobj.action_type, pobj.action_body);
    }

    async sjbOpActionProcess(action_process, action_type, action_body) {
        var opResult = null;
        switch (action_type) {
            case "invoiceApply":         // 发票申请
                opResult = await this.iinvoiceSve.invoiceApply(action_body);
                break;
            case "invoicePage":          // 发票申请列表页（平台）
                opResult = await this.iinvoiceSve.invoicePage(action_body);
                break;
            case "deliverInvoicePage":   // 发票申请列表页（交付商）
                opResult = await this.iinvoicedeliverSve.invoicePage(action_body);
                break;
            case "handleStatus":     //进度处理
                opResult = await this.iinvoicestatusSve.handleStatus(action_body);
                break;
            case "productDics":    // 查询产品字典
                // opResult = await this.oproductSve.productDics(action_body);
                break;
            case "processDics":    // 查询业务进度
                opResult = await this.iprocessSve.allNames(action_body);
                break;
            case "invoice":    // 查询发票详细信息
                opResult = await this.iinvoiceSve.queryInvoice(action_body);
                break;
            
            // case "verificationAndCalculation":          // 发票试算接口
            //     opResult = await rule.dispatcher(action_body);
            //     break;
            // case "calculationValueAddedTax":           // 计算增值税
            //     let calValueAddedTax = new Calculation(action_body);
            //     let vaInvoice = calValueAddedTax.getInvoice();
            //     opResult = await vaInvoice.doActionValueAddedTax(action_body);
            //     break;
            // case "calculationAdditionalTax":          // 计算附加税
            //     let calAdditionalTax = new Calculation(action_body);
            //     let addinvoice = calAdditionalTax.getInvoice();
            //     opResult = await addinvoice.doActionAddtitionalTax(action_body);
            //     break;
            // case "saveInvoice":                         // 发票保存
            //     opResult = await this.applySve.apiSaveInvoice(action_body);
            //     break;
            // case "queryTxPayment":                     //查看完税证明
            //     opResult = await this.invoiceSve.apiQueryTxPayment(action_body);
            //     break;
            // case "apiCancelInvoice":                   // 发票申请单撤回
            //     opResult = await this.applySve.apiCancelInvoice(action_body);
            //     break;
            
            // case "queryApplyInvoices":                 // 发票申请列表(平台)
            //     opResult = await this.applySve.apiQueryApplyInvoices(action_body);
            //     break;
            // case "queryInvoices":                    // 发票列表(平台)
            //     opResult = await this.invoiceSve.apiQueryInvoices(action_body);
            //     break;
            // case "queryInvoice":                     // 发票明细（平台）
            //     opResult = await this.applySve.apiQueryInvoice(action_body);
            //     break;
            // case "platformAssignment":               // 平台审批
            //     opResult = await this.applySve.apiAssignment(action_body);
            //     break;
            // case "examineAndVerify":                 //审批(v2)
            //     opResult = await this.context.request(action_body);
            //     break;
            // case "updateEmail":                      //平台更新邮寄地址
            //     opResult = await this.delivererSve.apiUpEmNo(action_body);
            //     break;
            // case "queryProcess":                     // 查看业务办理(平台)
            //     opResult = await this.delivererSve.apiQueryProcess(action_body);
            //     break;
            // case "redRushInvoice":                   //红冲
            //     opResult = await this.applySve.apiRedRushInvoice(action_body);
            //     break;
            // case "redrushList":
            //     opResult = await this.invoiceSve.apiRedRushList(action_body);
            //     break;
            // case "statTransData":                    //交易数据
            //     opResult = await this.applySve.apiStatTransData(action_body);
            //     break;
            // case "statBusinessData":                 //发票办理
            //     opResult = await this.applySve.apiStatBusinessData(action_body);
            //     break;
            // case "statDeliverData":                  //交付商业务概览
            //     opResult = await this.delivererSve.apiStatDeliverData(action_body);
            //     break;
            
            // case "delivererApplyInvoices":          //发票申请列表（交付商）
            //     opResult = await this.delivererSve.apiDelivererApplyInvoices(action_body);
            //     break;
            // case "delivererInvoices":               //发票列表（交付商）
            //     opResult = await this.delivererSve.apiDelInvs(action_body);
            //     break;   
            // case "queryInvoiceDeliverer":           // 发票明细（交付商）
            //     opResult = await this.delivererSve.apiQueryInvoiceDeliverer(action_body);
            //     break;
            // case "delivererAssignment":             //交付商审批
            //     opResult = await this.delivererSve.apiAssignment(action_body);
            //     break;
            // case "txPayment":                       //完税证明更新
            //     opResult = await this.invoiceSve.apiTxPayment(action_body);
            //     break;
            // case "delStatTransData":                 //交易数据（交付商）
            //     opResult = await this.delivererSve.apiDelStatTransData(action_body);
            //     break;
            // case "delStatBusinessData":              //发票办理（交付商）
            //     opResult = await this.delivererSve.apiDelStatBusinessData(action_body);
            //     break;
            
            case "test":    // 查询业务进度
                opResult = await this.iinvoiceSve.buildProcess(action_body);
                break;

            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    exam() {
        return `<pre><pre/>`;
    }
    classDesc() {
        return {
            groupName: "op",
            groupDesc: "元数据服务包",
            name: "ActionAPI",
            desc: "此类是对外提供接口服务",
            exam: "",
        };
    }
    methodDescs() {
        return [
            {
                methodDesc: `<pre><pre/>`,
                methodName: "springboard",
                paramdescs: [
                    {
                        paramDesc: "请求的行为，传递如：sjb",
                        paramName: "action_process",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型，详情见方法中的描述",
                        paramName: "action_type",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型的参数，action_body必须传递的参数有，times_tamp（时间戳，类型int）、sign(签名,类型string)，其余的为业务需要的参数",
                        paramName: "action_body",
                        paramType: "json",
                        defaultValue: null,
                    }
                ],
                rtnTypeDesc: `<pre><pre/>`,
                rtnType: `<pre>
                {
                    "status": 0,
                    "msg": "success",
                    "data": {},
                    "requestid": "8cbd498f9d1441b1812ecaa2653933f4"
                }
            <pre/>`
            }
        ];
    }
}
module.exports = ActionAPI;