<a name="menu" href="/doc">返回主目录</a>

1. [用户获取订单列表](#GetOrderList)
1. [用户获取资质订单列表](#GetQcOrderList)
1. [用户查看订单详情](#GetOrderDetail)
1. [用户获取业务主体信息列表](#GetApplyListByUserAndType)
1. [用户获取业务主体详情](#GetApplyAndSolutionInfo)
1. [商城询价接口](#SelPrice2TX)
1. [用户获取概览数据](#GetOverviewInfoByUser)
1. [立即购买](#SubmitGoodsinfo)
1. [需求提交](#SubmitNeed)
1. [需求列表](#GetNeedList)
1. [需求详情](#GetNeedDetail)
1. [根据交付状态获取订单列表](#GetOrderListByStatus)
1. [关闭需求](#RefusalSolution)
1. [我的资质证照列表](#GetQualificationCertificateListByUserAndType)
1. [我的资质证照详情](#GetQualificationCertificateDetail)

## **<a name="GetOrderList"> 用户获取订单列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetOrderList
#### 参数说明
1、公司注册：

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| ProductType  | 是 |  string   | 产品类型  |
| RegisteredType  | 否 |  string   | 注册类型，productType为 "/ic/cpreg/"时有效 |
| CurrentPage  | 否 |  int   | 当前页，默认1  |
| PageSize  | 否 |  int   | 条数，默认10  |
| DeliveryStatus  | 否 |  int   | 订单交付状态 1: "已付款", 20: "已接单", 30: "已交付", 70: "收集材料中", 80: "递交材料中", 90: "工信部处理中", 100: "收集工商注册材料", 110: "上传注册材料", 120: "园区入驻审核", 130: "工商审核环节", 140: "刻章环节", 150: "证件邮寄环节", 160: "您已签收", 170: "已完成", 179: "即将到期", 180: "已到期", 190: "关闭交付", 200: "未申报", 210: "已申报", 310: "部分已退款", 320: "已退款", 330: "已作废" |
| CompanyProperties  | 否 |  string   | 公司性质，productType为 "/ic/gsreg/"时有效   |
| TaxpayerType  | 否 |  string   | 纳税人类型  |
| SortItem  | 否 |  string   | 排序项,不传默认按修改时间排序,payTime:购买时间，updatedAt:修改时间,endTime:到期时间  |
| SortType  | 否 |  string   | 排序方式，(asc、desc),不传默认倒序  |

#### 参数示例
``` javascript
    {
        "Action": "GetOrderList",
        "ProductType":"/ic/gsreg/",
        "DeliveryStatus":130,
        "CompanyProperties":"有限责任公司",
        "TaxpayerType":"小规模纳税人"
    }      
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": [
            {
                "OrderNum": "1111115",
                "DeliveryStatus": 130,
                "UpdatedAt": "2020-06-17T08:16:34.000Z",
                "OrderSnapshot": "{\"memoInfo\":\"11111111111111111111\",\"isWhether\":true,\"addressType\":true,\"companyName\":\"breijinhg\",\"fullAddress\":\"\",\"serviceArea\":\"北京\",\"serviceCode\":\"110100\",\"businessType\":\"公司注册\",\"contactsName\":\"111111\",\"taxpayerType\":\"小规模纳税人\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"contactsPhone\":\"18738988150\",\"engagedIndustry\":\"文化传媒类\",\"companyProperties\":\"有限责任公司\"}"
            }
        ],
        "DataCount": 1,
        "RequestId": "7364f560-b29c-11ea-97f7-efd638e57201"
    }
}

```

## **<a name="GetQcOrderList"> 用户获取资质订单列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetQcOrderList
#### 参数说明
1、公司注册：

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| PoductType  | 否 |  string   | 产品类型  |
| CompanyName  | 否 |  string   | 公司名称  |
| CurrentPage  | 否 |  int   | 当前页，默认1  |
| PageSize  | 否 |  int   | 条数，默认10  |
| DeliveryStatus  | 否 |  int   | 订单交付状态 1: "已付款", 20: "已接单", 30: "已交付", 70: "收集材料中", 80: "递交材料中", 90: "工信部处理中", 100: "收集工商注册材料", 110: "上传注册材料", 120: "园区入驻审核", 130: "工商审核环节", 140: "刻章环节", 150: "证件邮寄环节", 160: "您已签收", 170: "已完成", 179: "即将到期", 180: "已到期", 190: "关闭交付", 200: "未申报", 210: "已申报", 310: "部分已退款", 320: "已退款", 330: "已作废" |
| SortItem  | 否 |  string   | 排序项,不传默认按修改时间排序,payTime:购买时间，updatedAt:修改时间,endTime:到期时间  |
| SortType  | 否 |  string   | 排序方式，(asc、desc),不传默认倒序  |

#### 参数示例
``` javascript
    {
        "Action": "GetQcOrderList",
        "PageSize":2,
        "CurrentPage":1,
        "ProductType":"/qcfw/icp/",
        "CompanyName":"公司宝",
        "DeliveryStatus":170,
        "SortType":"asc"
    }        
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": [
            {
                "ProductType": "/qcfw/icp/",
                "OrderNum": "O202006130014",
                "DeliveryStatus": 170,
                "UpdatedAt": "2020-06-16T01:44:27.000Z",
                "OrderSnapshot": "{\"memoInfo\":\"11111111111111111111\",\"isWhether\":true,\"addressType\":true,\"companyName\":\"breijinhg\",\"fullAddress\":\"\",\"serviceArea\":\"北京\",\"serviceCode\":\"110100\",\"businessType\":\"公司注册\",\"contactsName\":\"111111\",\"taxpayerType\":\"小规模纳税人\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"contactsPhone\":\"18738988150\",\"engagedIndustry\":\"文化传媒类\",\"companyProperties\":\"有限责任公司\"}",
                "DeliverContent": "{\"clerkName\":\"小三\",\"clerkPhone\":\"4567800\",\"safetyInfo\":{\"qualification\":\"咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩\",\"responsibility\":\"咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩\"},\"proposerInfo\":{\"contactInfo\":{\"name\":\"123\",\"email\":\"www@qq.com\",\"phone\":\"17292865373\",\"address\":\" 北京市海淀区北清路164号17-27号院813号 \"},\"principalInfo\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_326515921836585432020159141854347245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"123\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"法定代表人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_297515921836625302020159142253047245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"234\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"客服负责人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_18451592183667032202015914273247245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"456\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"安全负责人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_13951592183671026202015914312647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"789\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"许可证负责人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"}],\"recipientInfo\":{\"name\":\"123\",\"email\":\"www@qq.com\",\"phone\":\"17292865373\",\"address\":\" 北京市海淀区北清路164号17-27号院813号 \"},\"businessLicense\":{\"name\":\"公司宝\",\"type\":\"有限责任公司(法人独资)\",\"address\":\"北京市海淀区北清路164号17-27号院813号\",\"createdAt\":\"2014-02-25\",\"businessTerm\":\"2014-08-07 至 2034-08-06\",\"scopeBusiness\":\"技术开发、技术推广、技术转让、技术咨询、技术服务；计算机系统服务；数据处理(数据处理中的银行卡中心、PUE值在1.5以上的云计算数据中心除外)；基础软件服务；应用软件服务；软件开发；软件咨询；产品设计；模型设计；包装装潢设计；教育咨询；经济贸易咨询；文化咨询；体育咨询；公共关系服务；会议服务；工艺美术设计；电脑动画设计；企业策划；设计、制作、代理、发布广告；市场调查；企业管理咨询；组织文化艺术交流活动(不含营业性演出)；文艺创作；承办展览展示活动；影视策划；翻译服务；商标转让；商标代理；版权转让、版权代理；财务咨询(不得开展审计、验资、查帐、评估、会计咨询、代理记账等需经专项审批的业务,不得出具相应的审计报告、验资报告、查帐报告、评估报告等文字材料)；销售自行开发后的产品、机械设备、计算机、软件及辅助设备、通讯设备、电子产品、日用品、文化用品、工艺品；出租办公用房；机动车公共停车场服务；物业管理；健康咨询（须经审批的诊疗活动除外）；代理记账；人力资源服务。（企业依法自主选择经营项目，开展经营活动；代理记账、人力资源服务以及依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。）\",\"enterpriseCode\":\"911101083066224948\",\"registeredCapital\":1000000,\"legalRepresentative\":\"李丽\"},\"businessInformation\":{\"address\":\"北京市海淀区北清路164号17-27号院813号\",\"zipCode\":\"www@qq.com\",\"ifListed\":\"false\",\"staffSize\":\"大于等于100人，且小于300人\",\"legalTypes\":\"企业法人\",\"businessScale\":\"年收入亿万级\",\"comapnyNature\":\"民营控股\",\"fixedTelephone\":\" 010-849*\",\"bussinessDirection\":\"公共管理、社会和保障和社会组织\"}},\"servicerCode\":\"1\",\"servicerName\":\"公司宝\",\"qualification\":{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_422515919726637762020122237437769592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\",\"name\":\"9592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\"},\"endAt\":\"2020-06-23 08:00:00\",\"startAt\":\"2020-06-09 08:00:00\",\"businessScope\":\"d\",\"businessTypes\":\"d\",\"serviceProject\":\"d\",\"certificateNumber\":\"d\"},\"recipientInfo\":{\"name\":\"lll\",\"email\":\"dfgfdgdf@qq.com\",\"phone\":\"17293892382\",\"address\":\"dfsfdsfs\",\"courierNumber\":\"lll\",\"logisticsCompany\":\"ffff\"},\"shareholderData\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_53515921850353862020159371538647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"123\",\"type\":\"境内机自然人\",\"address\":\"北京\",\"idNumber\":\"1983729277829375339\",\"companyCode\":\"282938485993\",\"currencyType\":\"人民币\",\"declareCompany\":\"汉唐\",\"holdProportion\":20,\"waysInvestment\":\"货币\",\"investmentAmount\":100,\"superiorIdNumber\":\"183749273840\",\"superiorShareholder\":\"123\"}],\"otherMaterialsInfo\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_6515921851356352020159385563547245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"营业执照\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_47951592185140207202015939020747245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"域名证书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_851592185147298202015939729847245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"申请者国家企业信用信息公示系统截图\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_152515921851514492020159391144947245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"股东追溯承诺书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_192515921851557422020159391574247245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"依法经营电信业务承诺书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_485515921851603502020159392035047245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"服务器托管协议\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_221515921851644682020159392446847245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"服务器托管商编号C证书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_488515921851693262020159392932647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"社保证明文件\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_396515921851741332020159393413347245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"收费方案\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_378515921851822812020159394228147245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"fixed\":false,\"title\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3\"}],\"implementationPlanInfo\":{\"webApp\":[{\"name\":\"快快快\",\"type\":\"网站\",\"domain\":\"kk.com\",\"appStoreName\":\"坎坎坷坷扩\",\"serverAddress\":\"坎坎坷坷\"}],\"targetUser\":[\"个人\"],\"profitableWay\":[\"混合收费\"],\"specialApproval\":[{\"file\":{},\"title\":\"新闻\"},{\"file\":{},\"title\":\"出版\"},{\"file\":{},\"title\":\"药品和医疗器材\"},{\"file\":{},\"title\":\"文化\"},{\"file\":{},\"title\":\"视听节目\"}],\"serviceProjectEdi\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_339515921853173562020159415735647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"电子交换业务\",\"value\":[\"贸易事务数据结构化/自动处理和交换服务\",\"行政事务数据结构化/自动处理和交换服务\"]},{\"file\":{},\"title\":\"交易处理业务\",\"value\":[\"BTO C第三方交易平台\"]},{\"title\":\"网络/电子设备数据处理业\",\"value\":[\"物联网应用平台服务\"]}],\"serviceProjectIcp\":[{\"title\":\"信息发布平台和递送服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息搜索查询服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息社区服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息及时交互服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息保护加工处理服务\",\"value\":[],\"otherValue\":\"\"}]}}"
            }
        ],
        "DataCount": 1,
        "RequestId": "8fee8fc0-b29c-11ea-97f7-efd638e57201"
    }
}

```

## **<a name="GetOrderDetail"> 用户查看订单详情</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetOrderDetail
#### 参数说明
1、公司注册：

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| OrderNum  | 是 |  string   | 订单号  |

#### 参数示例
``` javascript
    {
        "Action": "GetOrderDetail",
        "OrderNum":"1111115"
    }       
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "OrderNum": "1111115",
            "TxOrdersNum": "1111115",
            "NeedNum": "202006100012",
            "UserName": "张三",
            "Quantity": 1,
            "TotalSum": 300,
            "DiscountAmount": 0,
            "PayTotalSum": 300,
            "RefundSum": 0,
            "PayTime": null,
            "OrderStatus": 1,
            "Notes": "第一单",
            "CreatedAt": "2020-06-03T10:17:28.000Z",
            "UpdatedAt": null,
            "OrderDeliveryInfo": "{\"deliver_content\":{\"agent\":\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) snap Chromium/83.0.4103.61 Chrome/83.0.4103.61 Safari/537.36\",\"userid\":\"13\",\"bizpath\":\"/deliverManage/cmpBizDeliverCase\",\"baseInfo\":{\"isVirtual\":\"否\",\"isWhether\":\"是\",\"payStatus\":\"已交付\",\"contactsName\":\"wangyongfei1122\",\"contactsPhone\":\"23456789\"},\"clientIp\":\"192.168.1.199\",\"username\":\"wangyongfei\",\"classname\":\"bizchance.deliverybillCtl\",\"company_id\":\"11\",\"companyInfo\":{\"spareName\":[\"兴业1\",\"兴业2\",\"兴业3\"],\"spareName1\":\"兴业1\",\"spareNames\":[{\"value\":\"兴业2\",\"status\":1},{\"value\":\"兴业3\",\"status\":1}],\"addressType\":\"practical\",\"companyName\":\"兴业有限公司\",\"fullAddress\":\"发发地方\",\"serviceArea\":\"shanghai\",\"taxpayerType\":\"generalTaxpayer\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示；舞台美术、工艺美术品、包装装璜设计、制作。\",\"registeredDate\":\"2020-06-16\",\"engagedIndustry\":\"culturalMedia\",\"operatingPeriod\":\"发到付\",\"companyProperties\":\"limitedLiabilityCompany\",\"registeredCapital\":80,\"reserveProportion\":79},\"deliverInfo\":{\"isVirtual\":\"否\",\"isWhether\":\"是\",\"payStatus\":\"已交付\",\"contactsName\":\"张三\",\"contactsPhone\":\"13800138000\"},\"contactsInfo\":{\"contactsName\":\"wangyongfei1122\",\"contactsPhone\":\"23456789\"},\"positionInfo\":{\"positionData\":[{\"fixedPhone\":\"2345678\",\"mailboxInfo\":\"2839273\",\"mobilePhone\":\"45678\",\"persionName\":\"附近的酸辣粉\",\"functionInfo\":\"发链接\",\"houseAddress\":\"的激发了肯德基\"}]},\"deliverNumber\":\"1111115\",\"registeredInfo\":{\"registeredDate\":\"2020-06-16\",\"registeredCapital\":80,\"reserveProportion\":79},\"contributionInfo\":{\"contributionData\":[{\"phoneNumber\":\"1234567\",\"contactAddress\":\"房间爱老师肯定放假啦\",\"hareholderName\":\"兴业\",\"contributionAmount\":\"80\",\"IdentificationNumber\":\"2345678\",\"contributionProportion\":\"10\"}]}},\"created_at\":\"2020-06-12T16:19:53.000Z\",\"updated_at\":\"2020-06-17T08:16:34.000Z\",\"delivery_status\":130,\"delivery_status_name\":\"工商审核环节\"}",
            "OrderProductInfo": "{\"time_span\":null,\"time_unit\":null,\"end_time\":null}"
        },
        "RequestId": "16c9d3d0-b43a-11ea-9bcc-11a1d3415630"
    }
}

```


## **<a name="GetApplyListByUserAndType"> 用户获取业务主体信息列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetApplyListByUserAndType
#### 参数说明
1、公司注册：

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| ApplyType  | 是 |  int   | 申请实体类型，1：企业 2：个体户  |
| CurrentPage  | 否 |  int   | 当前页，默认1  |
| PageSize  | 否 |  int   | 条数，默认10  |
| ApplyName  | 否 |  string   | 公司/个体户名称  |
| Domicile  | 否 |  string   | 住所  |

#### 参数示例
``` javascript
   {
        "Action": "GetApplyListByUserAndType",
        "ApplyType":"1",
        "CurrentPage":0,
        "PageSize":10,
        "ApplyName":"",
        "Domicile":""
    }          
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": [
            {
                "ApplyName": "公司名詞",
                "CreditCode": "1234349555556",
                "ApplyType": 1,
                "Operator": "",
                "RegistCapital": "100萬",
                "BusinessTerm": "200",
                "EstablishTime": "2009年",
                "Domicile": "北京市"
            }
        ],
        "DataCount": 1,
        "RequestId": "cf36d160-b29c-11ea-97f7-efd638e57201"
    }
}

```

## **<a name="GetApplyAndSolutionInfo"> 用户获取业务主体详情</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetApplyAndSolutionInfo
#### 参数说明

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| CreditCode  | 是 |  string   | 社会统一信用代码  |


#### 参数示例
``` javascript
   {
        "Action": "GetApplyAndSolutionInfo",
        "CreditCode":"1234349555556"
    }           
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "ApplyInfo": "{\"user_id\":\"1\",\"apply_name\":\"公司名詞\",\"credit_code\":\"1234349555556\",\"apply_type\":1,\"operator\":\"\",\"regist_capital\":\"100萬\",\"business_term\":\"200\",\"establish_time\":\"2009年\",\"domicile\":\"北京市\",\"ent_type\":\"有限責任公司\",\"business_scope\":\"歲的哥哥和繪畫\"}",
            "ProductList": "[{\"order_num\":\"1111113\",\"product_type_name\":\"/工商服务/代理记账/\",\"product_type\":\"/ic/dljz/\",\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":\"2020-06-19T08:07:18.000Z\",\"order_snapshot\":{\"contactsName\":\"123\"}},{\"order_num\":\"1111114\",\"product_type_name\":\"/工商服务/注册地址/\",\"product_type\":\"/ic/regaddr/\",\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":{\"memoInfo\":\"11111111111111111111\",\"isWhether\":true,\"addressType\":true,\"companyName\":\"breijinhg\",\"fullAddress\":\"\",\"serviceArea\":\"北京\",\"serviceCode\":\"110100\",\"businessType\":\"公司注册\",\"contactsName\":\"111111\",\"taxpayerType\":\"小规模纳税人\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"contactsPhone\":\"18738988150\",\"engagedIndustry\":\"文化传媒类\",\"companyProperties\":\"有限责任公司\"}},{\"order_num\":\"1111117\",\"product_type_name\":\"/工商服务/工商年报/\",\"product_type\":\"/ic/gsnb/\",\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":{\"memoInfo\":\"11111111111111111111\",\"isWhether\":true,\"addressType\":true,\"companyName\":\"breijinhg\",\"fullAddress\":\"\",\"serviceArea\":\"北京\",\"serviceCode\":\"110100\",\"businessType\":\"公司注册\",\"contactsName\":\"111111\",\"taxpayerType\":\"小规模纳税人\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"contactsPhone\":\"18738988150\",\"engagedIndustry\":\"文化传媒类\",\"companyProperties\":\"有限责任公司\"}},{\"order_num\":\"1111118\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null},{\"order_num\":\"1111119\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null},{\"order_num\":\"1111120\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null},{\"order_num\":\"1111121\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null},{\"order_num\":\"1111122\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null},{\"order_num\":\"1111123\",\"product_type_name\":null,\"product_type\":null,\"delivery_status\":1,\"delivery_status_name\":\"已付款\",\"updated_at\":null,\"order_snapshot\":null}]"
        },
        "RequestId": "f437a070-b29c-11ea-97f7-efd638e57201"
    }
}

```

## **<a name="GetOverviewInfoByUser"> 用户获取概览数据</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetApplyAndSolutionInfo
#### 参数说明
1、公司注册：

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| ProductTypeOne  | 是 |  string   | 产品大类编码 ic:工商服务 qcfw:资质证照  |


#### 参数示例
``` javascript
   {
        "Action": "GetOverviewInfoByUser",
        "ProductTypeOne":"qcfw"
    }              
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "IcpCount": 1,
            "WaitConfirmCount": 0,
            "EdiCount": 1,
            "WaitReceiveFileOrderCount": 0
        },
        "RequestId": "12bbd250-b29d-11ea-97f7-efd638e57201"
    }
}
```

## **<a name="SelPrice2TX"> 商城询价接口</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：SelPrice2TX
#### 参数说明
1、公司注册： /ic/gsreg/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| CompanyProperties  | 是 |  string   | 公司类型  |

2.云上公司注册  /ic/cpreg/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| RegisteredType  | 是 |  string   | 注册类型  |

3.刻章服务  /ic/kzfw/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| WhetherType  | 是 |  string   | 刻章类型  |

<!-- 4.银行开户  /ic/bankopen/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| userId  | 是 |  string   | 用户id  |
| regionId  | 是 |  string   | 地区代码  |
| regionName  | 是 |  string   | 地区拼音  |
| pathCode  | 是 |  string   | 产品类型  | -->

4.工商变更  /ic/gschangs/

  税控申请  /ic/sksq/

  社保开户   /ic/sbopen/

  银行开户   /ic/bankopen/

  税控申请   /ic/sksq/ 

  税务报道   /ic/swbd/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |


6.icp  /qcfw/icp/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| Period  | 是 |  string   | 办理周期  |

7.edi  /qcfw/edi/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |
| Period  | 是 |  string   | 办理周期  |

8.icp年报  /qcfw/icpannals/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |

9.edi年报  /qcfw/ediannals/

|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| RegionId  | 是 |  string   | 地区代码  |
| RegionName  | 是 |  string   | 地区拼音  |
| PathCode  | 是 |  string   | 产品类型  |




#### 参数示例
``` javascript
   {
        "Action": "SelPrice2TX",
        "RegionId":"1",
        "PathCode":"/ic/gsreg/",
        "WhetherType":"公司章",
        "RegionName":"shanghai"
        
    }         
```

#### 返回结果
```javascript
    {
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "TotalCost": 58000,
            "RealTotalCost": 37700,
            "Product": "{\"productIcon\":null,\"productType\":\"/ic/kzfw/\",\"productTypeName\":\"/工商服务/刻章服务/\",\"servicerCode\":null,\"servicerName\":null}",
            "ProductSnapshot": "{\"timeSpan\":\"1\",\"timeUnit\":\"p\",\"pid\":\"1003952\",\"productCode\":\"p_business_registration\",\"goodsSubType\":\"sp_business_registration_chapter\",\"subProductCode\":\"sp_business_registration_chapter\",\"qifuzidingyi\":\"shanghai\",\"sv_business_registration_type_fivechapter\":\"1\"}"
        },
        "RequestId": "c994bb40-b2d4-11ea-b81b-89b08281dc19"
    }
}
```

## **<a name="SubmitGoodsinfo"> 立即购买</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：SubmitGoodsinfo
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| VerificationCode  | 否 |  string   | 验证码  |
| Info  | 是 |  string   | 产品信息  支持多个产品提交 数组格式 |
| Info[0].productSnapshot  | 是 |  string   | tx产品快照 |
| Info[0].product  | 是 |  string   | 产品快照 |
| Info[0].showInfo  | 是 |  string   | 核对页展示信息 |
| Info[0].formInfo  | 是 |  string   | 表单信息 |
| Info[0].formInfo.Email  | 否 |  string   | 邮箱  |
| Info[0].formInfo.WechatNo  | 否 |  string   | 微信号  |



#### 参数示例
``` javascript
   {
	"Action": "SubmitGoodsinfo",
    "VerificationCode": "564264",
    "Info":"[{\"product\":{\"productIcon\":null,\"productType\":\"/ic/kzfw/\",\"productTypeName\":\"/工商服务/刻章服务/\",\"servicerCode\":\"测试服务商\"},\"productSnapshot\":{\"timeSpan\":\"1\",\"timeUnit\":\"p\",\"pid\":1003952,\"productCode\":\"p_business_registration\",\"goodsSubType\":\"sp_business_registration_chapter\",\"subProductCode\":\"sp_business_registration_chapter\",\"qifuzidingyi\":\"beijing\",\"sv_business_registration_type_fivechapter\":\"1\"},\"showInfo\":[{\"name\":\"公司名称\",\"value\":\"公司宝\"},{\"name\":\"公司名称\",\"value\":\"公司宝\"}],\"formInfo\":{}}]"
	
}
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "Url": "https://buy.cloud.tencent.com/order/check",
            "Param": "{\"itemDetails\":{\"raw_goodsData\":[{\"goodsCategoryId\":100114,\"regionId\":1,\"projectId\":0,\"zoneId\":100001,\"goodsNum\":1,\"payMode\":1,\"goodsDetail\":{\"timeSpan\":\"1\",\"timeUnit\":\"p\",\"pid\":1003952,\"productCode\":\"p_business_registration\",\"goodsSubType\":\"sp_business_registration_chapter\",\"subProductCode\":\"sp_business_registration_chapter\",\"qifuzidingyi\":\"beijing\",\"sv_business_registration_type_fivechapter\":\"1\",\"product\":{\"productIcon\":null,\"productType\":\"/ic/kzfw/\",\"productTypeName\":\"/工商服务/刻章服务/\",\"servicerCode\":\"测试服务商\"},\"productInfo\":[{\"name\":\"公司名称\",\"value\":\"公司宝\"},{\"name\":\"公司名称\",\"value\":\"公司宝\"}],\"formInfo\":{}}}]}}"
        },
        "RequestId": "a4f61720-b2d9-11ea-bcc3-65805920fb58"
    }
}
```

## **<a name="SubmitNeed"> 创建需求</a>**
[返回到目录](#menu)
##### URL
[/api/action/need/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：SubmitNeed
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserName  | 是 |  string   | 用户名称  |
| ContactsMoblie  | 是 |  string   | 联系人电话  |
| ContactsName  | 否 |  string   | 联系人名称  |
| RegionId  | 是 |  string   | 地区id  |
| RegionName  | 是 |  string   | 地区名称  |
| VerificationCode  | 是 |  string   | 验证码  |
| Notes  | 否 |  string   | 备注  |
| ConsultType  | 是 |  string   | 产品类型  |
| ConsultTypeName  | 是 |  string   | 产品类型名称  |
| CompanyName  | 否 |  string   | 公司名称  |
| CompanyName  | 否 |  string   | 公司名称  |
| Email  | 否 |  string   | 邮箱  |
| WechatNo  | 否 |  string   | 微信号  |



#### 参数示例
``` javascript
   {
        "Action": "SubmitNeed",
        "UserName": "011",
        "ContactsMoblie":"17610163852",
        "ContactsName":"wdy",
        "RegionId":"110100",
        "RegionName":"北京",
        "ConsultType":"/ic/gsreg/",
        "ConsultTypeName":"/工商服务/公司注册/",
    }           
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": "",
        "RequestId": "ee2b7450-b2c8-11ea-8e5e-ed12303f5d17"
    }
}
```

## **<a name="GetNeedList"> 需求列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/need/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetNeedList
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| PageNo  | 否 |  string   | 页码  |
| PageSize  | 否 |  string   | 页面大小  |
| Status  | 否 |  string   | 状态  |
| ConsultType  | 是 |  string   | 需求类型  |
| Sort  | 否 |  string   | 排序  |
| Sort.key  | 是 |  string   | 字段名称  |
| Sort.value  | 是 |  string   | 排序方式  desc  asc  |


#### 参数示例
``` javascript
   {
        "Action": "GetNeedList",
        "UserId": "011",
        "PageNo":"1",
        "PageSize":"10",
        "Status":"1",
        "RegionName":"北京",
        "ConsultType":"/ic/",
        "Sort":"{\"key\":\"created_at\",\"value\":\"desc\"}"
        
    }            
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "Count": 8,
            "Rows": "[{\"id\":103,\"need_num\":\"N202006201537aL6MrDE\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"wdy\",\"contacts_moblie\":\"17610163852\",\"region_id\":\"320100\",\"region_name\":\"南京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"svlhusghsjhvseiluhuvuivfhi\",\"need_info\":null,\"servicer_code\":\"GSB\",\"servicer_name\":null,\"created_at\":\"2020-06-20T07:37:44.000Z\",\"updated_at\":\"2020-06-20T07:37:44.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":102,\"need_num\":\"N202006201142FJdqXPC\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"wdy\",\"contacts_moblie\":\"17610163852\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"svlhusghsjhvseiluhuvuivfhi\",\"need_info\":null,\"servicer_code\":\"S_202006201007FI8tuF\",\"servicer_name\":\"网易云\",\"created_at\":\"2020-06-20T03:42:37.000Z\",\"updated_at\":\"2020-06-20T03:42:37.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":100,\"need_num\":\"N202006201129Qba19e2\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"wdy\",\"contacts_moblie\":\"17610163852\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"svlhusghsjhvseiluhuvuivfhi\",\"need_info\":null,\"servicer_code\":\"S_202006201007FI8tuF\",\"servicer_name\":\"网易云\",\"created_at\":\"2020-06-20T03:29:33.000Z\",\"updated_at\":\"2020-06-20T03:29:33.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":67,\"need_num\":\"N202006161642ODMRsRW\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"\",\"contacts_moblie\":\"18735397229\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"\",\"need_info\":null,\"servicer_code\":\"gsb\",\"servicer_name\":null,\"created_at\":\"2020-06-16T08:42:14.000Z\",\"updated_at\":\"2020-06-16T08:42:14.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":68,\"need_num\":\"N202006161642nBRBToJ\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"\",\"contacts_moblie\":\"18735397229\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"\",\"need_info\":null,\"servicer_code\":\"gsb\",\"servicer_name\":null,\"created_at\":\"2020-06-16T08:42:14.000Z\",\"updated_at\":\"2020-06-16T08:42:14.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":69,\"need_num\":\"N202006161642dtAo81x\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"\",\"contacts_moblie\":\"18735397229\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"\",\"need_info\":null,\"servicer_code\":\"gsb\",\"servicer_name\":null,\"created_at\":\"2020-06-16T08:42:14.000Z\",\"updated_at\":\"2020-06-16T08:42:14.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":70,\"need_num\":\"N202006161642AjjLIsr\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"\",\"contacts_moblie\":\"18735397229\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"\",\"need_info\":null,\"servicer_code\":\"gsb\",\"servicer_name\":null,\"created_at\":\"2020-06-16T08:42:14.000Z\",\"updated_at\":\"2020-06-16T08:42:14.000Z\",\"deleted_at\":null,\"version\":0},{\"id\":61,\"need_num\":\"N202006141134GQ7HV3a\",\"user_id\":\"011\",\"user_name\":null,\"contacts_name\":\"北京\",\"contacts_moblie\":\"18262855372\",\"region_id\":\"110100\",\"region_name\":\"北京\",\"consult_type\":\"/ic/gsreg/\",\"consult_type_name\":\"/工商服务/公司注册/\",\"status\":1,\"status_name\":\"已提交\",\"notes\":\"00000000000000000\",\"need_info\":null,\"servicer_code\":\"S_202006051002UE4Lse\",\"servicer_name\":\"测试服务商\",\"created_at\":\"2020-06-14T03:34:50.000Z\",\"updated_at\":\"2020-06-14T03:34:50.000Z\",\"deleted_at\":null,\"version\":0}]"
        },
        "RequestId": "af0cf310-b2ce-11ea-9dd5-03e6b499c7e6"
    }
}
```

## **<a name="GetNeedDetail"> 需求详情</a>**
[返回到目录](#menu)
##### URL
[/api/action/need/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetNeedDetail
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| NeedNum  | 是 |  string   | 需求号  |


#### 参数示例
``` javascript
   {
        "Action": "GetNeedDetail",
        "NeedNum": "202006100003"
    }           
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "NeedInfo": "{\"id\":20,\"need_num\":\"N202006130012\",\"user_id\":\"1\",\"user_name\":\"张三\",\"contacts_name\":\"张三\",\"contacts_moblie\":\"13075556693\",\"region_id\":\"1\",\"region_name\":\"北京\",\"consult_type\":\"/qcfw/icp/\",\"consult_type_name\":\"/资质证照/icp/\",\"status\":2,\"status_name\":\"待用户确认\",\"notes\":\"测试数据勿删\",\"need_info\":null,\"servicer_code\":\"gsb\",\"servicer_name\":\"公司宝\",\"created_at\":\"2020-06-03T16:04:45.000Z\",\"updated_at\":\"2020-06-20T08:58:06.000Z\",\"deleted_at\":null,\"version\":null}",
            "SolutionInfo": "{\"id\":17,\"need_num\":\"N202006130012\",\"solution_num\":\"NS_202006130920sregN\",\"user_id\":\"1\",\"user_name\":\"张三\",\"solution_content\":{\"id\":26,\"bizopt_id\":32,\"clerkName\":\"小三\",\"clerkPhone\":\"4567800\",\"updated_at\":\"2020-06-02 20:32:14\",\"remark_info\":\"77777777777777777777777\",\"scheme_info\":{\"address\":\"hangzhou\",\"company\":\"77777777777777\",\"annual_report\":true},\"businessType\":\"/qcfw/icp/\",\"servicerCode\":\"1\",\"servicerName\":\"公司宝\",\"salesman_name\":\"小三\",\"facilitator_id\":\"test\",\"salesman_phone\":\"199299949424\",\"refusal_content\":\"\",\"facilitator_name\":\"测试服务商\"},\"is_refusal\":1,\"refusal_notes\":\"测试修改方案\",\"created_at\":\"2020-06-13T01:20:30.000Z\",\"deleted_at\":null,\"version\":0}"
        },
        "RequestId": "626a5c90-b2d4-11ea-b81b-89b08281dc19"
    }
}
```

## **<a name="GetOrderListByStatus"> 根据交付状态获取订单列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetOrderListByStatus
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| Status  | 是 |  string   | 状态码，"150":"证件邮寄环节"  |


#### 参数示例
``` javascript
  {
        "Action": "GetOrderListByStatus",
         "Status":150
    }             
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": [
            {
                "OrderNum": "O202006130014",
                "TxOrdersNum": "O202006130014",
                "UserName": "张三",
                "UserId": "1",
                "UpdatedAt": "2020-06-16T01:44:27.000Z",
                "TotalSum": 300,
                "RefundSum": 0,
                "PayTime": null,
                "DeletedAt": null,
                "ServicerCode": "gsb",
                "ServicerName": "公司宝",
                "ProductType": "/qcfw/icp/",
                "ProductTypeName": "/资质证照/icp/",
                "OrderSnapshot": "{\"memoInfo\":\"11111111111111111111\",\"isWhether\":true,\"addressType\":true,\"companyName\":\"breijinhg\",\"fullAddress\":\"\",\"serviceArea\":\"北京\",\"serviceCode\":\"110100\",\"businessType\":\"公司注册\",\"contactsName\":\"111111\",\"taxpayerType\":\"小规模纳税人\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"contactsPhone\":\"18738988150\",\"engagedIndustry\":\"文化传媒类\",\"companyProperties\":\"有限责任公司\"}",
                "EndTime": null,
                "RegionId": "8",
                "RegionName": "北京",
                "DeliveryStatus": 170,
                "DeliveryStatusName": "已完成",
                "DeliverContent": "{\"clerkName\":\"小三\",\"clerkPhone\":\"4567800\",\"safetyInfo\":{\"qualification\":\"咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩\",\"responsibility\":\"咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩\"},\"proposerInfo\":{\"contactInfo\":{\"name\":\"123\",\"email\":\"www@qq.com\",\"phone\":\"17292865373\",\"address\":\" 北京市海淀区北清路164号17-27号院813号 \"},\"principalInfo\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_326515921836585432020159141854347245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"123\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"法定代表人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_297515921836625302020159142253047245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"234\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"客服负责人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_18451592183667032202015914273247245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"456\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"安全负责人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_13951592183671026202015914312647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"789\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"许可证负责人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"}],\"recipientInfo\":{\"name\":\"123\",\"email\":\"www@qq.com\",\"phone\":\"17292865373\",\"address\":\" 北京市海淀区北清路164号17-27号院813号 \"},\"businessLicense\":{\"name\":\"公司宝\",\"type\":\"有限责任公司(法人独资)\",\"address\":\"北京市海淀区北清路164号17-27号院813号\",\"createdAt\":\"2014-02-25\",\"businessTerm\":\"2014-08-07 至 2034-08-06\",\"scopeBusiness\":\"技术开发、技术推广、技术转让、技术咨询、技术服务；计算机系统服务；数据处理(数据处理中的银行卡中心、PUE值在1.5以上的云计算数据中心除外)；基础软件服务；应用软件服务；软件开发；软件咨询；产品设计；模型设计；包装装潢设计；教育咨询；经济贸易咨询；文化咨询；体育咨询；公共关系服务；会议服务；工艺美术设计；电脑动画设计；企业策划；设计、制作、代理、发布广告；市场调查；企业管理咨询；组织文化艺术交流活动(不含营业性演出)；文艺创作；承办展览展示活动；影视策划；翻译服务；商标转让；商标代理；版权转让、版权代理；财务咨询(不得开展审计、验资、查帐、评估、会计咨询、代理记账等需经专项审批的业务,不得出具相应的审计报告、验资报告、查帐报告、评估报告等文字材料)；销售自行开发后的产品、机械设备、计算机、软件及辅助设备、通讯设备、电子产品、日用品、文化用品、工艺品；出租办公用房；机动车公共停车场服务；物业管理；健康咨询（须经审批的诊疗活动除外）；代理记账；人力资源服务。（企业依法自主选择经营项目，开展经营活动；代理记账、人力资源服务以及依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。）\",\"enterpriseCode\":\"911101083066224948\",\"registeredCapital\":1000000,\"legalRepresentative\":\"李丽\"},\"businessInformation\":{\"address\":\"北京市海淀区北清路164号17-27号院813号\",\"zipCode\":\"www@qq.com\",\"ifListed\":\"false\",\"staffSize\":\"大于等于100人，且小于300人\",\"legalTypes\":\"企业法人\",\"businessScale\":\"年收入亿万级\",\"comapnyNature\":\"民营控股\",\"fixedTelephone\":\" 010-849*\",\"bussinessDirection\":\"公共管理、社会和保障和社会组织\"}},\"servicerCode\":\"1\",\"servicerName\":\"公司宝\",\"qualification\":{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_422515919726637762020122237437769592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\",\"name\":\"9592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\"},\"endAt\":\"2020-06-23 08:00:00\",\"startAt\":\"2020-06-09 08:00:00\",\"businessScope\":\"d\",\"businessTypes\":\"d\",\"serviceProject\":\"d\",\"certificateNumber\":\"d\"},\"recipientInfo\":{\"name\":\"lll\",\"email\":\"dfgfdgdf@qq.com\",\"phone\":\"17293892382\",\"address\":\"dfsfdsfs\",\"courierNumber\":\"lll\",\"logisticsCompany\":\"ffff\"},\"shareholderData\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_53515921850353862020159371538647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"123\",\"type\":\"境内机自然人\",\"address\":\"北京\",\"idNumber\":\"1983729277829375339\",\"companyCode\":\"282938485993\",\"currencyType\":\"人民币\",\"declareCompany\":\"汉唐\",\"holdProportion\":20,\"waysInvestment\":\"货币\",\"investmentAmount\":100,\"superiorIdNumber\":\"183749273840\",\"superiorShareholder\":\"123\"}],\"otherMaterialsInfo\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_6515921851356352020159385563547245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"营业执照\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_47951592185140207202015939020747245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"域名证书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_851592185147298202015939729847245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"申请者国家企业信用信息公示系统截图\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_152515921851514492020159391144947245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"股东追溯承诺书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_192515921851557422020159391574247245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"依法经营电信业务承诺书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_485515921851603502020159392035047245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"服务器托管协议\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_221515921851644682020159392446847245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"服务器托管商编号C证书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_488515921851693262020159392932647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"社保证明文件\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_396515921851741332020159393413347245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"收费方案\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_378515921851822812020159394228147245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"fixed\":false,\"title\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3\"}],\"implementationPlanInfo\":{\"webApp\":[{\"name\":\"快快快\",\"type\":\"网站\",\"domain\":\"kk.com\",\"appStoreName\":\"坎坎坷坷扩\",\"serverAddress\":\"坎坎坷坷\"}],\"targetUser\":[\"个人\"],\"profitableWay\":[\"混合收费\"],\"specialApproval\":[{\"file\":{},\"title\":\"新闻\"},{\"file\":{},\"title\":\"出版\"},{\"file\":{},\"title\":\"药品和医疗器材\"},{\"file\":{},\"title\":\"文化\"},{\"file\":{},\"title\":\"视听节目\"}],\"serviceProjectEdi\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_339515921853173562020159415735647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"电子交换业务\",\"value\":[\"贸易事务数据结构化/自动处理和交换服务\",\"行政事务数据结构化/自动处理和交换服务\"]},{\"file\":{},\"title\":\"交易处理业务\",\"value\":[\"BTO C第三方交易平台\"]},{\"title\":\"网络/电子设备数据处理业\",\"value\":[\"物联网应用平台服务\"]}],\"serviceProjectIcp\":[{\"title\":\"信息发布平台和递送服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息搜索查询服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息社区服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息及时交互服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息保护加工处理服务\",\"value\":[],\"otherValue\":\"\"}]}}"
            },
            {
                "OrderNum": "O202006130015",
                "TxOrdersNum": "O202006130015",
                "UserName": "张三",
                "UserId": "1",
                "UpdatedAt": "2020-06-16T01:44:33.000Z",
                "TotalSum": 300,
                "RefundSum": 0,
                "PayTime": null,
                "DeletedAt": null,
                "ServicerCode": "gsb",
                "ServicerName": "公司宝",
                "ProductType": "/qcfw/edi/",
                "ProductTypeName": "/资质证照/edi/",
                "OrderSnapshot": "{\"contactsName\":\"123\"}",
                "EndTime": null,
                "RegionId": "8",
                "RegionName": "北京",
                "DeliveryStatus": 170,
                "DeliveryStatusName": "已完成",
                "DeliverContent": "{\"qualification\":{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_422515919726637762020122237437769592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\",\"name\":\"9592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\"},\"endAt\":\"2020-06-23 08:00:00\",\"startAt\":\"2020-06-09 08:00:00\",\"businessScope\":\"d\",\"businessTypes\":\"d\",\"serviceProject\":\"d\",\"certificateNumber\":\"d\"},\"recipientInfo\":{\"name\":\"lll\",\"email\":\"dfgfdgdf@qq.com\",\"phone\":\"17293892382\",\"address\":\"dfsfdsfs\",\"courierNumber\":\"lll\",\"logisticsCompany\":\"ffff\"}}"
            }
        ],
        "RequestId": "84b56a00-b29e-11ea-a776-bf0f0e09cf0b"
    }
}

```

## **<a name="RefusalSolution"> 关闭需求推送到服务商</a>**
[返回到目录](#menu)
##### URL
[/api/receive/needApi/springBoard]
 
#### 参数格式  `JSON`人
#### HTTP请求方式 `POST`
#### 渠道执行的类型 Action：RefusalSolution

参数名 |  必须 | 字段类型 | 长度限制 | 说明
-|-|-|-|-
NeedNum | Y | string | 100 | 需求号
SolutionNum | Y | string | 100 | 方案号
RefusalContent | Y | string | 100 | 备注信息

#### 参数示例
``` javascript
{
    "Action": "RefusalSolution",
    "NeedNum":"",
    "SolutionNum":"",
    "RefusalContent":""  //描述
} 

```
#### 返回结果
```javascript

{"Response":{"Status":1,"InstanceSet":"","RequestId":"27f65f50-b2d4-11ea-b81b-89b08281dc19"}}

```

## **<a name="GetQualificationCertificateListByUserAndType"> 我的资质证照列表</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetQualificationCertificateListByUserAndType
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| CurrentPage  | 否 |  string   | 页码 默认1 |
| PageSize  | 否 |  string   | 页面大小 默认10 |
| LicenseType  | 是 |  int   | 资质类型 1：icp  2:edi  |
| CompanyName  | 否 |  string   | 公司名称  |
| SortType  | 否 |  string   | 按截止时间排序方式,asc:正序 desc:倒序  |


#### 参数示例
``` javascript
    {
        "Action": "GetQcOrderList",
        "PageSize":2,
        "CurrentPage":1,
        "ProductType":"/qcfw/icp/",
        "CompanyName":"公司宝",
        "DeliveryStatus":170,
        "SortType":"asc"
    }             
```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": [
            {
                "ProductType": "/qcfw/icp/",
                "OrderNum": "O202006130014",
                "DeliveryStatus": 170,
                "UpdatedAt": "2020-06-16T01:44:27.000Z",
                "OrderSnapshot": "{\"memoInfo\":\"11111111111111111111\",\"isWhether\":true,\"addressType\":true,\"companyName\":\"breijinhg\",\"fullAddress\":\"\",\"serviceArea\":\"北京\",\"serviceCode\":\"110100\",\"businessType\":\"公司注册\",\"contactsName\":\"111111\",\"taxpayerType\":\"小规模纳税人\",\"businessScope\":\"演出及经纪业务；组织文化艺术活动；演出票务代理；字画、工艺美术品（金饰品除外）、旅游纪念品的销售；演出器材的销售、租赁；艺术装饰；艺术品展示； 舞台美术、工艺美术品、包装装璜设计、制作。\",\"contactsPhone\":\"18738988150\",\"engagedIndustry\":\"文化传媒类\",\"companyProperties\":\"有限责任公司\"}",
                "DeliverContent": "{\"clerkName\":\"小三\",\"clerkPhone\":\"4567800\",\"safetyInfo\":{\"qualification\":\"咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩\",\"responsibility\":\"咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩咔咔咔咔咔咔扩扩扩\"},\"proposerInfo\":{\"contactInfo\":{\"name\":\"123\",\"email\":\"www@qq.com\",\"phone\":\"17292865373\",\"address\":\" 北京市海淀区北清路164号17-27号院813号 \"},\"principalInfo\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_326515921836585432020159141854347245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"123\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"法定代表人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_297515921836625302020159142253047245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"234\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"客服负责人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_18451592183667032202015914273247245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"456\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"安全负责人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_13951592183671026202015914312647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"789\",\"email\":\"sdhj@qq.com\",\"phone\":\"17829763837\",\"title\":\"许可证负责人\",\"certificateId\":\"19281726568398273667\",\"certificateType\":\"身份证\"}],\"recipientInfo\":{\"name\":\"123\",\"email\":\"www@qq.com\",\"phone\":\"17292865373\",\"address\":\" 北京市海淀区北清路164号17-27号院813号 \"},\"businessLicense\":{\"name\":\"公司宝\",\"type\":\"有限责任公司(法人独资)\",\"address\":\"北京市海淀区北清路164号17-27号院813号\",\"createdAt\":\"2014-02-25\",\"businessTerm\":\"2014-08-07 至 2034-08-06\",\"scopeBusiness\":\"技术开发、技术推广、技术转让、技术咨询、技术服务；计算机系统服务；数据处理(数据处理中的银行卡中心、PUE值在1.5以上的云计算数据中心除外)；基础软件服务；应用软件服务；软件开发；软件咨询；产品设计；模型设计；包装装潢设计；教育咨询；经济贸易咨询；文化咨询；体育咨询；公共关系服务；会议服务；工艺美术设计；电脑动画设计；企业策划；设计、制作、代理、发布广告；市场调查；企业管理咨询；组织文化艺术交流活动(不含营业性演出)；文艺创作；承办展览展示活动；影视策划；翻译服务；商标转让；商标代理；版权转让、版权代理；财务咨询(不得开展审计、验资、查帐、评估、会计咨询、代理记账等需经专项审批的业务,不得出具相应的审计报告、验资报告、查帐报告、评估报告等文字材料)；销售自行开发后的产品、机械设备、计算机、软件及辅助设备、通讯设备、电子产品、日用品、文化用品、工艺品；出租办公用房；机动车公共停车场服务；物业管理；健康咨询（须经审批的诊疗活动除外）；代理记账；人力资源服务。（企业依法自主选择经营项目，开展经营活动；代理记账、人力资源服务以及依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。）\",\"enterpriseCode\":\"911101083066224948\",\"registeredCapital\":1000000,\"legalRepresentative\":\"李丽\"},\"businessInformation\":{\"address\":\"北京市海淀区北清路164号17-27号院813号\",\"zipCode\":\"www@qq.com\",\"ifListed\":\"false\",\"staffSize\":\"大于等于100人，且小于300人\",\"legalTypes\":\"企业法人\",\"businessScale\":\"年收入亿万级\",\"comapnyNature\":\"民营控股\",\"fixedTelephone\":\" 010-849*\",\"bussinessDirection\":\"公共管理、社会和保障和社会组织\"}},\"servicerCode\":\"1\",\"servicerName\":\"公司宝\",\"qualification\":{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_422515919726637762020122237437769592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\",\"name\":\"9592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\"},\"endAt\":\"2020-06-23 08:00:00\",\"startAt\":\"2020-06-09 08:00:00\",\"businessScope\":\"d\",\"businessTypes\":\"d\",\"serviceProject\":\"d\",\"certificateNumber\":\"d\"},\"recipientInfo\":{\"name\":\"lll\",\"email\":\"dfgfdgdf@qq.com\",\"phone\":\"17293892382\",\"address\":\"dfsfdsfs\",\"courierNumber\":\"lll\",\"logisticsCompany\":\"ffff\"},\"shareholderData\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_53515921850353862020159371538647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"name\":\"123\",\"type\":\"境内机自然人\",\"address\":\"北京\",\"idNumber\":\"1983729277829375339\",\"companyCode\":\"282938485993\",\"currencyType\":\"人民币\",\"declareCompany\":\"汉唐\",\"holdProportion\":20,\"waysInvestment\":\"货币\",\"investmentAmount\":100,\"superiorIdNumber\":\"183749273840\",\"superiorShareholder\":\"123\"}],\"otherMaterialsInfo\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_6515921851356352020159385563547245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"营业执照\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_47951592185140207202015939020747245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"域名证书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_851592185147298202015939729847245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"申请者国家企业信用信息公示系统截图\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_152515921851514492020159391144947245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"股东追溯承诺书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_192515921851557422020159391574247245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"依法经营电信业务承诺书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_485515921851603502020159392035047245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"服务器托管协议\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_221515921851644682020159392446847245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"服务器托管商编号C证书\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_488515921851693262020159392932647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"社保证明文件\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_396515921851741332020159393413347245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"收费方案\"},{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_378515921851822812020159394228147245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"fixed\":false,\"title\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3\"}],\"implementationPlanInfo\":{\"webApp\":[{\"name\":\"快快快\",\"type\":\"网站\",\"domain\":\"kk.com\",\"appStoreName\":\"坎坎坷坷扩\",\"serverAddress\":\"坎坎坷坷\"}],\"targetUser\":[\"个人\"],\"profitableWay\":[\"混合收费\"],\"specialApproval\":[{\"file\":{},\"title\":\"新闻\"},{\"file\":{},\"title\":\"出版\"},{\"file\":{},\"title\":\"药品和医疗器材\"},{\"file\":{},\"title\":\"文化\"},{\"file\":{},\"title\":\"视听节目\"}],\"serviceProjectEdi\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_339515921853173562020159415735647245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\",\"name\":\"47245E5D-C49F-4CBD-AD34-6E31048B6DE3.jpeg\"},\"title\":\"电子交换业务\",\"value\":[\"贸易事务数据结构化/自动处理和交换服务\",\"行政事务数据结构化/自动处理和交换服务\"]},{\"file\":{},\"title\":\"交易处理业务\",\"value\":[\"BTO C第三方交易平台\"]},{\"title\":\"网络/电子设备数据处理业\",\"value\":[\"物联网应用平台服务\"]}],\"serviceProjectIcp\":[{\"title\":\"信息发布平台和递送服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息搜索查询服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息社区服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息及时交互服务\",\"value\":[],\"otherValue\":\"\"},{\"title\":\"信息保护加工处理服务\",\"value\":[],\"otherValue\":\"\"}]}}"
            }
        ],
        "DataCount": 1,
        "RequestId": "bd5fa3c0-b29e-11ea-a776-bf0f0e09cf0b"
    }
}

```

## **<a name="GetQualificationCertificateDetail"> 我的资质证照详情</a>**
[返回到目录](#menu)
##### URL
[/api/action/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 功能模块 Action：GetQualificationCertificateDetail
#### 参数说明


|   参数名   | 必填  |  类型   | 描述  |
|  ----  | ----  |  ----  | ----  |
| UserId  | 是 |  string   | 用户id  |
| CertificateNo  | 是 |  string   | 证照编号 |


#### 参数示例
``` javascript
    {
        "Action": "GetQualificationCertificateDetail",
        "CertificateNo":"d"
    }         

```

#### 返回结果
```javascript
{
    "Response": {
        "Status": 1,
        "InstanceSet": {
            "QualificationCertificate": "{\"user_id\":\"1\",\"certificate_no\":\"d\",\"company_name\":null,\"business_coverage\":\"d\",\"issue_date\":\"2020-06-09T00:00:00.000Z\",\"expiration_date\":\"2020-06-23T00:00:00.000Z\",\"business_type\":\"d\",\"service_item\":\"d\",\"certificate_file\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_422515919726637762020122237437769592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\",\"license_type\":2,\"license_type_name\":\"EDI资质\"}",
            "BusinessLicenseInfo": "{\"tx_orders_num\":\"O202006130014\",\"businessLicense\":{\"name\":\"公司宝\",\"type\":\"有限责任公司(法人独资)\",\"address\":\"北京市海淀区北清路164号17-27号院813号\",\"createdAt\":\"2014-02-25\",\"businessTerm\":\"2014-08-07 至 2034-08-06\",\"scopeBusiness\":\"技术开发、技术推广、技术转让、技术咨询、技术服务；计算机系统服务；数据处理(数据处理中的银行卡中心、PUE值在1.5以上的云计算数据中心除外)；基础软件服务；应用软件服务；软件开发；软件咨询；产品设计；模型设计；包装装潢设计；教育咨询；经济贸易咨询；文化咨询；体育咨询；公共关系服务；会议服务；工艺美术设计；电脑动画设计；企业策划；设计、制作、代理、发布广告；市场调查；企业管理咨询；组织文化艺术交流活动(不含营业性演出)；文艺创作；承办展览展示活动；影视策划；翻译服务；商标转让；商标代理；版权转让、版权代理；财务咨询(不得开展审计、验资、查帐、评估、会计咨询、代理记账等需经专项审批的业务,不得出具相应的审计报告、验资报告、查帐报告、评估报告等文字材料)；销售自行开发后的产品、机械设备、计算机、软件及辅助设备、通讯设备、电子产品、日用品、文化用品、工艺品；出租办公用房；机动车公共停车场服务；物业管理；健康咨询（须经审批的诊疗活动除外）；代理记账；人力资源服务。（企业依法自主选择经营项目，开展经营活动；代理记账、人力资源服务以及依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。）\",\"enterpriseCode\":\"911101083066224948\",\"registeredCapital\":1000000,\"legalRepresentative\":\"李丽\"}}",
            "AnnualReportList": "[{\"annualReportList\":[{\"file\":{\"url\":\"https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_13151591685846571202091457265719592BBA6-5CA0-4536-83B7-7E8BAD85CCFE.jpeg\",\"name\":\"jjjjjddd\"},\"year\":2020,\"status\":\"declaresuccess\",\"updated_at\":\"2020-09-01\"},{\"file\":null,\"year\":2021,\"status\":\"waitdeclare\",\"updated_at\":\"2020-09-01\"},{\"file\":null,\"year\":2022,\"status\":\"waitdeclare\",\"updated_at\":\"2020-09-01\"},{\"file\":null,\"year\":2023,\"status\":\"waitdeclare\",\"updated_at\":\"2020-09-01\"}]}]"
        },
        "RequestId": "d609e110-b29e-11ea-a776-bf0f0e09cf0b"
    }
}

```