var path = require('path');
var ENVINPUT = {
  DB_HOST: process.env.DB_HOST,
  DB_PORT: process.env.DB_PORT,
  DB_USER: process.env.DB_USER,
  DB_PWD: process.env.DB_PWD,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  DB_NAME: process.env.BRG_USER_CENTER_DB_NAME,
  REDIS_DB: process.env.BRG_USER_CENTER_REDIS_DB,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : "dev"
};
var settings = {
  env: ENVINPUT.APP_ENV,
  usertimeout: 3600,//单位秒
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 4011,
  opLogUrl: function () {
    if (this.env == "dev" || this.env == "test") {
      return "http://192.168.1.128:4019/api/queueAction/producer/springBoard";
    } else {
      return "http://logs-sytxpublic-msgq-service/api/queueAction/producer/springBoard";
    }
  },
  opPushUrl: function () {
    if (this.env == "dev" || this.env == "test") {
      return "http://192.168.1.128:4018/api/queueAction/producer/springBoard";
    } else {
      return "http://sytxpublic-msgq-service/api/queueAction/producer/springBoard";
    }
  },
  deliveryUrl: function () {
    if (this.env == "dev" || this.env == "test") {
      return "http://tx.g.com:8000";
    } else {
      return "http://tx.brg.tencentyun.com";
    }
  },
  hemingUrl: function () {
    if (this.env == "dev" || this.env == "test") {
      return "http://192.168.1.131:15502/gsb/heming";
    } else {
      return "http://ic-name-service/gsb/heming";
    }
  },
  redis: function () {
    if (this.env == "dev" || this.env == "test") {
      var localsettings = require("./localsettings");
      return localsettings.redis;
    } else {
      return {
        host: ENVINPUT.REDIS_HOST,
        port: ENVINPUT.REDIS_PORT,
        password: ENVINPUT.REDIS_PWD,
        db: ENVINPUT.REDIS_DB,
      };
    }
  },
  database: function () {
    if (this.env == "dev" || this.env == "test") {
      var localsettings = require("./localsettings");
      return localsettings.database;
    } else {
      return {
        dbname: ENVINPUT.DB_NAME,
        user: ENVINPUT.DB_USER,
        password: ENVINPUT.DB_PWD,
        config: {
          host: ENVINPUT.DB_HOST,
          port: ENVINPUT.DB_PORT,
          dialect: 'mysql',
          operatorsAliases: false,
          pool: {
            max: 5,
            min: 0,
            acquire: 90000000,
            idle: 1000000
          },
          timezone: '+08:00',
          debug: false,
          dialectOptions: {
            requestTimeout: 999999,
            // instanceName:'DEV'
          }  //设置MSSQL超时时间
        },
      };
    }
  }
};
module.exports = settings;
