const system = require("../system");
const redis = require("redis");
const settings = require("../../config/settings");
const bluebird = require("bluebird");
bluebird.promisifyAll(redis);
class RedisClient {
  constructor() {
    this.client = this.getCreateClientInstance();
    this.subclient = this.client.duplicate();
  }

  getDuplicateInstance() {
    return this.subclient;
  }
  getCreateClientInstance() {
    const redisConfig = settings.redis()
    return redis.createClient({
      host: redisConfig.host,
      port: redisConfig.port,
      password: redisConfig.password,
      db: redisConfig.db,
      retry_strategy: function (options) {
        if (options.total_retry_time > 1000 * 60 * 60) {
          return new Error('Retry time exhausted');
        }
        if (options.attempt > 10) {
          return 10000;
        }
        return Math.min(options.attempt * 100, 3000);
      }
    });
  }
  /**
     * 设置缓存
     * @param {*} key key
     * @param {*} val 值
     * @param {*} t 过期时间，为空则永久存在
     */
  async setWithEx(key, val, t) {
    var p = this.client.setAsync(key, val);
    if (t) {
      this.client.expire(key, t);
    }
    return p;
  }
  /**
   * 获取缓存
   * @param {*} key key
   */
  async getCache(key) {
    return this.client.getAsync(key);
  }
  /**
 * 删除缓存
 * @param {*} key key
 */
  async delete(key) {
    return this.client.delAsync(key);
  }
  /**
   * 判断缓存是否存在
   * @param {*} key key
   */
  async exists(key) {
    return this.client.existsAsync(key);
  }
  /**
   * 设置业务锁
   * @param {*} lockKey 锁key
   */
  async init(lockKey, lockValue, lockTime) {
    this.client.rpushAsync(lockKey, lockValue || "1");
    this.client.expire(lockKey, lockTime || 6000);
  }
  /**
   * 获取业务锁
   * @param {*} lockKey 锁key
   */
  async enter(lockKey) {
    return this.client.rpopAsync(lockKey);
  }
}
module.exports = RedisClient;