const system = require("../system");
const moment = require('moment')
const settings = require("../../config/settings");
const axios = require('axios');
const md5 = require("MD5");
class ServiceBase {
  constructor(gname, daoName) {
    this.execClient = system.getObject("util.execClient");
    this.db = system.getObject("db.common.connection").getCon();
    this.daoName = daoName;
    this.dao = system.getObject("db." + gname + "." + daoName);
  }
  /**
          * 带超时时间的post请求
          * @param {*} params 请求数据-json格式
          * @param {*} url 请求地址
          * @param {*} ContentType 请求头类型，默认application/json
          * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
          * @param {*} timeOut 超时时间
          */
  async execPostByTimeOut(params, url, ContentType, headData, timeOut = 60) {
    return await this.execClient.execPostTimeOutByBusiness("sve.base", params, url, ContentType, headData, timeOut);
  }
  /**
   * 验证签名
   * @param {*} params 要验证的参数 
   * @param {*} app_key 应用的校验key
   */
  async verifySign(params, app_key) {
    if (!params) {
      return system.getResult(null, "请求参数为空");
    }
    if (!params.sign) {
      return system.getResult(null, "请求参数sign为空");
    }
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResult(null, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey] && !(params[tKey] instanceof Array)) {
        signArr.push(tKey + "=" + params[tKey]);
      }
    }
    if (signArr.length == 0) {
      return system.getResult(null, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_key;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    if (params.sign != resultTmpSign) {
      return system.getResult(null, "返回值签名验证失败");
    }
    return system.getResultSuccess();
  }
  /**
 * 创建签名
 * @param {*} params 要验证的参数 
* @param {*} app_key 应用的校验key
 */
  async createSign(params, app_key) {
    if (!params) {
      return system.getResultFail(-310, "请求参数为空");
    }
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResultFail(-330, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey] && !(params[tKey] instanceof Array)) {
        signArr.push(tKey + "=" + params[tKey]);
      }
    }
    if (signArr.length == 0) {
      return system.getResultFail(-350, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_key;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    return system.getResultSuccess(resultTmpSign);
  }
  /**
   * 验证参数信息不能为空
   * @param {*} params 验证的参数
   * @param {*} verifyParamsCount 需要验证参数的数量，如至少验证3个，则传入3
   * @param {*} columnList 需要过滤掉的验证参数列表，格式:[]
   */
  async verifyParams(params, verifyParamsCount, columnList) {
    if (!params) {
      return system.getResult(null, "请求参数为空");
    }
    if (!columnList) {
      columnList = [];
    }
    var keys = Object.keys(params);
    if (keys.length == 0) {
      return system.getResult(null, "请求参数信息为空");
    }
    if (keys.length < verifyParamsCount) {
      return system.getResult(null, "请求参数不完整");
    }
    var tResult = system.getResultSuccess();
    for (let k = 0; k < keys.length; k++) {
      const tKeyValue = keys[k];
      if (columnList.length == 0 || columnList.indexOf(tKeyValue) < 0) {
        if (!tKeyValue) {
          tResult = system.getResult(null, k + "参数不能为空");
          break;
        }
      }//白名单为空或不在白名单中，则需要验证不能为空
    }
    return tResult;
  }
  static getDaoName(ClassObj) {
    var nameStr = ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Service")) + "Dao";
    var initialStr = nameStr.substring(0, 1);
    var resultStr = initialStr.toLowerCase() + nameStr.substring(1, nameStr.length);
    return resultStr;
    // return ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Service")).toLowerCase() + "Dao";
  }
  async findAndCountAll(obj) {
    const apps = await this.dao.findAndCountAll(obj);
    return apps;
  }
  async refQuery(qobj) {
    return this.dao.refQuery(qobj);
  }
  async bulkDeleteByWhere(whereParam, t) {
    return await this.dao.bulkDeleteByWhere(whereParam, t);
  }
  async bulkDelete(ids) {
    var en = await this.dao.bulkDelete(ids);
    return en;
  }
  async delete(qobj) {
    return this.dao.delete(qobj);
  }
  async create(qobj) {
    return this.dao.create(qobj);
  }
  async update(qobj, tm = null) {
    return this.dao.update(qobj, tm);
  }
  async updateByWhere(setObj, whereObj, t) {
    return this.dao.updateByWhere(setObj, whereObj, t);
  }
  async customExecAddOrPutSql(sql, paras = null) {
    return this.dao.customExecAddOrPutSql(sql, paras);
  }
  async customQuery(sql, paras, t) {
    return this.dao.customQuery(sql, paras, t);
  }
  async findCount(whereObj = null) {
    return this.dao.findCount(whereObj);
  }
  async findSum(fieldName, whereObj = null) {
    return this.dao.findSum(fieldName, whereObj);
  }
  async getPageList(pageIndex, pageSize, whereObj = null, orderObj = null, attributesObj = null, includeObj = null) {
    return this.dao.getPageList(pageIndex, pageSize, whereObj, orderObj, attributesObj, includeObj);
  }
  async findOne(obj) {
    return this.dao.findOne(obj);
  }
  async findById(oid) {
    return this.dao.findById(oid);
  }
  /*
  返回20位业务订单号
  prefix：业务前缀
  */
  async getBusUid(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 8 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    var timStr = moment().format("YYYYMMDDHHmm");
    return prefix + timStr + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }
}
module.exports = ServiceBase;
