const system = require("../../../system");
const { PDICT } = require("../../../../config/platform");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class QualificationCertificateService extends ServiceBase {
  constructor() {
    super("order", ServiceBase.getDaoName(QualificationCertificateService));
    this.orderProductDao = system.getObject("db.order.orderProductDao");
    this.orderInfoDao = system.getObject("db.order.orderInfoDao");
    this.orderDeliveryDao = system.getObject("db.order.orderDeliveryDao");
  }
  /**
   * 用户获取资质证照列表
   * @param {*} pobj 
   */
  async getQualificationCertificateListByUserAndType(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.LicenseType) {
      return system.getResultFail(-103, "证照类型不能为空");
    }
    var limit = ab.PageSize ? Number(ab.PageSize) : 10;
    var offset = ab.CurrentPage ? (Number(ab.CurrentPage) - 1) * limit : 0
    var countObj = { license_type: ab.LicenseType, user_id: ab.UserId };
    var whereObj = { license_type: ab.LicenseType, user_id: ab.UserId };
    if (ab.CompanyName) {
      whereObj["company_name"] = { [this.db.Op.like]: "%" + ab.CompanyName + "%" };
      countObj["company_name"] = { [this.db.Op.like]: "%" + ab.CompanyName + "%" };
    }
    var sortType = "desc";
    if(ab.SortType && ab.SortType=="asc"){
        sortType = "asc";
    }
    var count = await this.dao.findCount({ where: countObj });
    var list = await this.dao.model.findAll({
      where: whereObj,
      limit: limit,
      offset: offset,
      raw: true,
      attributes: [
        "user_id",   //用户id
        "user_name",   //用户名称
        "servicer_code",   //服务商code			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
        "servicer_name",   //服务商名称			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
        "certificate_no",   //证书编号			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
        "company_name",   //公司名称			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
        "business_coverage",   //业务覆盖范围			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
        "issue_date",   //发证日期					0	0	0	0	0	0	0
        "expiration_date",   //截止期至					0	0	0	0	0	0	0
        "business_type",   //业务种类			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
        "service_item",   //服务项目			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
        "certificate_file" ,   //证书文件			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
        "license_type",
        "license_type_name"
      ],
      order: [["expiration_date", sortType]]
    });
    var result =system.getResultSuccess(list);
    result.dataCount = count;
    return result;
  }

  /**
   * 用户获取证照详情
   */
  async getQualificationCertificateDetail(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.UserId) {
      return system.getResultFail(-102, "用户id不能为空");
    }
    if (!ab.CertificateNo) {
      return system.getResultFail(-103, "证书编号不能为空");
    }
    //获取资质证照信息
    var qualificationCertificate = await this.dao.model.findOne({
      where: { user_id: ab.UserId, certificate_no: ab.CertificateNo },
      attributes: [
        "user_id",
        "certificate_no",
        "company_name",
        "business_coverage",
        "issue_date",
        "expiration_date",
        "business_type",
        "service_item",
        "certificate_file",
        "license_type",
        "license_type_name"
      ],
      raw: true
    });
    if (!qualificationCertificate || !qualificationCertificate.certificate_no) {
      return system.getResultFail(-300, "未知资质信息");
    }
    var result = { qualificationCertificate: qualificationCertificate, businessLicenseInfo: null, annualReportList:null};
    //获取营业执照信息及腾讯订单号
    var businessLicenseInfo = await this.orderDeliveryDao.findByCertificateNoAndUser(qualificationCertificate.certificate_no, ab.UserId);
    if(businessLicenseInfo && businessLicenseInfo.length>0){
        result.businessLicenseInfo = businessLicenseInfo[0];
    }
    
    if(result.businessLicenseInfo && result.businessLicenseInfo.tx_orders_num){
        //根据腾讯订单号(主订单号)获取年报列表
        var annualReportList = await this.orderDeliveryDao.getAnnualReportByTxOrderNum(result.businessLicenseInfo.tx_orders_num);
        result.annualReportList = annualReportList;
    }
    return system.getResultSuccess(result);
  }
}
module.exports = QualificationCertificateService;
