const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const { PDICT, MsgTemplate } = require("../../../../config/platform");
class NeedSolutionService extends ServiceBase {
  constructor() {
    super("need", ServiceBase.getDaoName(NeedSolutionService));
    this.needInfoDao = system.getObject("db.need.needInfoDao");
    this.utilsMsgSendSve = system.getObject("service.utilsSve.utilsMsgSendSve");
  }
  /**
   * 发送短信通知
   * @param {*} mobile 接收人手机号
   * @param {*} userId 用户id
   * @param {*} consultType 产品类型
   * @param {*} consultName 产品类型名称
   * @param {*} status 状态
   */
  async sendSmsNotification(mobile, userId, consultType, consultName, status) {
    try {
      var nameArr = consultName ? consultName.split("/") : [];
      var productName = null;
      if (nameArr && nameArr.length == 4) {
        productName = nameArr[2];
      }
      var params = { phoneNumber: mobile, messageBody: null };
      var webinfoParams = { "title": null, "subAccount": userId, "messageBody": null };//站内信通知参数
      var messageBody = null;
      var webinfoMessageBody = null;
      if (consultType.indexOf("/ic/") >= 0) {//工商产品
        messageBody = MsgTemplate.ic.need[status] && MsgTemplate.ic.need[status].sms ? MsgTemplate.ic.need[status].sms : "";
        messageBody = messageBody.replace(/{productName}/g, productName);
        webinfoMessageBody = MsgTemplate.ic.need[status] && MsgTemplate.ic.need[status].webinfo ? MsgTemplate.ic.need[status].webinfo : "";
        webinfoMessageBody = webinfoMessageBody.replace(/{productName}/g, productName);
        webinfoParams.title = MsgTemplate.ic.need[status] && MsgTemplate.ic.need[status].webinfotitle ? MsgTemplate.ic.need[status].webinfotitle : "";

      }
      if (consultType.indexOf("/qcfw/") >= 0) {//资质证照产品

      }
      // console.log(messageBody,"ddddddddd");
      if (userId && webinfoParams.title && messageBody && messageBody.indexOf("{") < 0 && messageBody.indexOf("}") < 0 && webinfoMessageBody && webinfoMessageBody.indexOf("{") < 0 && webinfoMessageBody.indexOf("}") < 0) {
        params.messageBody = messageBody;
        webinfoParams.messageBody = webinfoMessageBody;
        // await this.utilsMsgSendSve.sendMessageByPhone(params);//发送短信
        await this.utilsMsgSendSve.sendMessageVerify({ phoneList: [params], subAccountList: [webinfoParams] });
      }
      return;
    } catch (e) {
      this.execClient.execLogs("needSolutionSve.js/sendSmsNotification(发送短信通知)方法出现异常", { mobile: mobile, consultType: consultType, consultName: consultName, status: status }, "", null, e.stack);
      return;
    }


  }
  //服务商提交/修改方案
  async submitSolution(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.needNum) {
      return system.getResultFail(-101, "需求号不能为空");
    }
    if (!ab.solutionContent) {
      return system.getResultFail(-102, "方案内容不能为空");
    }
    if (!ab.solutionContent.businessType) {
      return system.getResultFail(-103, "方案内容有误,商机类型不能为空");
    }

    var needinfo = await this.needInfoDao.model.findOne({
      where: { need_num: ab.needNum },
      raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-300, "未知需求信息");
    }
    if (needinfo.status == 4 || needinfo.status == 5) {
      return system.getResultFail(-304, "操作失败，需求状态错误");
    }
    if (needinfo.consult_type != ab.solutionContent.businessType) {
      return system.getResultFail(-305, "商机类型与需求信息不符");
    }
    var needsolution = null;
    if (ab.solutionNum) {//方案编码，修改方案时传入，不传默认新增
      needsolution = await this.dao.model.findOne({
        where: { need_num: ab.needNum, solution_num: ab.solutionNum },
        raw: true
      });
      if (!needsolution || !needsolution.id) {
        return system.getResultFail(-301, "方案修改失败，未知方案信息");
      }
      if (needsolution.is_refusal != 1) {
        return system.getResultFail(-303, "只能修改用户驳回方案");
      }
      // var new_solution_num = await this.getBusUid("NS_");
      var updateObj = { id: needsolution.id, is_refusal: 0, solution_content: ab.solutionContent };
      var self = this;
      return await self.db.transaction(async function (t) {
        await self.dao.update(updateObj, t);
        await self.needInfoDao.update({ id: needinfo.id, status: "3" }, t);
        //发送短信通知
        self.sendSmsNotification(needinfo.contacts_mobile, needinfo.user_id, needinfo.consult_type, needinfo.consult_type_name, 3);
        return system.getResultSuccess();
      });

    } else {
      needsolution = await this.dao.model.findOne({
        where: { need_num: ab.needNum },
        raw: true
      });
      if (needsolution && needsolution.id) {
        return system.getResultFail(-302, "新增失败，已存在方案信息");
      }
      var solution_num = await this.getBusUid("NS_");
      var createObj = {
        solution_num: solution_num,
        need_num: ab.needNum,
        user_id: needinfo.user_id,
        user_name: needinfo.user_name,
        solution_content: ab.solutionContent
      };
      var self = this;
      return await self.db.transaction(async function (t) {
        await self.needInfoDao.update({ id: needinfo.id, status: "3" }, t);
        await self.dao.create(createObj, t);
        //发送短信通知
        // self.sendSmsNotification(needinfo.contacts_mobile,needinfo.consult_type,needinfo.consult_type_name,3);
        self.sendSmsNotification(needinfo.contacts_mobile, needinfo.user_id, needinfo.consult_type, needinfo.consult_type_name, 3);
        return system.getResultSuccess(solution_num);
      });

    }
  }

  //驳回方案
  async refusalSolution(actionBody, t) {
    if (!actionBody.NeedNum) {
      return system.getResultFail(-102, "needNum cannot be empty");
    }
    if (!actionBody.SolutionNum) {
      return system.getResultFail(-102, "SolutionNum cannot be empty");
    }
    var self = this;
    return await self.db.transaction(async function (t) {
      var sobj = {
        need_num: actionBody.NeedNum
      }
      var needInfo = await self.needInfoDao.findOne(sobj, t);
      if (!needInfo) {
        return system.getResultFail(-102, "needInfo is empty");
      }
      sobj.solution_num = actionBody.SolutionNum;
      var solutionInfo = await self.dao.findOne(sobj, t);
      if (!solutionInfo) {
        return system.getResultFail(-102, "solutionInfo is empty");
      }
      var urlobj = {
        path_code: needInfo.dataValues.consult_type,
        region_id: needInfo.dataValues.region_id
      }
      var serviceinfo = await this.needInfoDao.findServiceByProductType(urlobj);
      if (serviceinfo.status < 0) {
        return system.getResultFail(-203, "servicer is empty");
      }


      //生产者------方案反馈
      var pushobj = {
        "actionType": "produceData",// Y 功能名称
        "actionBody": {
          notifyUrl: "",
          actionType: "needClose",
          pushUrl: serviceinfo.data.push_domain_addr + "/entService/consultation/springBoard",
          messageBody: actionBody,
          identifyCode: "needClose"
        }
      };
      var r = await self.execPostByTimeOut(pushobj, settings.opPushUrl());
      if (r.status < 1) {
        return system.getResultFail(-102, "Post error");
      }
      await self.needInfoDao.update({ id: needInfo.dataValues.id, status: 2 }, t);
      await self.dao.update({ id: solutionInfo.dataValues.id, is_refusal: 1, refusal_notes: actionBody.RefusalContent }, t);
      return system.getResultSuccess();
    })
  }
}
module.exports = NeedSolutionService;
// var task = new NeedSolutionService();
// task.sendSmsNotification("15675201933","/ic/cpreg/","/工商服务/云上园区注册/",3).then(d=>{
//   console.log("eeeeeeeeeeeeee"+d);
// })