const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
class NeedInfoService extends ServiceBase {
  constructor() {
    super("need", ServiceBase.getDaoName(NeedInfoService));
    this.needSolutionDao = system.getObject("db.need.needSolutionDao");

  }
  //服务商关闭需求
  async closeNeed(pobj) {
    if (!pobj || !pobj.actionBody) {
      return system.getResultFail(-100, "参数错误");
    }
    var ab = pobj.actionBody;
    if (!ab.needNum) {
      return system.getResultFail(-101, "需求编码不能为空");
    }
    if (!ab.note) {
      return system.getResultFail(-102, "关闭原因不能为空");
    }
    var needinfo = await this.dao.model.findOne({
      where: { need_num: ab.needNum },
      raw: true
    });
    if (!needinfo || !needinfo.id) {
      return system.getResultFail(-300, "未知需求");
    }
    if (!needinfo.status || needinfo.status == 4 || needinfo.status == 5) {
      return system.getResultFail(-301, "操作失败，需求状态错误");
    }
    var self = this;
    return await self.db.transaction(async function (t) {
      await self.dao.update({ id: needinfo.id, status: 5,close_reason:ab.note }, t);
      // var needsolution = await self.needSolutionDao.model.findOne({
      //   where: { need_num: ab.needNum },
      //   raw: true
      // });
      // if (needsolution && needsolution.id) {
      //   await sqlf.needSolutionDao.update({ id: needsolution.id, refusal_notes: ab.note }, t);
      // }
      return system.getResultSuccess();
    })

  }

  /**
   * 
   * @param {*} actionBody 
   */
  //创建需求
  async needSubmit(actionBody) {
    if (!actionBody.ContactsMoblie) {
      return system.getResultFail(-102, "contactsMoblie cannot be empty");
    }
    if (!actionBody.RegionId) {
      return system.getResultFail(-102, "regionId cannot be empty");
    }
    if (!actionBody.RegionName) {
      return system.getResultFail(-102, "regionName cannot be empty");
    }
    if (!actionBody.ConsultType) {
      return system.getResultFail(-102, "consultType cannot be empty");
    }
    if (!actionBody.ConsultTypeName) {
      return system.getResultFail(-102, "consultTypeName cannot be empty");
    }
    if (!actionBody.UserId) {
      return system.getResultFail(-102, "userId cannot be empty");
    }
    try {
      var scobj = {
        "region_id": actionBody.RegionId,
        "regionName": actionBody.RegionName,
        "path_code": actionBody.ConsultType
      }
      var serviceinfo = await this.dao.findServiceByProductType(scobj);
      if (serviceinfo.status < 0) {
        return system.getResultFail(-203, "servicer is empty");
      }
      actionBody.ServicerCode = serviceinfo.data.servicer_code;
      actionBody.ServicerName = serviceinfo.data.servicer_name;

      //需求创建
      var need_num = await this.getBusUid("n");
      var datavalue = {
        need_num: need_num,
        user_id: actionBody.UserId,
        contacts_moblie: actionBody.ContactsMoblie,
        contacts_name: actionBody.ContactsName || "",
        region_id: actionBody.RegionId,
        region_name: actionBody.RegionName,
        consult_type: actionBody.ConsultType,
        consult_type_name: actionBody.ConsultTypeName,
        notes: actionBody.Notes,
        servicer_code: actionBody.ServicerCode,
        servicer_name: actionBody.ServicerName,
        status: 1,
        user_name: actionBody.UserName
      }
      if (actionBody.CompanyName) {
        datavalue.need_info = {
          companyName: actionBody.CompanyName
        };
      }
     

      actionBody.NeedNum = need_num;
      //生产者------需求推送

      var pushobj = {
        "actionType": "produceData",// Y 功能名称
        "actionBody": {
          notifyUrl: "http://brguser.brg.tencentyun.com/api/receive/notifyApi/springBoard",
          actionType: "needSubmit",
          pushUrl: serviceinfo.data.push_domain_addr + "/entService/consultation/springBoard",
          messageBody: actionBody,
          identifyCode: "needSubmit"
        }
      };
      var r = await this.execPostByTimeOut(pushobj, settings.opPushUrl());
      if (r.status < 1) {
        return system.getResultFail(-102, "Post error");
      }
      var newneedinfo = await this.create(datavalue);
      if (!newneedinfo) {
        return system.getResultFail(-310, "newneedinfo cannot be created");
      }
      return system.getResultSuccess();

    } catch (e) {

      return system.getResultFail(-510, e)
    }
  }

  //需求提交回调
  async notifyNeedSubmit(actionBody) {
    if (actionBody.resultInfo.status < 1) {
      return system.getResultFail(-1, "返回值异常")
    }
    if (!actionBody.messageBody.NeedNum) {
      return system.getResultFail(-102, "needNum cannot be empty");
    }
    var needinfo = await this.findOne({ need_num: actionBody.messageBody.NeedNum });
    if (!needinfo) {
      return system.getResultFail(-102, "needinfo is empty");
    }
    try {
      await this.update({ id: needinfo.dataValues.id, status: 2 });
      return system.getResultSuccess();
    } catch (error) {
      return system.getResultFail(-510, error)
    }
  }

  async needList(searchObj) {
    if (!searchObj.UserId) {
      return system.getResultFail(-102, "userId cannot be empty");
    }
    var sort = [["created_at", 'desc']];
    if (searchObj.Sort) {
      searchObj.Sort = JSON.parse(searchObj.Sort);
      if (searchObj.Sort.key == "createdAt") {
        searchObj.Sort.key = "created_at";
      }
      sort = [[searchObj.Sort.key, searchObj.Sort.value]]
    }
    var sobj = {
      search: {
        user_id: searchObj.UserId
      },
      orderInfo: sort,
      pageInfo: {
        pageNo: Number(searchObj.PageNo) || 1,
        pageSize: Number(searchObj.PageSize) || 10
      }
    }
    if (searchObj.ConsultType) {
      sobj.search.consult_type = searchObj.ConsultType;
    }
    if (searchObj.Status) {
      sobj.search.status = searchObj.Status;
    }
    var r = await this.dao.findAndCountAll(sobj);
    return system.getResultSuccess(r);
  }

  async needDetail(searchObj) {
    if (!searchObj.NeedNum) {
      return system.getResultFail(-102, "needNum cannot be empty");
    }
    var sobj = {
      need_num: searchObj.NeedNum
    }
    var needInfo = await this.findOne(sobj);
    if (!needInfo) {
      return system.getResultFail(-102, "needInfo is empty");
    }
    var solutionInfo = await this.needSolutionDao.findOne(sobj);
    if (!solutionInfo) {
      solutionInfo = {
        dataValues: null
      }
    }
    var rtn = {
      needInfo: needInfo.dataValues,
      solutionInfo: solutionInfo.dataValues
    }
    return system.getResultSuccess(rtn);
  }



}
module.exports = NeedInfoService;
