const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class TxPushLogService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(TxPushLogService));
    this.orderProductDao = system.getObject("db.order.orderProductDao");
    this.orderInfoDao = system.getObject("db.order.orderInfoDao");
  
  }

  returnTX(status, componentName, message, data) {
    return {
      "version": 1,
      "componentName": componentName,
      "returnValue": status,
      "returnCode": status,
      "returnMessage": message,
      "data": data
    }

  }

  //发货回调
  async createCbsInstance(pobj, req) {
    var self = this;
    if (!pobj.interface.para.dealName) {
      return self.returnTX(-1, "cgateway", "参数错误", null)
    }
    try {
      var loginfo = await this.findOne({ deal_name: pobj.interface.para.dealName, push_action_type: "orderPayNotify" });
      if (loginfo) {
        return self.returnTX(1, "cgateway", "ok", { "flowId": loginfo.flow_id, "resourceIds": [pobj.interface.para.dealName] })
      }
      var flow_id = await this.getBusUid("f");
      var newobj = {
        flow_id: flow_id,
        deal_name: pobj.interface.para.dealName,
        request_url: "qcloud.PRODUCT_NAME.createResource",
        requestjson: pobj,
        push_url: "/api/action/order/springBoard",
        push_action_type: "orderPayNotify",
        push_status: "2",
      }
      var creatlog = await this.create(newobj);
      if (!creatlog) {
        return self.returnTX(-1, "cgateway", "参数错误", null)
      }
      pobj.logId = creatlog.dataValues.id;
      var pushobj = {
        "actionType": "produceData",// Y 功能名称
        "actionBody": {
          notifyUrl: "",
          actionType: "orderPayNotify",
          pushUrl: "http://brguser.brg.tencentyun.com/api/action/order/springBoard",
          messageBody: pobj,
          identifyCode: "orderPayNotify"
        }
      };
      var a = await this.execPostByTimeOut(pushobj, settings.opPushUrl());

      return self.returnTX(1, "cgateway", "ok", { "flowId": creatlog.flow_id, "resourceIds": [pobj.interface.para.dealName] })
    } catch (error) {
      console.log(error);
      return self.returnTX(-1, "cgateway", "请求失败", null)
    }

  }

  //发货检查
  async queryFlow(pobj) {
    var self=this;
    if (!pobj.interface.para.flowId) {
      return self.returnTX(-1, "cgateway", "参数错误", null)
    }
    var loginfo = await this.findOne({ flow_id: pobj.interface.para.flowId, push_action_type: "orderPayNotify" });
    if (!loginfo) {
      return self.returnTX(-1, "cgateway", "产品不存在", null)
    }
    var orderInfo = await this.orderInfoDao.findOne({ order_num: loginfo.dataValues.dealName });
    if (!orderInfo) {
      return self.returnTX(-1, "cgateway", "资源不存在", null)
    }
    var status = 0;
    if (orderInfo.status == 302) {
      status = 3;
    }
    return self.returnTX(1, "cgateway", "ok", { "status": status })
  }


  //资源拉取
  async queryResources(pobj) {
    var self=this;
    if (!pobj.interface.para.resourceIds[0]) {
      return self.returnTX(-1, "cgateway", "参数错误", null)
    }
    var orderProduct = await this.orderProductDao.findOne({ order_num: loginfo.dataValues.dealName });
    if (!orderProduct) {
      return self.returnTX(-1, "cgateway", "资源不存在", null)
    }
    var r = {
      "eventId": 186993048,
      "version": 1,
      "componentName": "cgateway",
      "timestamp": 1500912302,
      "returnValue": 0,
      "returnCode": 0,
      "returnMessage": "ok",
      "data": {
        "resources": [
          {
            "appId": appId,
            "uin": ownerUin,
            "resourceId": tx_order_snapshot,//站内信自定义字段层级和此字段同一层级
            "projectId": 0,
            "autoRenewFlag": 0,
            "region": 1,
            "zoneId": 200001,
            "status": orderProduct.status,
            "payMode": 1,		// 必传，1预付费 0后付费
            "isolatedTimestamp": orderProduct.isolated_timestamp || "0000-00-00 00:00:00",
            "createTime": orderProduct.start_time,
            "expireTime": orderProduct.end_time || "0000-00-00 00:00:00",
            "goodsDetail": orderProduct.tx_order_snapshot.goodsDetail
          }
        ]
      }
    }
    return self.returnTX(1, "cgateway", "ok", { "status": loginfo.push_status })
  }


  //   {
  //     "version": "1.0",
  //     "caller": "mall_logic",
  //     "componentName": "mall_logic",
  //     "password": "mall_logic",
  //     "callee": "cdb",
  //     "eventId": 843836670,
  //     "seqId": "1501802577.465723597230350480",
  //     "spanId": "logical;1",
  //     "timestamp": 1501802577,
  //     "interface": {
  //         "interfaceName": "qcloud.PRODUCT_NAME.isolateResource",
  //         "para": {
  //             "appId": 123,
  //             "uin": "123",
  //             "operateUin": "123",
  //             "type": "cdb",
  //             "region": 4,
  //             "resourceId": "cdb-dfe8t7i9"
  //             "renewFlag": 0,
  //             "newDeadline": "2016-10-22 12:00:00",
  //             "billingIsolateType": "refund",
  //             "billingExtParam":{
  // 			    "sv_xxx":"sv_xxx"// 查询用量时业务返回的数据
  // 		}
  //         }
  //     }
  // }
  //隔离资源
  async isolateResource(pobj) {
    var self=this;
    if (!pobj.interface.para.resourceId) {
      return self.returnTX(-1, "mall_logic", "参数错误", null)
    }
    var orderProduct = await this.orderProductDao.findOne({ order_num: pobj.interface.para.resourceId });
    if (!orderProduct) {
      return self.returnTX(-1, "mall_logic", "资源不存在", null)
    }
    if (orderProduct.dataValues.status == 2) {
      return self.returnTX(1, "mall_logic", "ok", null)
    }
    if (orderProduct.dataValues.status == 3) {
      return self.returnTX(-1, "mall_logic", "资源已销毁", null)
    }
    await this.orderProductDao.update({ id: orderProduct.dataValues.id, status: 2, isolated_time: new Date() });
    return self.returnTX(1, "mall_logic", "ok", null)

  }

  //销毁资源
  async destroyResource(pobj) {
    var self=this;
    if (!pobj.interface.para.resourceId) {
      return self.returnTX(-1, "mall_logic", "参数错误", null)
    }
    var orderProduct = await this.orderProductDao.findOne({ order_num: pobj.interface.para.resourceId });
    if (!orderProduct) {
      return self.returnTX(-1, "mall_logic", "资源不存在", null)
    }
    if (orderProduct.dataValues.status == 1) {
      return self.returnTX(-1, "mall_logic", "资源未隔离", null)
    }
    if (orderProduct.dataValues.status == 3) {
      return self.returnTX(1, "mall_logic", "资源已销毁", null)
    }
    var flow_id = await this.getBusUid("f");
    var newobj = {
      flow_id: flow_id,
      deal_name: pobj.interface.para.resourceId,
      request_url: "qcloud.PRODUCT_NAME.destroyResource",
      requestjson: pobj,
      push_url: "",
      push_action_type: "",
      push_status: "2",
    }
    var creatlog = await this.create(newobj);
    if (!creatlog) {
      return self.returnTX(-1, "mall_logic", "请求错误", null)
    }
    await this.orderProductDao.update({ id: orderProduct.dataValues.id, status: 3 });
    return self.returnTX(1, "mall_logic", "ok", { flowId: flow_id })

  }

  //新购参数检查
  async checkCreate(pobj) {
    var self=this;
    if (!pobj.interface || !pobj.interface.para || !pobj.interface.para.goodsDetail) {
      return self.returnTX(-1, "qcloud_domain_register", "参数错误", null)
    }
    if (pobj.interface.para.goodsDetail.goodsNum > 1) {
      return this.returnTX(0, "qcloud_domain_register", "ok", { "status": 2 })
    }

    return this.returnTX(0, "qcloud_domain_register", "ok", { "status": 0 })
  }





}
module.exports = TxPushLogService;
