const system = require("../../../system");
const {PDICT} = require("../../../../config/platform");
/**
 * 资质证照
 */
module.exports = (db, DataTypes) => {
  return db.define("qualificationCertificate", {
    user_id: DataTypes.STRING,   //用户id
    user_name: DataTypes.STRING,   //用户名称
    notes: DataTypes.STRING,   //备注
    op_notes: DataTypes.STRING,   //操作备注
    servicer_code: DataTypes.STRING,   //服务商code			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
    servicer_name: DataTypes.STRING,   //服务商名称			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
    certificate_no: DataTypes.STRING,   //证书编号			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
    company_name: DataTypes.STRING,   //公司名称			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
    business_coverage: DataTypes.STRING,   //业务覆盖范围			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
    issue_date : DataTypes.DATE,   //发证日期					0	0	0	0	0	0	0
    expiration_date: DataTypes.DATE,   //截止期至					0	0	0	0	0	0	0
    business_type: DataTypes.STRING,   //业务种类			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
    service_item: DataTypes.STRING,   //服务项目			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
    certificate_file: DataTypes.STRING,   //证书文件			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0
    license_type: //证照类型，1：icp  2:edi					0	0	0	0	0	0	0
    {
      type: DataTypes.INTEGER,
      set: function (val) {
        this.setDataValue("license_type", val);
        this.setDataValue("license_type_name", PDICT.license_type[val]);
      }
    },
    license_type_name: DataTypes.STRING,   //证照类型名称			utf8mb4	utf8mb4_german2_ci	0	0	0	0	0	0	0

  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      // updatedAt: true,
      // createdAt: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_qualification_certificate',
      validate: {

      },
      indexes: [
  
      ]
    });
}
