const system = require("../../../system");
const {PDICT} = require("../../../../config/platform");
/**
 * 订单退款信息
 */
module.exports = (db, DataTypes) => {
  return db.define("orderRefund", {
    order_num: DataTypes.STRING(100),	//order_num	订单号
    tx_orders_num: DataTypes.STRING(100),	//tx_orders_num	腾讯主订单号
    user_id: DataTypes.STRING(100),	//user_id	用户id
    user_name: DataTypes.STRING(100),	//user_name	用户名称
    pay_total_sum: DataTypes.DECIMAL(12, 2),	//pay_total_sum	支付订单总额
    pay_type:	//pay_type	支付类型：1微信，2qq钱包，3网银支付，4余额支付
    {
      type: DataTypes.INTEGER,
      set: function (val) {
        this.setDataValue("pay_type", val);
        this.setDataValue("pay_type_name", PDICT.pay_type[val]);
      }
    },
    pay_type_name: DataTypes.STRING(100),		//pay_type_name	支付类型名称
    pay_info: DataTypes.STRING,	//pay_info	支付信息
    notes: DataTypes.STRING(200),	//notes	备注
    
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      // updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_order_refund',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
