const system = require("../../../system");
const {PDICT} = require("../../../../config/platform");
module.exports = (db, DataTypes) => {
  return db.define("orderInfo", {
    order_num: DataTypes.STRING,  //订单号
    tx_orders_num: DataTypes.STRING,   //腾讯主订单号
    need_num: DataTypes.STRING,   //需求号
    user_id: DataTypes.STRING,   //用户id
    user_name: DataTypes.STRING,   //用户名称
    pay_time:DataTypes.DATE,//付款时间
    quantity: DataTypes.INTEGER,   //订单数量
    total_sum: DataTypes.INTEGER,   //订单总额
    discount_amount: DataTypes.INTEGER,  //折扣金额
    pay_total_sum: DataTypes.INTEGER,  //付订单总额
    refund_sum: DataTypes.INTEGER,   //退款总额
    order_status: //订单状态1: 已接单,10:收集工商注册材料,11:工商审核环节,12:刻章环节,13:证件邮寄环节,14:您已签收, 310: 部分已退款, 320: 已退款,330: 已作废
    {
      type: DataTypes.INTEGER,
      set: function (val) {
        this.setDataValue("order_status", val);
        this.setDataValue("order_status_name", PDICT.order_status[val]);
      }
    },
    order_status_name:DataTypes.STRING,
    notes: DataTypes.STRING,   //备注
    op_notes: DataTypes.STRING,   //操作备注
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      // updatedAt: true,
      // createdAt: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_order_info',
      validate: {

      },
      indexes: [
  
      ]
    });
}
