const system=require("../../../system");
const Dao=require("../../dao.base");
class OrderInfoDao extends Dao{
  constructor(){
    super(Dao.getModelName(OrderInfoDao));
  }
  //获取订单列表
  async getOrderList(ab){
    var pagesize = ab.Pagesize? Number(ab.Pagesize) : 10;
    var currentpage = ab.Currentpage? Number(ab.Currentpage) : 1;
    var offset = pagesize * (currentpage-1);

    var sortType="desc";
    if(ab.SortType && ab.SortType=="asc" ){//排序方式：desc ase
      sortType = "asc";
    }
    var sortItem = "updated_at";
    if(ab.SortItem && ab.SortItem == "payTime"){
      sortItem="pay_time";
    }
    if(ab.SortItem && ab.SortItem == "endTime"){
      sortItem="end_time";
    }
    var params = {
      product_type:ab.ProductType,
      user_id:ab.UserId,
      limit:pagesize,
      offset:offset
    };
    var sqlcount = "select count(1) as dataCount from v_order_oproduct_odelivery where product_type=:product_type and user_id=:user_id";
    
    var sql = "SELECT order_num,region_name,region_id,total_sum,delivery_status,pay_time,end_time,time_span,time_unit,updated_at,order_snapshot "+
    " from v_order_oproduct_odelivery where product_type=:product_type and user_id=:user_id";
    if(ab.ProductType=="/ic/gsreg/"){//公司注册筛选条件
      if(ab.CompanyProperties){//公司性质
        sql = sql +" and order_snapshot->'$.companyProperties' =:companyProperties ";
        sqlcount = sqlcount +" and order_snapshot->'$.companyProperties' =:companyProperties ";
        params["companyProperties"]=ab.CompanyProperties;
      }
      if(ab.TaxpayerType){//纳税人类型
        sql = sql +" and order_snapshot->'$.taxpayerType' =:taxpayerType ";
        sqlcount = sqlcount +" and order_snapshot->'$.taxpayerType' =:taxpayerType ";
        params["taxpayerType"]=ab.TaxpayerType;
      }
    }
    if(ab.ProductType=="/ic/cpreg/"){//云上园区注册
      if(ab.TaxpayerType){//纳税人类型
        sql = sql +" and order_snapshot->'$.taxpayerType' =:taxpayerType ";
        sqlcount = sqlcount +" and order_snapshot->'$.taxpayerType' =:taxpayerType ";
        params["taxpayerType"]=ab.TaxpayerType;
      }
      if(ab.RegisteredType){//注册类型
        sql = sql +" and order_snapshot->'$.registeredType' =:registeredType ";
        sqlcount = sqlcount +" and order_snapshot->'$.registeredType' =:registeredType ";
        params["registeredType"]=ab.RegisteredType;
      }
    }
    if(ab.DeliveryStatus){//当前状态
      sql = sql +" and delivery_status =:delivery_status ";
      sqlcount = sqlcount +" and delivery_status =:delivery_status ";
      params["delivery_status"]=ab.DeliveryStatus;
    }
    sql = sql +" order by "+sortItem+" "+sortType+"  limit :limit offset :offset ";
    var list = await this.customQuery(sql,params);
    var result = system.getResultSuccess(list);
    var tmpResultCount = await this.customQuery(sqlcount, params);
    result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return result;
  }
  //获取资质订单列表
  async getQcOrderList(ab){
    var pagesize = ab.Pagesize? Number(ab.Pagesize) : 10;
    var currentpage = ab.Currentpage? Number(ab.Currentpage) : 1;
    var offset = pagesize * (currentpage-1);

    var sortType="desc";
    if(ab.SortType && ab.SortType=="asc" ){//排序方式：desc ase
      sortType = "asc";
    }
    var sortItem = "updated_at";
    if(ab.SortItem && ab.SortItem == "payTime"){
      sortItem="pay_time";
    }
    if(ab.SortItem && ab.SortItem == "endTime"){
      sortItem="end_time";
    }
    var params = {
      user_id:ab.UserId,
      limit:pagesize,
      offset:offset
    };
    var sqlcount = "select count(1) as dataCount from v_order_oproduct_odelivery where (product_type = '/qcfw/icp/' or product_type = '/qcfw/edi/') and user_id=:user_id";
    
    var sql = "SELECT product_type,order_num,delivery_status,updated_at,order_snapshot,deliver_content "+
    " from v_order_oproduct_odelivery where (product_type = '/qcfw/icp/' or product_type = '/qcfw/edi/') and user_id=:user_id";
    if(ab.ProductType=="/qcfw/icp/"){//icp
      sql = sql +" and product_type = :productType ";
      sqlcount = sqlcount +" and product_type = :productType ";
      params["productType"]=ab.ProductType;
    }
    if(ab.ProductType=="/qcfw/edi/"){//edi
      sql = sql +" and product_type = :productType ";
      sqlcount = sqlcount +" and product_type = :productType ";
      params["productType"]=ab.ProductType;
    }
    if(ab.CompanyName){//公司名称
      sql = sql +" and deliver_content->'$.proposerInfo' is not null and deliver_content->'$.proposerInfo.businessLicense' is not null and  deliver_content->'$.proposerInfo.businessLicense.name' like :companyName ";
      sqlcount = sqlcount +" and deliver_content->'$.proposerInfo' is not null and deliver_content->'$.proposerInfo.businessLicense' is not null and  deliver_content->'$.proposerInfo.businessLicense.name' like :companyName ";
      params["companyName"]="%"+ab.CompanyName+"%";
    }
    if(ab.DeliveryStatus){//当前状态
      sql = sql +" and delivery_status =:delivery_status ";
      sqlcount = sqlcount +" and delivery_status =:delivery_status ";
      params["delivery_status"]=ab.DeliveryStatus;
    }
    sql = sql +" order by "+sortItem+" "+sortType+"  limit :limit offset :offset ";
    var list = await this.customQuery(sql,params);
    var result = system.getResultSuccess(list);
    var tmpResultCount = await this.customQuery(sqlcount, params);
    result.dataCount = tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
    return result;
  }
  //获取产品详情
  async selPrice2TX(obj) {
    var sql = "select   xp.product_icon product_icon, xp.path_name path_name, xp.servicer_code servicer_code, xp.servicer_name servicer_name,xs.push_domain_addr push_domain_addr from x_product xp JOIN x_service_info xs ON xp.servicer_code=xs.servicer_code "
    sql += "where path_code=:path_code and region_id=:region_id ";
    try {
      var list = await this.customQuery(sql, obj);
      var rtn = {};
      if (list && list.length > 0) {
        rtn.product_icon = list[0].product_icon;
        rtn.product_type_name = list[0].path_name;
        rtn.servicer_code = list[0].servicer_code;
        rtn.servicer_name = list[0].servicer_name;
        rtn.push_domain_addr = list[0].push_domain_addr;
        return system.getResultSuccess(rtn);
      } else {
        return system.getResultFail(-203, "servicer is empty");
      }
    } catch (error) {
      return system.getResultFail(-203, error);
    }
  }

  //订单表新增信息
  async addOrderInfo(pobj){
    var insertObj = {
      created_at:new Date(),
      servicer_code:pobj.servicer_code,
      order_num:pobj.order_num
    }
    var sql = "insert into x_order_info (servicer_code,order_num,created_at) values(:servicer_code,:order_num,:created_at)"
    var result = await this.customInsert(sql,insertObj);
    return result;

  }

  //根据产品统计订单数量（概览数据使用）
  async findOrderCountByProductPathCode(pathCode,userId){
    var params = {
      product_type:pathCode,
      userId:userId
    };
    var sql = "select count(1) as dataCount from v_order_orderproduct where deleted_at is null and product_type = :product_type "+
    " and user_id = :userId ";
    var tmpResultCount = await this.customQuery(sql, params);
    return tmpResultCount && tmpResultCount.length > 0 ? tmpResultCount[0].dataCount : 0;
  }
}
module.exports=OrderInfoDao;
