var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class needApi extends APIBase {
    constructor() {
        super();
        this.needSolutionSve = system.getObject("service.need.needSolutionSve");
        this.needInfoSve = system.getObject("service.need.needInfoSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess("测试接口");
                break;
            case "needSubmit"://提交需求
                opResult = await this.needInfoSve.needSubmit(pobj.actionBody);
                break;
            case "needList"://需求列表
                opResult = await this.needInfoSve.needList(pobj.actionBody);
                break;
            case "needDetail"://需求详情
                opResult = await this.needInfoSve.needDetail(pobj.actionBody);
                break;
            case "refusalSolution"://驳回方案
                opResult = await this.needSolutionSve.refusalSolution(pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = needApi;
