var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class Need extends APIBase {
    constructor() {
        super();
        this.txPushLogSve = system.getObject("service.common.txPushLogSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.interface || !pobj.interface.interfaceName) {
            return system.getResultTX(-1,"","interfaceName参数不能为空",null);
        }
        var result = await this.opActionProcess(pobj, pobj.interface.interfaceName, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "qcloud.domain.checkCreate"://新购参数检查
                opResult = await this.txPushLogSve.checkCreate(pobj);
                break;
            case "qcloud.cbs.CreateCbsInstance"://支付回调
                opResult = await this.txPushLogSve.createCbsInstance(pobj);
                break;
            case "qcloud.PRODUCT_NAME.queryFlow"://发货状态查询
                opResult = await this.txPushLogSve.queryFlow(pobj);
                break;
            case "qcloud.PRODUCT_NAME.isolateResource"://资源隔离
                opResult = await this.txPushLogSve.isolateResource(pobj);
                break;
            case "qcloud.PRODUCT_NAME.queryResources"://资源拉取
                opResult = await this.txPushLogSve.queryResources(pobj);
                break;
            case "qcloud.PRODUCT_NAME.destroyResource"://销毁资源
                opResult = await this.txPushLogSve.destroyResource(pobj);
                break;
            default:
                opResult = system.getResultTX(-1,"","未知方法名",null);
                break;
        }
        return opResult;
    }

}
module.exports = Need;
