var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends APIBase {
    constructor() {
        super();
        this.utilsProductSve = system.getObject("service.utilsSve.utilsProductSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "getProductList"://通过产品类别编码路径获取产品列表
                opResult = await this.utilsProductSve.getProductList(pobj, pobj.actionBody);
                break;
            case "getProductDetail"://根据渠道产品编码获取产品详情
                opResult = await this.utilsProductSve.getProductDetail(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = ProductAPI;