var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
/**
 * 用户端调用订单相关接口
 */
class Order extends APIBase {
    constructor() {
        super();
        this.orderdeliverySve = system.getObject("service.order.orderDeliverySve");
        this.orderinfoSve = system.getObject("service.order.orderInfoSve");
        this.applyinfoSve = system.getObject("service.order.applyInfoSve");
        this.utilsMsgSendSve = system.getObject("service.utilsSve.utilsMsgSendSve");
        this.qualificationCertificateSve = system.getObject("service.order.qualificationCertificateSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        var verificationCodeList = [
              "submitGoodsinfo"
        ];
        var self = this;
        if (verificationCodeList.indexOf(action_type) > -1) {
            if (!pobj.actionBody.Info) {
                return system.getResultFail(-101, "Info is empty");
              }
              pobj.actionBody.Info = JSON.parse(pobj.actionBody.Info);
            if (!pobj.actionBody.Info[0].formInfo.contactsPhone) {
                opResult = system.getResult(null, "contactsPhone参数错误");
                return opResult;
            }
            if (pobj.actionBody.VerificationCode) {
                var v = await self.utilsMsgSendSve.getVerificationCode(pobj.actionBody.Info[0].formInfo.contactsPhone);
                if (v != pobj.actionBody.VerificationCode) {
                    opResult = system.getResult(null, "验证码错误");
                    return opResult;
                }
            }
        }
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess("测试接口");
                break;
            case "getOrderDetail"://用户端查看订单详情
                opResult = await this.orderinfoSve.getOrderDetail(pobj);
                break;
            case "getQcOrderList"://用户端查看资质证照订单列表
                opResult = await this.orderinfoSve.getQcOrderList(pobj);
                break;
            case "getOrderList"://用户端获取订单列表
                opResult = await this.orderinfoSve.getOrderList(pobj);
                break;
            case "getApplyListByUserAndType"://用户端获取申请主体列表
                opResult = await this.applyinfoSve.getApplyListByUserAndType(pobj);
                break;
            case "getApplyAndSolutionInfo"://公司/个体户详情
                opResult = await this.applyinfoSve.getApplyAndSolutionInfo(pobj);
                break;
            case "selPrice2TX"://商城询价接口
                opResult = await this.orderinfoSve.selPrice2TX(pobj);
                break;
            case "submitGoodsinfo"://立即购买
                opResult = await this.orderinfoSve.submitGoodsinfo(pobj);
                break;
            case "getOverviewInfoByUser"://获取概览数据
                opResult = await this.applyinfoSve.getOverviewInfoByUser(pobj);
                break;
            case "getOrderListByStatus"://根据交付状态获取订单列表（概览数据待收文件->待收文件订单列表）
                opResult = await this.orderdeliverySve.getOrderListByStatus(pobj);
                break;
            case "orderPayNotify"://发货回调
                opResult = await this.orderinfoSve.orderPayNotify(pobj);
                break;
            case "getQualificationCertificateListByUserAndType"://用户获取资质证照列表
                opResult = await this.qualificationCertificateSve.getQualificationCertificateListByUserAndType(pobj);
                break;
            case "getQualificationCertificateDetail"://用户获取资质证照详情
                opResult = await this.qualificationCertificateSve.getQualificationCertificateDetail(pobj);
                break;
            case "refundOrder"://退款接口
                opResult = await this.orderinfoSve.refundOrder(pobj.actionBody);
                break;
            case "jftime"://计费时间修改
                opResult = await this.orderinfoSve.jftime(pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = Order;
