var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class CommonMsgSend extends APIBase {
    constructor() {
        super();
        this.utilsMsgSendSve = system.getObject("service.utilsSve.utilsMsgSendSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj, actionType, actionBody, req) {
        if (!actionBody) {
            return system.getResult(null, "actionBody参数不能为空");
        }
        var keyCount = Object.keys(actionBody).length;
        if (keyCount === 0) {
            return system.getResult(null, "actionBody参数不能为空!");
        }
        var opResult = null;
        switch (actionType) {
            case "test"://测试
                opResult = system.getResultSuccess("测试接口");
                break;
            case "sendVerificationCode"://发送验证码
                opResult = await this.utilsMsgSendSve.sendVerificationCode(actionBody.PhoneNumber);
                break;
            case "sendManage":
                opResult = await this.utilsMsgSendSve.sendMessageVerify(actionBody);
                break;
            default:
                opResult = system.getResult(null, "actionType参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = CommonMsgSend;
