const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class FeeService extends ServiceBase {
  constructor() {
    super();
    // 引擎不可以引用任何
  }

  /**
   * 账户查询
   * @param params
   * account_id: 账户id
   * @returns
   */
  async account(params) {
    try {
      return await this.callms("engine_fee", "accountInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * @param params
   * {
   *     "currentPage": 1,
   *     "pageSize": 10,
   *     "account_id": "1",
   *     "trade_type": "1",
   *     "trade_no": "123313",
   *     "tradeTimeBegin": "2020-06-26 04:21:31",
   *     "tradeTimeEnd": "2020-06-26 05:11:31"
   * }
   * @returns
   */
  async accountTradePage(params) {
    try {
      return await this.callms("engine_fee", "accountTrade", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * account_id
   * @param params
   * {
   *     "account_id": "1",
   *     "trade_type": "1",
   *     "trade_nos": ['1','2'],
   * }
   * @returns {Promise<{msg: string, data: (*|null), bizmsg: string, status: number}|{msg: string, data, bizmsg: *|string, status: number}|any|undefined>}
   */
  async tradeMapByIds(params) {
    try {
      return await this.callms("engine_fee", "tradeMapByIds", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

}

module.exports = FeeService;