const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("oplog", {
    appid: DataTypes.STRING,
    appkey: DataTypes.STRING,
    requestId: DataTypes.STRING,
    logLevel: {
      type: DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.logLevel),
      defaultValue: "info",
    },
    op: DataTypes.STRING,
    content: DataTypes.STRING(5000),
    resultInfo: DataTypes.TEXT,
    clientIp: DataTypes.STRING,
    agent: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    opTitle: DataTypes.STRING(500),
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'op_log',
      validate: {

      },
      indexes: [
      ]
    });
}
