const system = require("../../../system");
const Dao = require("../../dao.base");

class UserDao extends Dao {
  constructor() {
    super(Dao.getModelName(UserDao));
  }



  /**
   * 条件查询
   * @param {} params
   */
  async findUser(params) {
    let sql = [];
    sql.push("SELECT");
    sql.push(params.attrs || "*");
    sql.push("FROM uc_user");
    sql.push("where 1 = 1");
    if (params.ucname) {
      sql.push("AND ucname = :ucname");
    }
    if (params.uctype) {
      sql.push("AND uctype = :uctype");
    }
    if (params.is_enabled) {
      sql.push("AND is_enabled = :is_enabled");
    }
    sql.push(`AND (deleted_at > NOW() or deleted_at is null)`);
    return await this.customQuery(sql.join(" "), params);
  }

  async getByUcname(ucname, uctype) {
    var sql = "SELECT * FROM uc_user WHERE ucname = :ucname AND uctype = :uctype AND deleted_at IS NULL";
    var list = await this.customQuery(sql, {
      ucname: ucname,
      uctype: uctype,
    });
    if (!list || list.length == 0) {
      return null;
    }

    return list[0];
  }

  async countByCondition(params) {
    var sql = [];
    sql.push("SELECT");
    sql.push("count(1) as num");
    sql.push("FROM uc_user t1");
    sql.push("WHERE t1.deleted_at IS NULL");

    this.setCondition(sql, params);

    var list = await this.customQuery(sql.join(" "), params);
    if (!list || list.length == 0) {
      return 0;
    }
    return list[0].num;
  }

  async listByCondition(params) {
    params.startRow = Number(params.startRow || 0);
    params.pageSize = Number(params.pageSize || 10);

    var sql = [];
    sql.push("SELECT");
    sql.push("t1.*");
    sql.push("FROM uc_user t1");
    sql.push("WHERE t1.deleted_at IS NULL");

    this.setCondition(sql, params);

    sql.push("ORDER BY t1.id DESC");
    sql.push("LIMIT :startRow, :pageSize");
    return await this.customQuery(sql.join(" "), params);
  }

  setCondition(sql, params) {
    if (!params || !sql) {
      return;
    }
    if (params.uctype) {
      sql.push("AND t1.uctype = :uctype");
    }

    if (params.uctype_id) {
      sql.push("AND t1.uctype_id = :uctype_id");
    }

    if (params.ucname) {
      sql.push("AND t1.ucname LIKE :ucname");
    }

    if (params.mobile) {
      sql.push("AND t1.mobile LIKE :mobile");
    }

    if (params.real_name) {
      sql.push("AND t1.real_name LIKE :real_name");
    }

    if (params.createBegin) {
      sql.push("AND t1.created_at >= :createBegin");
    }

    if (params.createEnd) {
      sql.push("AND t1.created_at <= :createEnd");
    }

    if (params.is_enabled === 0 || params.is_enabled === 1) {
      sql.push("AND t1.is_enabled = :is_enabled");
    }

    if (params.orgpath) {
      sql.push("AND t1.orgpath LIKE :orgpath");
    }
  }

  async findMapByIds(ids, attrs) {
    let result = {};
    if (!ids || ids.length == 0) {
      return result;
    }
    let sql = [];
    sql.push("SELECT");
    sql.push(attrs || "*");
    sql.push("FROM uc_user t1");
    sql.push("WHERE t1.id IN (:ids)");

    var list = await this.customQuery(sql.join(" "), {
      ids: ids
    });
    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      result[item.id] = item;
    }
    return result;
  }

  async updateOrg(org_id, orgpath) {
    let sql = "UPDATE uc_user SET orgpath = :orgpath WHERE org_id = :org_id";
    await this.customUpdate(sql, {org_id: org_id, orgpath: orgpath});
  }
}

module.exports = UserDao;