{
  template:'${tmpl}',
  data:function(){
      return {
        sourcecode:"",
        business:{},
        bclist:[],
        bus_company:{},
        showCustomerIntention:false,
        customerIntention:{
          customer_intention:"",
          notes:"",
        }
        
        
      }
  },
  computed: Vuex.mapState({
    count:state=>state.count,
    headStyle:function(){
      return {"background-color":"white"};
    }
  }),
  created:function(){

  },
  mounted:function(){
    var that=this;
    var sourcecode=this.$router.history.current.query.sourcecode;
    if(sourcecode){
      this.sourcecode=sourcecode;
      this.getBusinessDetail();
    }else{
      this.$message.warning("sourcecode参数错误！");
      this.$root.pushx({
        title:"平台线索池",
        name:"/businesscompany"
      });
      return;
    }
  },
  methods:{
    applyProtect(){
      var that=this;
      var code = this.sourcecode;
      var bus_type = this.bus_company.tm_company_type;
      if(!code){
        this.$message.warning("商机code参数错误");
        return;
      }
      if(!bus_type){
        this.$message.warning("商机bus_type参数错误");
        return;
      }
      this.$root.postReq("/web/businesscompanyCtl/protectBus", { code_list:[code], bus_type:bus_type}).then(function (d) {
        console.log(d);
        if (d && d.code == 1) {
          that.$message.success("操作成功");
          that.getBusinessDetail();
        } else {
          that.$message.warning(d.msg);
        }
      }).catch(function (e) {
        console.log(e);
        that.$message.warning("操作失败");
      });
    },
    invalidBusiness(key){
      var that = this;
      if(key=="business"){
        console.log("商机无效");
        this.$confirm('点击确认后，该条商机将被删除，可能会错过一次业务良机哦~', '无效商机', {
          confirmButtonText: '确定',
          cancelButtonText: '取消',
          type: 'warning'
        }).then(() => {
          this.$root.postReq("/web/businesscompanyCtl/updateBusinessStatus", { code:this.sourcecode, opType:2}).then(function (d) {
            console.log(d);
            if (d && d.code == 1) {
              that.$message.success("操作成功");
              that.$root.pushx({
                title:"我的商机",
                name:"/mybusiness"
              });
              return;
            } else {
              that.$message.warning(d.msg);
            }
          }).catch(function (e) {
            console.log(e);
            that.$message.warning("操作失败");
          });
        })
      }else if(key=="mobile"){
        console.log("电话无效");
        this.$confirm('很遗憾，该条商机电话无效，给您的不便敬请谅解，我们会不断提高商机质量！', '电话无效', {
          confirmButtonText: '确定',
          cancelButtonText: '取消',
          type: 'warning'
        }).then(() => {
          this.$root.postReq("/web/businesscompanyCtl/updateBusinessStatus", { code:this.sourcecode, opType:1}).then(function (d) {
            console.log(d);
            if (d && d.code == 1) {
              that.$message.success("操作成功");
              that.$root.pushx({
                title:"我的商机",
                name:"/mybusiness"
              });
              return;
            } else {
              that.$message.warning(d.msg);
            }
          }).catch(function (e) {
            console.log(e);
            that.$message.warning("操作失败");
          });
        })
      }
    },
    showCustomerIntentionDialog(){
      console.log(this.customerIntention.customer_intention);
      this.customerIntention={
        customer_intention:"",
        notes:"",
      };
      this.showCustomerIntention=true;
    },
    changeCustomerIntention(value){
      this.customerIntention.customer_intention=value;
      console.log(this.customerIntention.customer_intention);
      console.log(value);
    },
    submitCustomerIntention(){
      var that=this;
      if(!this.customerIntention.customer_intention){
        this.$message.warning("请选择客户意向");
        return;
      }
      this.$root.postReq("/web/businesscompanyCtl/submitCustomerIntention",{code:this.sourcecode,customer_intention:this.customerIntention.customer_intention,notes:this.customerIntention.notes} ).then(function (d) {
        console.log(d);
        if (d && d.code == 1) {
          that.getBusinessDetail();
          that.$message.success("操作成功");
          that.showCustomerIntention=false;
          
          return;
        } else {
          that.$message.warning(d.msg);
        }
      }).catch(function (e) {
        console.log(e);
        that.$message.warning("操作失败");
      });
    },
    formatTime(data){
      if(data){
        var d = new Date(data);
        var datetime=d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate();
        return datetime;
      }else{
        return "";
      }
      
    },
    getBusinessDetail(){
      var that = this;
      this.$root.showMask();
      this.$root.postReq("/web/businesscompanyCtl/getBusinessDetail",{sourceCode:this.sourcecode}).then(d=>{
        console.log(d);
        if(d && d.code==1){
          for(var i=0;i<d.data.biList.length;i++){
            if(d.data.biList[i].regist_notice_day){
              d.data.biList[i].regist_notice_day = that.formatTime(d.data.biList[i].regist_notice_day);
            }
            d.data.biList[i].tm_end_day = that.formatTime(d.data.biList[i].tm_end_day);
          }
          for(var i=0;i<d.data.bnList.length;i++){
            if(d.data.bnList[i].created_at){
              d.data.bnList[i].created_at = that.formatTime(d.data.bnList[i].created_at);
            }
          }
          that.business=d.data;
          
          var bc = d.data.bc;
          that.bus_company=bc;
          console.log(bc.customer_intention);
          that.customerIntention["customer_intention"]=bc.customer_intention || "";
          if(bc && bc.mobile_list){
            console.log(bc.mobile_list);
            var mobile = bc.mobile_list;
            mobile=JSON.parse(mobile);
            bc.mobile_list=mobile.join(",");
          }
          if(bc && bc.company_mail){
            console.log(bc.company_mail);
            var mail = bc.company_mail;
            mail=JSON.parse(mail);
            bc.company_mail=mail.join(",");
          }
          if(bc){
            if(bc.tm_end_day_min){
              bc.tm_end_day_min = that.formatTime(bc.tm_end_day_min);
            }
            if(bc.tm_end_day_max){
              bc.tm_end_day_max = that.formatTime(bc.tm_end_day_max);
            }
            if(bc.tm_end_day_max && bc.tm_end_day_min){
              bc.tm_end_day_min = bc.tm_end_day_min+"至"+bc.tm_end_day_max;
            }
            if(bc.claim_time){
              bc.claim_time = that.formatTime(bc.claim_time);
            }
            if(bc.recovery_time){
              bc.recovery_time = that.formatTime(bc.recovery_time);
            }
          }
          that.bclist=[bc];
        }else{
          that.$message.warning(d.msg);
        }
        that.$root.hideMask();
      }).catch(e=>{
        console.log(e);
        that.$root.hideMask();
        that.$message.warning("操作失败");
      });
    },
    toOrder(key,id){
      var bc = this.business.bc;
      if(id && bc && bc.sve_item_code){
        if(key=="create"){
          console.log("去下单");
          this.$root.pushx({
            title:"商机订单",
            name:"/businesstmorder",
            params:{
              id:id,key:key,sve_item_code:bc.sve_item_code
            }
          });
        }else if(key=="detail"){
          console.log("商机订单详情");
          this.$root.pushx({
            title:"商机订单",
            name:"/businesstmorder",
            params:{
              id:id,key:key,sve_item_code:bc.sve_item_code
            }
          });
        }
      }
      
    },
    
  },

  vname:"gsb-mybusinessdetail"
}
